jQuery(document).ready(function ($) {
    'use strict';
    $('.vi-ui.tabular.menu .item').vi_tab({
        history: true,
        historyType: 'hash'
    });
    $('.vi-ui.dropdown').dropdown({placeholder: ''});
    $('.wheel-settings .ui-sortable').sortable({
        update: function (event, ui) {
            indexChangeCal();
        }
    });

    /*Select White or Black list*/
    $('input[name="choose_using_white_black_list"]').on('change', function () {
        handle_choose_list($(this).val());
    });
    handle_choose_list($('input[name="choose_using_white_black_list"]').val());

    function handle_choose_list(intent) {
        let $white_list = $('[name="white_list"]').closest('tr');
        let $black_list = $('[name="black_list"]').closest('tr');
        switch (intent) {
            case 'white_list':
                $black_list.hide();
                $white_list.show();
                break;
            case 'black_list':
                $white_list.hide();
                $black_list.show();
                break;
        }
    }

    /*Select intent*/
    $('select[name="notify_intent"]').on('change', function () {
        handle_select_intent_value($(this).val());
    });
    handle_select_intent_value($('select[name="notify_intent"]').val());

    function handle_select_intent_value(intent) {
        let $ini_time = $('input[name="show_wheel"]').closest('tr');
        let $scroll_amount = $('input[name="scroll_amount"]').closest('tr');
        switch (intent) {
            case 'popup_icon':
            case 'show_wheel':
                $ini_time.closest('tr').fadeIn(200);
                $scroll_amount.closest('tr').fadeOut(200);
                break;
            case 'random':
                $ini_time.closest('tr').fadeIn(200);
                $scroll_amount.closest('tr').fadeIn(200);
                break;
            case 'on_scroll':
                $ini_time.closest('tr').fadeOut(200);
                $scroll_amount.closest('tr').fadeIn(200);
                break;
            case 'on_exit':
                $ini_time.closest('tr').fadeOut(200);
                $scroll_amount.closest('tr').fadeOut(200);
                break;
        }
    }
    
    /*select recaptcha version */
    jQuery('.wlwl_recaptcha_version').dropdown({
        onChange: function (val) {
            if (val == 2) {
                jQuery('.wlwl-recaptcha-v2-wrap').show();
                jQuery('.wlwl-recaptcha-v3-wrap').hide();
            } else {
                jQuery('.wlwl-recaptcha-v2-wrap').hide();
                jQuery('.wlwl-recaptcha-v3-wrap').show();
            }
        }
    });
    /*Color picker*/
    $('.color-picker').iris({
        change: function (event, ui) {
            $(this).parent().find('.color-picker').css({backgroundColor: ui.color.toString()});
        },
        hide: true,
        border: true
    }).click(function () {
        $('.iris-picker').hide();
        $(this).closest('td').find('.iris-picker').show();
    });
    $('body').click(function () {
        $('.iris-picker').hide();
    });
    $('.color-picker').click(function (event) {
        event.stopPropagation();
    });
    /*Select popup icon*/
    $('.wheel-popup-icon').on('click', function () {
        let $button = $(this), $container = $button.closest('.wheel-popup-icons-container');
        if ($button.hasClass('wheel-popup-icon-selected')) {
            $button.removeClass('wheel-popup-icon-selected').attr('style', '');
            $container.find('input[name="wheel_popup_icon"]').val('');
        } else {
            let $selected = $container.find('.wheel-popup-icon-selected');
            $container.find('input[name="wheel_popup_icon"]').val($button.data('wheel_popup_icon'));
            $button.addClass('wheel-popup-icon-selected').attr('style', $selected.attr('style'));
            $selected.attr('style', '').removeClass('wheel-popup-icon-selected');
        }
    });


    $('#wheel_popup_icon_color').iris({
        change: function (event, ui) {
            $(this).parent().find('.color-picker').css({backgroundColor: ui.color.toString()});
            $('.wheel-popup-icon-selected').css({color: ui.color.toString()});
        },
        hide: true,
        border: true
    });
    $('#wheel_popup_icon_bg_color').iris({
        change: function (event, ui) {
            $(this).parent().find('.color-picker').css({backgroundColor: ui.color.toString()});
            $('.wheel-popup-icon-selected').css({'background-color': ui.color.toString()});
        },
        hide: true,
        border: true
    });

    $(document).on('click', '.clone_piece', function () {
        let new_row = $(this).parent().parent().clone();
        let new_val = parseInt(new_row.find('input[name="probability[]"]').val());
        new_row.find('input[name="probability[]"]').val(new_val);
        new_row.insertAfter($(this).parent().parent());
        indexChangeCal();
        changes_probability();
        new_row.find('.vi-ui.dropdown').dropdown({placeholder: ''});
        new_row.find('.color-picker').iris({
            change: function (ev, uis) {
                $(this).parent().find('.color-picker').css({backgroundColor: uis.color.toString()});
            },
            hide: true,
            border: true,
            width: 270
        }).on('click', function (e) {
            e.stopPropagation();
        });
    });
    $(document).on('click', '.remove_field', function () {
        changes_probability();
        if (confirm("Would you want to remove this?")) {
            if ($('.wheel_col').length > 3) {
                $(this).closest('tr').remove();
                changes_probability();
                indexChangeCal();
            } else {
                alert('Must have at least 3 columns!');
                return false;
            }
        }
    });

    changes_probability();
    $(document).on('change', '.prize_quantity', function () {
        changes_probability();
    });
    $(document).on('change', '.probability', function () {
        changes_probability();
    });

    /**
     * Calculate probability
     */
    function changes_probability() {// check probability
        let tong = 0;
        let $probability = $('.probability');
        $probability.each(function () {
            let $current = $(this);
            let $row = $current.closest('tr');
            let $coupon_type = $row.find('select[name="coupon_type[]"]');
            let $prize_quantity = $row.find('input[name="prize_quantity[]"]');
            if ($coupon_type.val() === 'non' || parseInt($prize_quantity.val()) !== 0) {
                tong += parseInt($current.val());
            }
        });
        if (tong > 0) {
            $probability.each(function () {
                let $current = $(this);
                let $row = $current.closest('tr');
                let $coupon_type = $row.find('select[name="coupon_type[]"]');
                let $prize_quantity = $row.find('input[name="prize_quantity[]"]');
                let percent = 0;
                if ($coupon_type.val() === 'non' || parseInt($prize_quantity.val()) !== 0) {
                    let weigh = parseInt($current.val());
                    percent = roundResult(weigh * 100 / tong);
                }
                $row.find('.probability-percent').val(percent);
            });
        } else {
            $probability.each(function () {
                let $current = $(this);
                $current.closest('tr').find('.probability-percent').val(0);
            });
        }
    }

    function indexChangeCal() {
        let i = 1;
        $('.wheel-col-index').map(function () {
            $(this).html(i);
            i++;
        })
    }

    indexChangeCal();
    $('select[name="coupon_type[]"]').map(function () {
        let $current = $(this);
        let $selected = $current.find(`option[value="${$current.val()}"]`);
        if ($selected.data('coupon_amount') !== undefined) {
            $current.closest('tr').find('input[name="coupon_amount[]"]').val($selected.data('coupon_amount'));
        }
    });
    $(document).on('change', 'select[name="coupon_type[]"]', function () {
        changes_probability();
        let $coupon_type = $(this);
        let $row = $coupon_type.closest('tr');
        let coupon_type = $coupon_type.val();
        switch (coupon_type) {
            case 'non':
                $row.attr('class', `wheel_col wheel_col-${coupon_type}`);
                $row.find('.coupon_amount').val(0).prop('readonly', true).addClass('coupon-amount-readonly');
                $row.find('.custom_type_label').val('Not Lucky');
                $row.find('select[name="email_templates[]"]').val('').trigger('change');
                break;
            case 'custom':
                $row.attr('class', `wheel_col wheel_col-${coupon_type}`);
                $row.find('.custom_type_value').val('');
                $row.find('.custom_type_label').val('');
                break;
            case 'existing_coupon':
                $row.attr('class', `wheel_col wheel_col-${coupon_type}`);
                $row.find('.custom_type_label').val(woo_lucky_wheel_params_admin.default_coupon_label);
                break;
            case 'percent':
            case 'fixed_product':
            case 'fixed_cart':
                $row.attr('class', `wheel_col wheel_col-${coupon_type}`);
                $row.find('.custom_type_label').val(woo_lucky_wheel_params_admin.default_coupon_label);
                $row.find('.coupon_amount').removeClass('coupon-amount-readonly').prop('readonly', false);
                break;
            default:
                $row.find('.coupon_amount').val($coupon_type.find(`option[value="${coupon_type}"]`).data('coupon_amount')).prop('readonly', true).addClass('coupon-amount-readonly');
                $row.attr('class', 'wheel_col wheel_col-dynamic_coupon');
        }
    });

    $('.wlwl_color_palette').on('click', function () {
        let color_array;
        let $wheel_col = $('.wheel_col');
        color_array = $(this).parent().children().map(function () {
            return $(this).attr('data-color_code');
        }).get();
        let color_size = color_array.length;
        let piece_color;
        piece_color = $wheel_col.find('input[name="bg_color[]"]').map(function () {
            return $(this).val();
        }).get();
        let piece_size = piece_color.length;
        let i;
        let j = 0;

        for (i = 0; i < piece_size; i++) {
            if (j == color_size) {
                j = 0;
            }
            $wheel_col.find('input[name="bg_color[]"]').eq(i).val(color_array[j]).css({'background-color': color_array[j]});
            j++;
        }
        $('.auto_color_ok').on('click', function () {
            $('.color_palette').hide();
            $('.auto_color_ok_cancel').hide();
            $('.auto_color').show();
        });
        $('.auto_color_cancel').on('click', function () {
            j = 0;
            for (i = 0; i < piece_size; i++) {
                if (j == color_size) {
                    j = 0;
                }
                $wheel_col.find('input[name="bg_color[]"]').eq(i).val(piece_color[j]).css({'background-color': piece_color[j]});
                j++;
            }
            $('.color_palette').hide();
            $('.auto_color_ok_cancel').hide();
            $('.auto_color').show();
        })
    });
    $('.auto_color').on('click', function () {
        $('.color_palette').css({'display': 'flex'});
        $('.auto_color_ok_cancel').css({'display': 'inline-block'});
        $(this).hide();
        $('.auto_color_ok').on('click', function () {
            $('.color_palette').hide();
            $('.auto_color_ok_cancel').hide();
            $('.auto_color').show();
        });
        $('.auto_color_cancel').on('click', function () {
            $('.color_palette').hide();
            $('.auto_color_ok_cancel').hide();
            $('.auto_color').show();
        })
    });
    $('.wlwl-button-save-settings-container').closest('form').on('submit', function () {
        let $label = $('.custom_type_label');
        let $coupon_type = $('select[name="coupon_type[]"]');
        for (let i = 0; i < $label.length; i++) {
            if ($label.eq(i).val() === '') {
                alert('Label cannot be empty.');
                $label.eq(i).focus();
                return false;

            }
            if ($coupon_type.eq(i).val() === 'custom' && $('.custom_type_value').eq(i).val() === '') {
                alert('Value cannot be empty.');
                $('.custom_type_value').eq(i).focus();
                return false;

            }
            if ($coupon_type.eq(i).val() === 'existing_coupon' && $('select[name="wlwl_existing_coupon[]"]')[i].lastElementChild.innerHTML == '') {
                alert('Value of Existing coupon cannot be empty.');
                $('select[name="wlwl_existing_coupon[]"]')[i].focus();
                return false;
            }
        }

        $('.wlwl-button-save-settings-container').find('button').addClass('loading');
    });

    function roundResult(number, round = 2) {
        let temp = Math.pow(10, round);
        return Math.round(number * temp) / temp;
    }

});

jQuery(document).ready(function ($) {
    // Set all variables to be used in scope
    var frame,
        metaBox = $('#wlwl-bg-image'), // Your meta box id here
        addImgLink = metaBox.find('.wlwl-upload-custom-img'),
        imgContainer = metaBox.find('#wlwl-new-image');

    // ADD IMAGE LINK
    addImgLink.on('click', function (event) {
        event.preventDefault();

        // If the media frame already exists, reopen it.
        if (frame) {
            frame.open();
            return;
        }

        // Create a new media frame
        frame = wp.media({
            title: 'Select or Upload Media Of Your Chosen Persuasion',
            button: {
                text: 'Use this media'
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });


        // When an image is selected in the media frame...
        frame.on('select', function () {

            // Get media attachment details from the frame state
            var attachment = frame.state().get('selection').first().toJSON();
            console.log(attachment);
            var attachment_url;
            if (attachment.sizes.thumbnail) {
                attachment_url = attachment.sizes.thumbnail.url;
            } else if (attachment.sizes.medium) {
                attachment_url = attachment.sizes.medium.url;
            } else if (attachment.sizes.large) {
                attachment_url = attachment.sizes.large.url;
            } else if (attachment.url) {
                attachment_url = attachment.url;
            }
            // Send the attachment URL to our custom image input field.
            imgContainer.append('<div class="wlwl-image-container"><img style="border: 1px solid;"class="review-images" src="' + attachment_url + '"/><input class="wheel_wrap_bg_image" name="wheel_wrap_bg_image" type="hidden" value="' + attachment.id + '"/><span class="wlwl-remove-image nagative vi-ui button">Remove</span></div>');

            $('.wlwl-upload-custom-img').hide();
            $('.wlwl-remove-image').on('click', function (event) {
                event.preventDefault();
                $(this).parent().html('');
                $('.wlwl-upload-custom-img').show();
            })

        });

        // Finally, open the modal on click
        frame.open();
    });
    // DELETE IMAGE LINK

    $('.wlwl-remove-image').on('click', function (event) {
        event.preventDefault();
        $(this).parent().html('');
        $('.wlwl-upload-custom-img').show();
    });
});
jQuery(document).ready(function ($) {
    // Set all variables to be used in scope
    var frame1,
        metaBox1 = $('#wlwl-bg-image1'), // Your meta box id here
        addImgLink1 = metaBox1.find('.wlwl-upload-custom-img1'),
        imgContainer1 = metaBox1.find('#wlwl-new-image1');

    // ADD IMAGE LINK
    addImgLink1.on('click', function (event) {
        event.preventDefault();

        // If the media frame already exists, reopen it.
        if (frame1) {
            frame1.open();
            return;
        }

        // Create a new media frame
        frame1 = wp.media({
            title: 'Select or Upload Media Of Your Chosen Persuasion',
            button: {
                text: 'Use this media'
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });


        // When an image is selected in the media frame...
        frame1.on('select', function () {

            // Get media attachment details from the frame state
            var attachment1 = frame1.state().get('selection').first().toJSON();
            console.log(attachment1);
            var attachment_url1;
            if (attachment1.sizes.thumbnail) {
                attachment_url1 = attachment1.sizes.thumbnail.url;
            } else if (attachment1.sizes.medium) {
                attachment_url1 = attachment1.sizes.medium.url;
            } else if (attachment1.sizes.large) {
                attachment_url1 = attachment1.sizes.large.url;
            }else if (attachment1.sizes.full) {
                attachment_url1 = attachment1.sizes.full.url;
            } else if (attachment1.url) {
                attachment_url1 = attachment1.url;
            }

            // Send the attachment URL to our custom image input field.
            imgContainer1.append('<div class="wlwl-image-container1"><img style="border: 1px solid;"class="review-images" src="' + attachment_url1 + '"/><input class="wheel_center_image" name="wheel_center_image" type="hidden" value="' + attachment1.id + '"/><span class="wlwl-remove-image1 nagative vi-ui button">Remove</span></div>');

            $('.wlwl-upload-custom-img1').hide();
            $('.wlwl-remove-image1').on('click', function (event) {
                event.preventDefault();
                $(this).parent().html('');
                $('.wlwl-upload-custom-img1').show();
            })

        });

        // Finally, open the modal on click
        frame1.open();
    });
    // DELETE IMAGE LINK

    $('.wlwl-remove-image1').on('click', function (event) {
        event.preventDefault();
        $(this).parent().html('');
        $('.wlwl-upload-custom-img1').show();
    });
    $(".suggested-product-search").select2({
        placeholder: "Please fill in your product title",
        ajax: {
            url: "admin-ajax.php?action=wlwl_search_suggested_product",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            delay: 250,
            data: function (params) {
                return {
                    keyword: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) {
            return markup;
        }, // let our custom formatter work
        minimumInputLength: 1
    });
    $(".category-search").select2({
        placeholder: "Please enter category title",
        ajax: {
            url: "admin-ajax.php?action=wlwl_search_cate",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            delay: 250,
            data: function (params) {
                return {
                    keyword: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) {
            return markup;
        }, // let our custom formatter work
        minimumInputLength: 1
    });
    $(".product-search").select2({
        closeOnSelect: false,
        placeholder: "Please fill in your product title",
        ajax: {
            url: "admin-ajax.php?action=wlwl_search_product",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            delay: 250,
            data: function (params) {
                return {
                    keyword: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) {
            return markup;
        }, // let our custom formatter work
        minimumInputLength: 1
    });
    $(".coupon-search").select2({
        placeholder: "Type coupon code here",
        ajax: {
            url: "admin-ajax.php?action=wlwl_search_coupon",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            delay: 250,
            data: function (params) {
                return {
                    keyword: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) {
            return markup;
        }, // let our custom formatter work
        minimumInputLength: 1
    });

    $(".wlwl-ac-search-list").select2({
        placeholder: "Type list name",
        ajax: {
            url: "admin-ajax.php?action=wlwl_search_active_campaign_list",
            dataType: 'json',
            type: "GET",
            quietMillis: 50,
            delay: 250,
            data: function (params) {
                return {
                    keyword: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) {
            return markup;
        }, // let our custom formatter work
        minimumInputLength: 1,
        allowClear: true
    });

//    select google font
    $('#wlwl-google-font-select').fontselect().change(function () {
        // replace + signs with spaces for css
        $('#wlwl-google-font-select').val($(this).val());
        $('.wlwl-google-font-select-remove').show();
    });
    $('.wlwl-google-font-select-remove').on('click', function () {
        $(this).parent().find('.font-select span').html('<span>Select a font</span>');
        $('#wlwl-google-font-select').val('');
        $(this).hide();
    });
    /*design button "shop now"*/
    var buttonShopNow = $('.wlwl-button-shop-now');
    $('#wlwl_button_shop_title').on('keyup', function () {
        buttonShopNow.html($(this).val());
    });
    $('#wlwl_button_shop_url').on('keyup', function () {
        buttonShopNow.attr('href', $(this).val());
    });
    $('#wlwl_button_shop_size').on('change', function () {
        buttonShopNow.css('font-size', $(this).val() + 'px');
    });
    /*Color picker*/
    $('#wlwl_button_shop_color').iris({
        change: function (event, ui) {
            $(this).parent().find('.color-picker').css({backgroundColor: ui.color.toString()});
            buttonShopNow.css({'color': ui.color.toString()});
        },
        hide: true,
        border: true
    }).click(function (event) {
        event.stopPropagation();
        $('.iris-picker').hide();
        $(this).closest('td').find('.iris-picker').show();
    });
    $('#wlwl_button_shop_bg_color').iris({
        change: function (event, ui) {
            $(this).parent().find('.color-picker').css({backgroundColor: ui.color.toString()});
            buttonShopNow.css({'background-color': ui.color.toString()});
        },
        hide: true,
        border: true
    }).click(function (event) {
        event.stopPropagation();
        $('.iris-picker').hide();
        $(this).closest('td').find('.iris-picker').show();
    });

    $('.preview-emails-html-overlay').on('click', function () {
        $('.preview-emails-html-container').addClass('preview-html-hidden');
    });
    $('.wlwl-preview-emails-button').on('click', function () {
        let button = $(this);
        let old_preview_text = button.html();
        button.html('Please wait...');
        let language = button.data()['wlwl_language'];
        let suggested_products = $('#wlwl_suggested_products').val();
        $.ajax({
            url: woo_lucky_wheel_params_admin.url,
            type: 'GET',
            dataType: 'JSON',
            data: {
                action: 'wlwl_preview_emails',
                heading: $('#heading' + language).val(),
                footer_text: $('#footer_text' + language).val(),
                content: tinyMCE.get('content' + language) ? tinyMCE.get('content' + language).getContent() : $('#content' + language).val(),
                button_shop_size: $('#wlwl_button_shop_size').val(),
                button_shop_color: $('#wlwl_button_shop_color').val(),
                button_shop_bg_color: $('#wlwl_button_shop_bg_color').val(),
                button_shop_title: $('#wlwl_button_shop_title' + language).val(),
                button_shop_url: $('#wlwl_button_shop_url' + language).val(),
                suggested_products: suggested_products ? suggested_products : [],
            },
            success: function (response) {
                button.html(old_preview_text);
                if (response) {
                    $('.preview-emails-html').html(response.html);
                    $('.preview-emails-html-container').removeClass('preview-html-hidden');
                }
            },
            error: function (err) {
                button.html(old_preview_text);
            }
        })
    });

    /*preview wheel*/
    $('.woocommerce-lucky-wheel-preview-overlay').on('click', function () {
        $('.woocommerce-lucky-wheel-preview').addClass('preview-html-hidden');
    });
    $('.preview-lucky-wheel').on('click', function () {
        $(this).addClass('loading');
        let prize_quantity = [];
        $('input[name="prize_quantity[]"]').map(function () {
            prize_quantity.push($(this).val());
        });
        let color = [];
        $('input[name="bg_color[]"]').map(function () {
            color.push($(this).val());
        });
        let slices_text_color = [];
        $('input[name="slices_text_color[]"]').map(function () {
            slices_text_color.push($(this).val());
        });
        let label = [];
        $('input[name="custom_type_label[]"]').map(function () {
            label.push($(this).val());
        });
        let coupon_type = [];
        $('select[name="coupon_type[]"]').map(function () {
            coupon_type.push($(this).val());
        });
        let coupon_amount = [];
        $('input[name="coupon_amount[]"]').map(function () {
            coupon_amount.push($(this).val());
        });
        $.ajax({
            url: woo_lucky_wheel_params_admin.url,
            type: 'GET',
            dataType: 'JSON',
            data: {
                action: 'wlwl_preview_wheel',
                label: label,
                coupon_type: coupon_type,
                coupon_amount: coupon_amount,
                prize_quantity: prize_quantity,
                quantity_label: $('input[name="quantity_label"]').val(),
            },
            success: function (response) {
                $('.preview-lucky-wheel').removeClass('loading');
                let font_size = $('#font_size').val();
                let wlwl_center_color = $('#wheel_center_color').val();
                let wlwl_border_color = $('#wheel_border_color').val();
                let wlwl_dot_color = $('#wheel_dot_color').val();
                let slices = color.length;
                let sliceDeg = 360 / slices;
                let deg = -(sliceDeg / 2);
                let cv = document.getElementById('wlwl_canvas');
                let ctx = cv.getContext('2d');
                let width = 400;// size
                cv.width = width;
                cv.height = width;
                let center = (width) / 2;
                let wheel_text_size = parseInt(width / 28) * parseInt(font_size) / 100;
                if (response.labels) {
                    let labels = response.labels;
                    /*--17-12-2021--*/
                    /*let  aaaa = [
                        'https://www.iconpacks.net/icons/1/free-pin-icon-48-thumb.png',
                        'https://i.pinimg.com/originals/b7/02/af/b702afc7b811840ebc49037cdc98bc45.jpg',
                        'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTQ0I02k1xtKHJvSPeKq2-O5frFZX5JGYvLt0ziLlcYJnf2wLrT-CHL5Xz2xDw5Oub0Azc&usqp=CAU',
                        'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTuIrqBloKaLyIB9rg58pse66yWPiBalRWU_f6lYnDxs63G1MNLdhHBB3ZIbDVmKe0K2Qw&usqp=CAU',
                        'data:image/jpeg;base64,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'
                    ];*/
                    for (let i = 0; i < slices; i++) {
                        drawSlice(ctx, deg, color[i]);
                        /*--17-12-2021--*//*
                        drawImages(ctx, deg + sliceDeg / 2, aaaa[i]);*/
                        drawText(ctx, deg + sliceDeg / 2, labels[i], slices_text_color[i], wheel_text_size);
                        deg += sliceDeg;

                    }
                    cv = document.getElementById('wlwl_canvas1');
                    ctx = cv.getContext('2d');
                    cv.width = width;
                    cv.height = width;
                    drawPoint(ctx, deg, wlwl_center_color);
                    let center_image = $('input[name="wheel_center_image"]').parent().find('img').attr('src');
                    if (center_image) {
                        let wl_image = new Image;
                        wl_image.onload = function () {
                            cv = document.getElementById('wlwl_canvas1');
                            ctx = cv.getContext('2d');
                            let image_size = 2 * (width / 8 - 7);
                            ctx.arc(center, center, image_size / 2, 0, 2 * Math.PI);
                            ctx.clip();
                            ctx.drawImage(wl_image, center - image_size / 2, center - image_size / 2, image_size, image_size);

                        };
                        wl_image.src = center_image;
                    }
                    drawBorder(ctx, wlwl_border_color, 'rgba(0,0,0,0)', 20, 4, 5, 'rgba(0,0,0,0.2)');
                    cv = document.getElementById('wlwl_canvas2');
                    ctx = cv.getContext('2d');

                    cv.width = width;
                    cv.height = width;
                    drawBorder(ctx, 'rgba(0,0,0,0)', wlwl_dot_color, 20, 4, 5, 'rgba(0,0,0,0)');

                    $('.woocommerce-lucky-wheel-preview').removeClass('preview-html-hidden');
                }

                function deg2rad(deg) {
                    return deg * Math.PI / 180;
                }
                /*--17-12-2021--*/
               /* function drawImages(ctx, deg, imgArg) {
                    let newImageItem = new Image();
                    newImageItem.onload=function(){
                        console.log(deg);
                        console.log(deg2rad(deg));
                        ctx.save();
                        ctx.translate(center, center);
                        ctx.rotate(deg2rad(deg));
                        ctx.drawImage(newImageItem, width/3, 0 ,30,20  );
                        ctx.restore();
                    };
                    newImageItem.src = imgArg;

                }*/


                function drawSlice(ctx, deg, color) {
                    ctx.beginPath();
                    ctx.fillStyle = color;
                    ctx.moveTo(center, center);
                    let r;
                    if (width <= 480) {
                        r = width / 2 - 10;
                    } else {
                        r = width / 2 - 14;
                    }
                    ctx.arc(center, center, r, deg2rad(deg), deg2rad(deg + sliceDeg));
                    ctx.lineTo(center, center);
                    ctx.fill();
                }

                function drawPoint(ctx, deg, color) {
                    ctx.save();
                    ctx.beginPath();
                    ctx.fillStyle = color;
                    ctx.shadowBlur = 1;
                    ctx.shadowOffsetX = 8;
                    ctx.shadowOffsetY = 8;
                    ctx.shadowColor = 'rgba(0,0,0,0.2)';
                    ctx.arc(center, center, width / 8, 0, 2 * Math.PI);
                    ctx.fill();

                    ctx.clip();
                    ctx.restore();
                }

                function drawBorder(ctx, borderC, dotC, lineW, dotR, des, shadColor) {
                    ctx.beginPath();
                    ctx.strokeStyle = borderC;
                    ctx.lineWidth = lineW;
                    ctx.shadowBlur = 1;
                    ctx.shadowOffsetX = 8;
                    ctx.shadowOffsetY = 8;
                    ctx.shadowColor = shadColor;
                    ctx.arc(center, center, center, 0, 2 * Math.PI);
                    ctx.stroke();
                    let x_val, y_val, deg;
                    deg = sliceDeg / 2;
                    let center1 = center - des;
                    for (let i = 0; i < slices; i++) {
                        ctx.beginPath();
                        ctx.fillStyle = dotC;
                        x_val = center + center1 * Math.cos(deg * Math.PI / 180);
                        y_val = center - center1 * Math.sin(deg * Math.PI / 180);
                        ctx.arc(x_val, y_val, dotR, 0, 2 * Math.PI);
                        ctx.fill();
                        deg += sliceDeg;
                    }
                }

                function drawText(ctx, deg, text, color, wheel_text_size) {
                    ctx.save();
                    ctx.translate(center, center);
                    ctx.rotate(deg2rad(deg));
                    ctx.textAlign = "right";
                    ctx.fillStyle = color;
                    ctx.font = '200 ' + wheel_text_size + 'px Helvetica';
                    ctx.shadowOffsetX = 0;
                    ctx.shadowOffsetY = 0;
                    text = text.replace(/&#(\d{1,4});/g, function (fullStr, code) {
                        return String.fromCharCode(code);
                    });
                    let reText = text.split('\/n'), text1 = '', text2 = '';
                    if (reText.length > 1) {
                        text1 = reText[0];
                        text2 = reText.splice(1, reText.length - 1);
                        text2 = text2.join('');
                    } else {
                        reText = text.split('\\n');
                        if (reText.length > 1) {
                            text1 = reText[0];
                            text2 = reText.splice(1, reText.length - 1);
                            text2 = text2.join('');
                        }
                    }
                    if (text1.trim() !== "" && text2.trim() !== "") {
                        ctx.fillText(text1.trim(), 7 * center / 8, -(wheel_text_size * 1 / 4));
                        ctx.fillText(text2.trim(), 7 * center / 8, wheel_text_size * 3 / 4);
                    } else {
                        ctx.fillText(text.replace(/\\n/g, '').replace(/\/n/g, ''), 7 * center / 8, wheel_text_size / 2 - 2);
                    }
                    ctx.restore();
                }
            },
            error: function (err) {
                $('.wlwl-preview-emails-button').html('Preview emails');
                $('.preview-lucky-wheel').removeClass('loading');
            }
        })


    });
    /**
     * Start Get download key
     */
    jQuery('.villatheme-get-key-button').one('click', function (e) {
        let v_button = jQuery(this);
        v_button.addClass('loading');
        let data = v_button.data();
        let item_id = data.id;
        let app_url = data.href;
        let main_domain = window.location.hostname;
        main_domain = main_domain.toLowerCase();
        let popup_frame;
        e.preventDefault();
        let download_url = v_button.attr('data-download');
        popup_frame = window.open(app_url, "myWindow", "width=380,height=600");
        window.addEventListener('message', function (event) {
            /*Callback when data send from child popup*/
            let obj = JSON.parse(event.data);
            let update_key = '';
            let message = obj.message;
            let support_until = '';
            let check_key = '';
            if (obj['data'].length > 0) {
                for (let i = 0; i < obj['data'].length; i++) {
                    if (obj['data'][i].id == item_id && (obj['data'][i].domain == main_domain || obj['data'][i].domain == '' || obj['data'][i].domain == null)) {
                        if (update_key == '') {
                            update_key = obj['data'][i].download_key;
                            support_until = obj['data'][i].support_until;
                        } else if (support_until < obj['data'][i].support_until) {
                            update_key = obj['data'][i].download_key;
                            support_until = obj['data'][i].support_until;
                        }
                        if (obj['data'][i].domain == main_domain) {
                            update_key = obj['data'][i].download_key;
                            break;
                        }
                    }
                }
                if (update_key) {
                    check_key = 1;
                    jQuery('.villatheme-autoupdate-key-field').val(update_key);
                }
            }
            v_button.removeClass('loading');
            if (check_key) {
                jQuery('<p><strong>' + message + '</strong></p>').insertAfter(".villatheme-autoupdate-key-field");
                jQuery(v_button).closest('form').submit();
            } else {
                jQuery('<p><strong> Your key is not found. Please contact support@villatheme.com </strong></p>').insertAfter(".villatheme-autoupdate-key-field");
            }
        });
    });
    /**
     * End get download key
     */
});
