<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_DATA {
	private $params;
	private $default;
	protected static $instance = null;

	/**
	 * VI_WOOCOMMERCE_LUCKY_WHEEL_DATA constructor.
	 * Init setting
	 */
	public function __construct() {
		global $woo_lucky_wheel_settings;
		if ( ! $woo_lucky_wheel_settings ) {
			$woo_lucky_wheel_settings = get_option( '_wlwl_settings', array() );
		}
		$this->default = array(
			'general'                           => array(
				'enable'     => "on",
				'mobile'     => "on",
				'spin_num'   => 1,
				'delay'      => 24,
				'delay_unit' => 'h'
			),
			'notify'                            => array(
				'position'                 => 'bottom-right',
				'size'                     => 40,
				'color'                    => '',
				'popup_icon'               => '',
				'popup_icon_color'         => '',
				'popup_icon_bg_color'      => '',
				'popup_icon_border_radius' => 0,
				'intent'                   => 'popup_icon',
				'hide_popup'               => 'off',
				'show_wheel'               => '1,5',//initial time
				'scroll_amount'            => '50',

				'show_again'         => 24,
				'show_again_unit'    => 'h',
				'show_only_front'    => 'off',
				'show_only_blog'     => 'off',
				'show_only_shop'     => 'off',
				'conditional_tags'   => '',
				'time_on_close'      => '1',
				'time_on_close_unit' => 'd',
			),
			'wheel_wrap'                        => array(
				'description'            => '<h2><span style="color: #ffffff;">SPIN TO WIN!</span></h2>
<ul>
 	<li><em><span style="color: #dbdbdb;">Try your lucky to get discount coupon</span></em></li>
 	<li><em><span style="color: #dbdbdb;">1 spin per email</span></em></li>
 	<li><em><span style="color: #dbdbdb;">No cheating</span></em></li>
</ul>',
				'bg_image'               => VI_WOOCOMMERCE_LUCKY_WHEEL_IMAGES . '2020.png',
				'bg_color'               => '#a77e44',
				'text_color'             => '#ffffff',
				'spin_button'            => 'Try Your Lucky',
				'spin_button_color'      => '#000000',
				'spin_button_bg_color'   => '#ffbe10',
				'pointer_position'       => 'center',
				'pointer_color'          => '#f70707',
				'wheel_center_image'     => '',
				'wheel_center_color'     => '#ffffff',
				'wheel_border_color'     => '#ffffff',
				'wheel_dot_color'        => '#000000',
				'close_option'           => 'on',
				'font'                   => 'Open+Sans',
				'gdpr'                   => 'off',
				'gdpr_message'           => 'I agree with the <a href="">term and condition</a>',
				'custom_css'             => '',
				'congratulations_effect' => 'firework',
				'background_effect'      => 'snowflakes',
			),
			'wheel'                             => array(
				'label_coupon'      => '{coupon_amount} OFF',
				'spinning_time'     => 5,
				'wheel_speed'       => 3,
				'custom_value'      => array( "", "", "", "", "", "", "", "", "", "", "", "" ),
				'email_templates'   => array( "", "", "", "", "", "", "", "", "", "", "", "" ),
				'prize_quantity'    => array( - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1, - 1 ),
				'custom_label'      => array(
					"Not Lucky",
					"{coupon_amount} OFF",
					"Not Lucky",
					"{coupon_amount} OFF",
					"Not Lucky",
					"{coupon_amount} OFF",
					"Not Lucky",
					"{coupon_amount} OFF",
					"Not Lucky",
					"{coupon_amount} OFF",
					"Not Lucky",
					"{coupon_amount} OFF"
				),
				'existing_coupon'   => array( "", "", "", "", "", "", "", "", "", "", "", "" ),
				'product_ids'       => array(
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
					array(),
				),
				'coupon_type'       => array(
					'non',
					'percent',
					'non',
					'fixed_product',
					'non',
					'fixed_cart',
					'non',
					'percent',
					'non',
					'fixed_product',
					'non',
					'fixed_cart'
				),
				'coupon_amount'     => array( '0', '10', '0', '20', '0', '30', '0', '15', '0', '20', '0', '20' ),
				'probability'       => array(
					'10',
					'10',
					'10',
					'5',
					'10',
					'5',
					'10',
					'10',
					'10',
					'10',
					'5',
					'5'
				),
				'bg_color'          => array(
					'#ffe0b2',
					'#e65100',
					'#ffb74d',
					'#fb8c00',
					'#ffe0b2',
					'#e65100',
					'#ffb74d',
					'#fb8c00',
					'#ffe0b2',
					'#e65100',
					'#ffb74d',
					'#fb8c00',
				),
				'slice_text_color'  => '#fff',
				'slices_text_color' => array(
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
					'#fff',
				),
				'currency'          => 'symbol',
				'show_full_wheel'   => 'off',
				'font_size'         => '100',
				'wheel_size'        => '100',
				'random_color'      => 'off',
				'quantity_label'    => '({prize_quantity} left)',
			),
			'result'                            => array(
				'auto_close'   => 0,
				'email'        => array(
					'subject'     => 'Lucky wheel coupon award.',
					'heading'     => 'Congratulations!',
					'content'     => "Dear {customer_name},\nYou have won a discount coupon by spinning lucky wheel on my website. Please apply the coupon when shopping with us.\nThank you!\nCoupon code :{coupon_code}\nExpiry date: {date_expires}\nYour Sincerely",
					'footer_text' => 'custom footer text',
				),
				'admin_email'  => array(
					'enable'  => '',
					'address' => '',
					'subject' => 'A coupon prize is given',
					'heading' => 'WooCommerce Lucky Wheel coupon notification!',
					'content' => "A customer with email {customer_email} has just won {coupon_label}. Coupon code is : {coupon_code}. Please moderate.",
				),
				'notification' => array(
					'win'        => 'Congrats! You have won a {coupon_label} discount coupon. The coupon was sent to the email address that you had entered to spin. {checkout} now!',
					'win_custom' => 'Congrats! You have won a {coupon_label}. We have sent the prize detail to your email!',
					'lost'       => 'OOPS! You are not lucky today. Sorry.',
				),
			),
			'coupon'                            => array(
				'allow_free_shipping'        => 'no',
				'expiry_date'                => null,
				'min_spend'                  => '',
				'max_spend'                  => '',
				'individual_use'             => 'no',
				'exclude_sale_items'         => 'no',
				'limit_per_coupon'           => 1,
				'limit_to_x_items'           => 1,
				'limit_per_user'             => 1,
				'product_ids'                => array(),
				'exclude_product_ids'        => array(),
				'product_categories'         => array(),
				'exclude_product_categories' => array(),
				'coupon_code_prefix'         => '',
				'email_restriction'          => 'yes'
			),
			'mailchimp'                         => array(
				'enable'       => 'off',
				'double_optin' => 'off',
				'api_key'      => '',
				'lists'        => ''
			),
			'active_campaign'                   => array(
				'enable' => 'off',
				'key'    => '',
				'url'    => '',
				'list'   => '',
			),
			'key'                               => '',
			'button_shop_title'                 => 'Shop now',
			'button_shop_url'                   => get_bloginfo( 'url' ),
			'button_shop_color'                 => '#fff',
			'button_shop_bg_color'              => '#000',
			'button_shop_size'                  => '20',
			'suggested_products'                => array(),
			'sendgrid'                          => array(
				'enable' => 'off',
				'key'    => '',
				'list'   => 'none',
			),
			'ajax_endpoint'                     => 'ajax',
			'custom_field_mobile_enable'        => 'off',
			'custom_field_mobile_enable_mobile' => 'off',
			'custom_field_mobile_required'      => 'off',
			'custom_field_name_enable'          => 'on',
			'custom_field_name_enable_mobile'   => 'on',
			'custom_field_name_required'        => 'off',
			/*Do not store new options as the old structure*/
//			'coupon_button_copy'                => '',
//			'coupon_button_copy_color'          => '#ffffff',
//			'coupon_button_copy_bg_color'       => '#446084',
//			'coupon_button_copy_border_radius'  => '2',
			'button_apply_coupon'               => '',
			'button_apply_coupon_redirect'      => '{checkout_page}',
			'button_apply_coupon_color'         => '#ffffff',
			'button_apply_coupon_bg_color'      => '#446084',
			'button_apply_coupon_font_size'     => '18',
			'button_apply_coupon_border_radius' => '2',
			'metrilo_enable'                    => '',
			'metrilo_token'                     => '',
			'metrilo_tag'                       => '',
			'metrilo_subscribed'                => '',
			'wlwl_enable_hubspot'               => '',
			'wlwl_hubspot_api'                  => '',
			'wlwl_enable_klaviyo'               => '',
			'wlwl_klaviyo_api'                  => '',
			'wlwl_klaviyo_list'                 => '',
			'wlwl_enable_sendinblue'            => '',
			'wlwl_sendinblue_api'               => '',
			'wlwl_sendinblue_list'              => [],
			'wlwl_enable_mailster'              => '',
			'wlwl_enable_sendy'                 => '',
			'wlwl_sendy_api'                    => '',
			'wlwl_sendy_login_url'              => '',
			'wlwl_sendy_brand'                  => '',
			'wlwl_sendy_list'                   => '',
			'wlwl_mailster_list'                => [],
			'wlwl_recaptcha_site_key'           => '',
			'wlwl_recaptcha_version'            => '3',
			'wlwl_recaptcha_secret_theme'       => 'light',
			'wlwl_recaptcha_secret_key'         => '',
			'wlwl_recaptcha'                    => '',
			'choose_using_white_black_list'     => 'black_list'

		);

		$this->params = apply_filters( 'woo_lucky_wheel_params', wp_parse_args( $woo_lucky_wheel_settings, $this->default ) );
	}

	public static function get_instance( $new = false ) {
		if ( $new || null === self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function get_params( $name = '', $name_sub = '', $language = '' ) {
		$language = apply_filters( '_wlwl_settings_language', $language, $name, $name_sub );
		if ( ! $name ) {
			return $this->params;
		} elseif ( isset( $this->params[ $name ] ) ) {
			if ( $name_sub ) {
				if ( isset( $this->params[ $name ][ $name_sub ] ) ) {
					if ( $language ) {
						$name_language = $name_sub . '_' . $language;
						if ( isset( $this->params[ $name ][ $name_language ] ) ) {
							return apply_filters( 'woo_lucky_wheel_params_' . $name . '__' . $name_language, $this->params[ $name ][ $name_language ] );
						} else {
							return apply_filters( 'woo_lucky_wheel_params_' . $name . '__' . $name_language, $this->params[ $name ][ $name_sub ] );
						}
					} else {
						return apply_filters( 'woo_lucky_wheel_params_' . $name . '__' . $name_sub, $this->params[ $name ] [ $name_sub ] );
					}
				} elseif ( $this->default[ $name ] [ $name_sub ] ) {
					return apply_filters( 'woo_lucky_wheel_params_' . $name . '__' . $name_sub, $this->default[ $name ] [ $name_sub ] );
				} else {
					return false;
				}
			} else {
				if ( $language ) {
					$name_language = $name . '_' . $language;
					if ( isset( $this->params[ $name_language ] ) ) {
						return apply_filters( 'woo_lucky_wheel_params_' . $name_language, $this->params[ $name_language ] );
					} else {
						return apply_filters( 'woo_lucky_wheel_params_' . $name_language, $this->params[ $name ] );
					}
				} else {
					return apply_filters( 'woo_lucky_wheel_params_' . $name, $this->params[ $name ] );
				}
			}
		} else {
			return false;
		}
	}

	public function get_default( $name = "", $name_sub = '' ) {
		if ( ! $name ) {
			return $this->default;
		} elseif ( isset( $this->default[ $name ] ) ) {
			if ( $name_sub ) {
				if ( isset( $this->default[ $name ][ $name_sub ] ) ) {
					return apply_filters( 'woo_lucky_wheel_params_default_' . $name . '__' . $name_sub, $this->default[ $name ] [ $name_sub ] );
				} else {
					return false;
				}
			} else {
				return apply_filters( 'woo_lucky_wheel_params_default_' . $name, $this->default[ $name ] );
			}
		} else {
			return false;
		}
	}

	public static function replace_placeholders( $string ) {
		$domain = wp_parse_url( home_url(), PHP_URL_HOST );

		return str_replace(
			array(
				'{site_title}',
				'{site_address}',
				'{woocommerce}',
				'{WooCommerce}',
			),
			array(
				wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES ),
				$domain,
				'<a href="https://woocommerce.com">WooCommerce</a>',
				'<a href="https://woocommerce.com">WooCommerce</a>',
			),
			$string
		);
	}

	/**
	 * @param $icon
	 *
	 * @return string
	 */
	public static function get_gift_icon_class( $icon ) {
		return "wlwl_gift_icons-{$icon}";
	}

	/**All icons from file ../css/giftbox.css
	 * Prefix wlwl_gift_icons-
	 * @return array
	 */
	public static function get_gift_icons() {
		return Array(
			'aniversary-giftbox',
			'big-giftbox-and-gift-with-heart',
			'big-giftbox-with-bun',
			'big-giftbox-with-lateral-lace',
			'big-giftbox-with-ribbon',
			'cylindrical-giftbox-with-ribbon',
			'gifbox-with-lace',
			'gifbox-with-ribbon-in-the-middle',
			'gifbox-with-ribbon-on-top',
			'gifbox-wrapped-with-ribbon',
			'gift-with-bow',
			'gift-with-ribbon',
			'giftbox-side',
			'giftbox-with-a-big-ribbon-on-cover',
			'giftbox-with-a-heart',
			'giftbox-with-a-heart-on-side',
			'giftbox-with-big-lace',
			'giftbox-with-big-lace-1',
			'giftbox-with-big-ribbon',
			'giftbox-with-big-ribbon-1',
			'giftbox-with-big-ribbon-2',
			'giftbox-with-big-ribbon-3',
			'giftbox-with-bun',
			'giftbox-with-flower',
			'giftbox-with-hearts',
			'giftbox-with-lace-on-a-side',
			'giftbox-with-long-ribbon',
			'giftbox-with-ribbon',
			'giftbox-with-ribbon-on-one-side',
			'giftbox-with-ribbon-on-top',
			'giftbox-with-ribbon-on-top-1',
			'giftbox-wrapped',
			'heart-shape-giftbox-with-lace',
			'heart-shape-giftbox-with-ribbon',
			'heart-shapped-gifbox-with-ribbon',
			'open-box-with-two-hearts',
			'open-gitfbox-with-two-hearts',
			'polka-dots-giftbox-with-lace',
			'rectangular-giftbox-with-flower',
			'round-gift-box-with-lace',
			'round-giftbox-with-flower',
			'square-gifbox-wrapped',
			'square-gifsoft-with-bun',
			'square-giftbox-with-big-lace',
			'square-giftbox-with-big-ribbon',
			'three-giftboxes-with-ribbon-and-heart',
			'two-gifboxes-tied-together',
			'two-gifboxes-wrapped',
			'two-giftboxes',
			'valentines-giftbox'
		);
	}

	public static function is_email_template_customizer_active() {
		return ( class_exists( 'WooCommerce_Email_Template_Customizer' ) || class_exists( 'Woo_Email_Template_Customizer' ) );
	}

	public static function get_all_bg_effects() {
		return array(
			'none'               => esc_html__( 'None', 'woocommerce-lucky-wheel' ),
			'floating-halloween' => esc_html__( 'Halloween', 'woocommerce-lucky-wheel' ),
			'halloween-1'        => esc_html__( 'Halloween 1', 'woocommerce-lucky-wheel' ),
			'halloween-2'        => esc_html__( 'Halloween 2', 'woocommerce-lucky-wheel' ),
			'halloween-3'        => esc_html__( 'Halloween 3', 'woocommerce-lucky-wheel' ),
			'leaf-1'             => esc_html__( 'Falling Leaves 1', 'woocommerce-lucky-wheel' ),
			'leaf-2'             => esc_html__( 'Falling Leaves 2', 'woocommerce-lucky-wheel' ),
			'hearts'             => esc_html__( 'Hearts', 'woocommerce-lucky-wheel' ),
			'heart'              => esc_html__( 'Heart', 'woocommerce-lucky-wheel' ),
			'smile'              => esc_html__( 'Smile', 'woocommerce-lucky-wheel' ),
			'star'               => esc_html__( 'Star', 'woocommerce-lucky-wheel' ),
			'floating-bubbles'   => esc_html__( 'Balloons', 'woocommerce-lucky-wheel' ),
			'snowflakes'         => esc_html__( 'Snowflake', 'woocommerce-lucky-wheel' ),
			'snowflakes-1'       => esc_html__( 'Snowflake 1', 'woocommerce-lucky-wheel' ),
			'snowflakes-2-2'     => esc_html__( 'Snowflake 2', 'woocommerce-lucky-wheel' ),
			'snowflakes-2-1'     => esc_html__( 'Snowballs', 'woocommerce-lucky-wheel' ),
			'snowflakes-2-3'     => esc_html__( 'Blurred snows', 'woocommerce-lucky-wheel' ),
			'random'             => esc_html__( 'Random', 'woocommerce-lucky-wheel' ),
		);
	}

}
