<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendgrid {
	protected $settings;
	protected $api_key;

	public function __construct() {
		$this->settings = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance();
		$this->api_key  =  $this->settings->get_params('sendgrid','key');
	}


	public function get_lists() {
		if ( ! $this->api_key ) {
			return false;
		}
		$args = array(
			'headers' => array(
				'Authorization' =>  "Bearer " . $this->api_key
			)
		);
		$url        = "https://api.sendgrid.com/v3/marketing/lists";
		try {

			$r = wp_remote_get( $url,$args);

			$body = wp_remote_retrieve_body( $r );

			return  json_decode( $body ) ;

		} catch ( \Exception $e ) {
			return false;
		}

	}

	public function add_recipient( $email = '', $firstname = '', $lastname = '' ) {
		if ( ! $this->api_key ) {
			return;
		}
		if ( ! $email ) {
			return;
		}

		$args = [
			'method'  => 'PUT',
			'headers' => [
				"Authorization" => "Bearer " . $this->api_key,
				"Content-type"  => "application/json"
			],
			'body'    => json_encode( [
				'contacts' => [
					[
						'email'      => $email,
						'first_name' => $firstname,
						'last_name'  => $lastname,
					]
				]
			] )
		];
		$res  = wp_remote_request( 'https://api.sendgrid.com/v3/marketing/contacts', $args );
	}

	public function add_recipient_to_list( $email = '', $list_id = '' ) {
		if ( ! $this->api_key ) {
			return;
		}
		if ( ! $email || ! $list_id ) {
			return;
		}
		$args = [
			'method'  => 'PUT',
			'headers' => [
				"Authorization" => "Bearer " . $this->api_key,
				"Content-type"  => "application/json"
			],
			'body'    => json_encode( [
				'list_ids' => [ $list_id ],
				'contacts' => [
					[ 'email' => $email ]
				]
			] )
		];
		$res  = wp_remote_request( 'https://api.sendgrid.com/v3/marketing/contacts', $args );
	}
}
