<?php
/**
 * Plugin Name: Woocommerce Lucky Wheel Premium
 * Description: Collect customers emails by letting them play interesting Lucky wheel game to get lucky discount coupon
 * Version: 1.1.14
 * Author: VillaTheme
 * Author URI: http://villatheme.com
 * Text Domain: woocommerce-lucky-wheel
 * Domain Path: /languages
 * Copyright 2018-2023 VillaTheme.com. All rights reserved.
 * Requires at least: 5.0
 * Tested up to: 6.4
 * WC requires at least: 6.0.0
 * WC tested up to: 8.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
define( 'VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION', '1.1.14' );

if ( ! class_exists( 'Woocommerce_Lucky_Wheel' ) ):
	class Woocommerce_Lucky_Wheel {
		protected $settings;

		public function __construct() {
			add_action( 'plugins_loaded', function () {
				if ( ! class_exists( 'VillaTheme_Require_Environment' ) ) {
					include_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "woocommerce-lucky-wheel" . DIRECTORY_SEPARATOR . "includes" . DIRECTORY_SEPARATOR . 'support.php';
				}

				$environment = new \VillaTheme_Require_Environment( [
						'plugin_name'     => 'Woocommerce Lucky Wheel Premium',
						'php_version'     => '7.0',
						'wp_version'      => '5.0',
						'wc_version'      => '6.0',
						'require_plugins' => [
							[
								'slug' => 'woocommerce',
								'name' => 'WooCommerce',
							],
						]
					]
				);

				if ( $environment->has_error() ) {
					return;
				}

				require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "woocommerce-lucky-wheel" . DIRECTORY_SEPARATOR . "includes" . DIRECTORY_SEPARATOR . "includes.php";
				$this->settings = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance();
				add_action( 'init', array( $this, 'load_plugin_textdomain' ) );

			} );
			//compatible with 'High-Performance order storage (COT)
			add_action( 'before_woocommerce_init', function() {
				if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
					\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
				}
			} );
			add_action( 'init', array( $this, 'create_custom_post_type' ) );
			add_filter( 'manage_wlwl_email_posts_columns', array( $this, 'add_column' ), 10, 1 );
			add_action( 'manage_wlwl_email_posts_custom_column', array( $this, 'add_column_data' ), 10, 2 );
			add_filter(
				'plugin_action_links_woocommerce-lucky-wheel/woocommerce-lucky-wheel.php', array(
					$this,
					'settings_link'
				)
			);

		}

		public function settings_link( $links ) {
			$settings_link = '<a href="admin.php?page=woocommerce-lucky-wheel" title="' . esc_html__( 'Settings', 'woocommerce-lucky-wheel' ) . '">' . esc_html__( 'Settings', 'woocommerce-lucky-wheel' ) . '</a>';
			array_unshift( $links, $settings_link );

			return $links;
		}

		public function create_custom_post_type() {
			if ( ! current_user_can( 'manage_options' ) ) {
				return;
			}
			if ( post_type_exists( 'wlwl_email' ) ) {
				return;
			}
			$args = array(
				'labels'              => array(
					'name'               => esc_html_x( 'Lucky Wheel Email', 'woocommerce-lucky-wheel' ),
					'singular_name'      => esc_html_x( 'Email', 'woocommerce-lucky-wheel' ),
					'menu_name'          => esc_html_x( 'Emails', 'Admin menu', 'woocommerce-lucky-wheel' ),
					'name_admin_bar'     => esc_html_x( 'Emails', 'Add new on Admin bar', 'woocommerce-lucky-wheel' ),
					'view_item'          => esc_html__( 'View Email', 'woocommerce-lucky-wheel' ),
					'all_items'          => esc_html__( 'Email Subscribe', 'woocommerce-lucky-wheel' ),
					'search_items'       => esc_html__( 'Search Email', 'woocommerce-lucky-wheel' ),
					'parent_item_colon'  => esc_html__( 'Parent Email:', 'woocommerce-lucky-wheel' ),
					'not_found'          => esc_html__( 'No Email found.', 'woocommerce-lucky-wheel' ),
					'not_found_in_trash' => esc_html__( 'No Email found in Trash.', 'woocommerce-lucky-wheel' )
				),
				'description'         => esc_html__( 'Woocommerce lucky wheel emails.', 'woocommerce-lucky-wheel' ),
				'public'              => false,
				'show_ui'             => true,
				'capability_type'     => 'post',
				'capabilities'        => array( 'create_posts' => 'do_not_allow' ),
				'map_meta_cap'        => true,
				'publicly_queryable'  => false,
				'exclude_from_search' => true,
				'show_in_menu'        => false,
				'hierarchical'        => false,
				'rewrite'             => false,
				'query_var'           => false,
				'supports'            => array( 'title' ),
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
			);
			register_post_type( 'wlwl_email', $args );
		}

		public function add_column( $columns ) {
			$columns['customer_name'] = esc_html__( 'Customer name', 'woocommerce-lucky-wheel' );
			$columns['mobile']        = esc_html__( 'Mobile', 'woocommerce-lucky-wheel' );
			$columns['spins']         = esc_html__( 'Number of spins', 'woocommerce-lucky-wheel' );
			$columns['last_spin']     = esc_html__( 'Last spin', 'woocommerce-lucky-wheel' );
			$columns['label']         = esc_html__( 'Labels', 'woocommerce-lucky-wheel' );
			$columns['coupon']        = esc_html__( 'Coupons', 'woocommerce-lucky-wheel' );

			return $columns;
		}

		public function add_column_data( $column, $post_id ) {
			switch ( $column ) {
				case 'customer_name':
					if ( get_post( $post_id )->post_content ) {
						echo wp_kses_post(get_post( $post_id )->post_content);
					}
					break;
				case 'mobile':
					if ( get_post_meta( $post_id, 'wlwl_email_mobile', true ) ) {
						echo esc_html(get_post_meta( $post_id, 'wlwl_email_mobile', true ));
					}
					break;
				case 'spins':
					if ( get_post_meta( $post_id, 'wlwl_spin_times', true ) ) {
						echo esc_html(get_post_meta( $post_id, 'wlwl_spin_times', true )['spin_num']);
					}
					break;
				case 'last_spin':
					if ( get_post_meta( $post_id, 'wlwl_spin_times', true ) ) {
						echo esc_html(date( 'Y-m-d h:i:s', get_post_meta( $post_id, 'wlwl_spin_times', true )['last_spin'] ));
					}
					break;

				case 'label':
					if ( get_post_meta( $post_id, 'wlwl_email_labels', true ) ) {
						$label = get_post_meta( $post_id, 'wlwl_email_labels', true );
						if ( sizeof( $label ) > 1 ) {
							for ( $i = sizeof( $label ) - 1; $i >= 0; $i -- ) {
								echo '<p>' . esc_html($label[ $i ]) . '</p>';
							}
						} else {
							echo esc_html($label[0]);
						}
					}
					break;
				case 'coupon':
					if ( get_post_meta( $post_id, 'wlwl_email_coupons', true ) ) {
						$coupon = get_post_meta( $post_id, 'wlwl_email_coupons', true );
						if ( sizeof( $coupon ) > 1 ) {
							for ( $i = sizeof( $coupon ) - 1; $i >= 0; $i -- ) {
								echo '<p>' . esc_html($coupon[ $i ]) . '</p>';
							}
						} else {
							echo esc_html($coupon[0]);
						}
					}
					break;
			}
		}

		function load_plugin_textdomain() {
			$locale = is_admin() && function_exists( 'get_user_locale' ) ? get_user_locale() : get_locale();
			$locale = apply_filters( 'plugin_locale', $locale, 'woocommerce-lucky-wheel' );
			load_textdomain( 'woocommerce-lucky-wheel', WP_PLUGIN_DIR . "/woocommerce-lucky-wheel/languages/woocommerce-lucky-wheel-$locale.mo" );
			load_plugin_textdomain( 'woocommerce-lucky-wheel', false, basename( dirname( __FILE__ ) ) . "/languages" );
			if ( class_exists( 'VillaTheme_Support_Pro' ) ) {
				new VillaTheme_Support_Pro(
					array(
						'support'   => 'https://villatheme.com/supports/forum/plugins/woocommerce-lucky-wheel/',
						'docs'      => 'http://docs.villatheme.com/?item=woocommerce-lucky-wheel',
						'review'    => 'https://codecanyon.net/downloads',
						'css'       => VI_WOOCOMMERCE_LUCKY_WHEEL_CSS,
						'image'     => VI_WOOCOMMERCE_LUCKY_WHEEL_IMAGES,
						'slug'      => 'woocommerce-lucky-wheel',
						'menu_slug' => 'woocommerce-lucky-wheel',
						'version'   => VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION,
					)
				);
			}
		}

	}
endif;

new Woocommerce_Lucky_Wheel();
