"use strict";
jQuery(document).ready(function ($) {
    let congratulations_effect = _wlwl_get_email_params.congratulations_effect;
    let font_size = _wlwl_get_email_params.font_size;
    let custom_field_name_enable = _wlwl_get_email_params.custom_field_name_enable;
    let custom_field_name_enable_mobile = _wlwl_get_email_params.custom_field_name_enable_mobile;
    let custom_field_name_required = _wlwl_get_email_params.custom_field_name_required;
    let custom_field_mobile_enable = _wlwl_get_email_params.custom_field_mobile_enable;
    let custom_field_mobile_enable_mobile = _wlwl_get_email_params.custom_field_mobile_enable_mobile;
    let custom_field_mobile_required = _wlwl_get_email_params.custom_field_mobile_required;

    let wlwl_hide_popup = _wlwl_get_email_params.hide_popup;
    let color = _wlwl_get_email_params.bg_color;
    let slices_text_color = _wlwl_get_email_params.slices_text_color;
    let label = _wlwl_get_email_params.label;
    let coupon_type = _wlwl_get_email_params.coupon_type;
    let wlwl_auto_close = parseInt(_wlwl_get_email_params.auto_close);
    let wlwl_notify_position = _wlwl_get_email_params.position;
    let wlwl_show_again = _wlwl_get_email_params.show_again;
    let wlwl_show_again_unit = _wlwl_get_email_params.show_again_unit;
    let time_if_close = _wlwl_get_email_params.time_if_close;
    switch (wlwl_show_again_unit) {
        case 'm':
            wlwl_show_again *= 60;
            break;
        case 'h':
            wlwl_show_again *= 60 * 60;
            break;
        case 'd':
            wlwl_show_again *= 60 * 60 * 24;
            break;
        default:
    }
    let intent_type = _wlwl_get_email_params.intent;
    let initial_time = _wlwl_get_email_params.show_wheel;
    let scroll_amount = _wlwl_get_email_params.scroll_amount;
    let wlwl_center_color = _wlwl_get_email_params.wheel_center_color;
    let wlwl_border_color = _wlwl_get_email_params.wheel_border_color;
    let wlwl_dot_color = _wlwl_get_email_params.wheel_dot_color;
    let gdpr_checkbox = _wlwl_get_email_params.gdpr;
    let slice_text_color = _wlwl_get_email_params.slice_text_color;
    let wlwl_spinning_time = _wlwl_get_email_params.spinning_time;
    let wheel_speed = _wlwl_get_email_params.wheel_speed;
    let slices = coupon_type.length;
    let sliceDeg = 360 / slices;
    let deg = -(sliceDeg / 2);
    let cv = document.getElementById('wlwl_canvas');
    let ctx = cv.getContext('2d');
    let canvas_width;
    let wd_width, wd_height;
    wd_width = window.innerWidth;
    wd_height = window.innerHeight;
    if (wd_width > wd_height) {
        canvas_width = wd_height;
    } else {
        canvas_width = wd_width;
    }
    let width = parseInt(canvas_width * 0.6 + 16);
    cv.width = width;
    cv.height = width;

    if (window.devicePixelRatio) {
        let hidefCanvasWidth = $(cv).attr('width');
        let hidefCanvasHeight = $(cv).attr('height');
        let hidefCanvasCssWidth = hidefCanvasWidth;
        let hidefCanvasCssHeight = hidefCanvasHeight;

        $(cv).attr('width', hidefCanvasWidth * window.devicePixelRatio);
        $(cv).attr('height', hidefCanvasHeight * window.devicePixelRatio);
        $(cv).css('width', hidefCanvasCssWidth);
        $(cv).css('height', hidefCanvasCssHeight);
        ctx.scale(window.devicePixelRatio, window.devicePixelRatio);
    }
    let center = (width) / 2; // center
    $('.wlwl_wheel_spin').css({'width': width + 'px', 'height': width + 'px'});

    let inline_css = '.wlwl_lucky_wheel_content.wlwl_lucky_wheel_content_mobile .wheel_description{min-height:' + $('.wheel_description').css('height') + '}';
    if (_wlwl_get_email_params.pointer_position === 'center') {
        inline_css += '.wlwl_pointer:before{font-size:' + parseInt(width / 4) + 'px !important; }';
    } else {
        inline_css += '.wlwl_pointer:before{font-size:' + parseInt(width / 10) + 'px !important; }';
        inline_css += '.wlwl_margin_position .wlwl_wheel_spin_container .wlwl_pointer_content .wlwl_pointer:after{width:' + parseInt(width / 25) + 'px;height:' + parseInt(width / 25) + 'px;bottom:' + parseInt(width / 30) + 'px; }';
    }
    $('head').append('<style type="text/css">' + inline_css + '</style>');
    inline_css = $('#woocommerce-lucky-wheel-frontend-style-inline-css').html() + inline_css;
    $('#woocommerce-lucky-wheel-frontend-style-inline-css').html(inline_css);
    let wheel_text_size;
    wheel_text_size = parseInt(width / 28) * parseInt(font_size) / 100;

    function deg2rad(deg) {
        return deg * Math.PI / 180;
    }

    function drawSlice(deg, color) {
        ctx.beginPath();
        ctx.fillStyle = color;
        ctx.moveTo(center, center);
        let r = width / 2 - 10;
        ctx.arc(center, center, r, deg2rad(deg), deg2rad(deg + sliceDeg));
        ctx.lineTo(center, center);
        ctx.fill();
    }

    function drawPoint(deg, color) {
        ctx.save();
        ctx.beginPath();
        ctx.fillStyle = color;
        ctx.shadowBlur = 1;
        ctx.shadowOffsetX = 8;
        ctx.shadowOffsetY = 8;
        ctx.shadowColor = 'rgba(0,0,0,0.2)';
        ctx.arc(center, center, width / 8, 0, 2 * Math.PI);
        ctx.fill();

        ctx.clip();
        ctx.restore();
    }

    function drawBorder(borderC, dotC, lineW, dotR, des, shadColor) {
        ctx.beginPath();
        ctx.strokeStyle = borderC;
        ctx.lineWidth = lineW;
        ctx.shadowBlur = 1;
        ctx.shadowOffsetX = 8;
        ctx.shadowOffsetY = 8;
        ctx.shadowColor = shadColor;
        ctx.arc(center, center, center, 0, 2 * Math.PI);
        ctx.stroke();
        let x_val, y_val, deg;
        deg = sliceDeg / 2;
        let center1 = center - des;
        for (let i = 0; i < slices; i++) {
            ctx.beginPath();
            ctx.fillStyle = dotC;
            x_val = center + center1 * Math.cos(deg * Math.PI / 180);
            y_val = center - center1 * Math.sin(deg * Math.PI / 180);
            ctx.arc(x_val, y_val, dotR, 0, 2 * Math.PI);
            ctx.fill();
            deg += sliceDeg;
        }
    }

    function drawText(deg, text, color) {
        let font_text_wheel = 'Helvetica';
        if (typeof _wlwl_get_email_params.font_text_wheel !== 'undefined' && _wlwl_get_email_params.font_text_wheel !== '') {
            font_text_wheel = _wlwl_get_email_params.font_text_wheel;
        }
        ctx.save();
        ctx.translate(center, center);
        ctx.rotate(deg2rad(deg));
        ctx.textAlign = "right";
        ctx.fillStyle = color;
        ctx.font = '300 ' + wheel_text_size + 'px '+font_text_wheel;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
        text = text.replace(/&#(\d{1,4});/g, function (fullStr, code) {
            return String.fromCharCode(code);
        });
        text = text.replace(/&nbsp;/g, ' ');
        let reText = text.split('\/n'), text1 = '', text2 = '', text3 = '';
        if (reText.length > 1) {
            text1 = reText[0];
            if (reText.length > 2) {
                text2 = reText[1];
            } else {
                text2 = reText.splice(1, reText.length - 1);
                text2 = text2.join('');
            }
            text3 = reText.splice(2, reText.length - 1);
            text3 = text3.join('');

        } else {
            reText = text.split('\\n');
            if (reText.length > 1) {
                text1 = reText[0];
                text2 = reText.splice(1, reText.length - 1);
                text2 = text2.join('');
                text3 = reText.splice(2, reText.length - 2);
                text3 = text3.join('');
            }
        }
        if (text1.trim() !== "" && text2.trim() !== "" && text3.trim() === "") {
            ctx.fillText(text1.trim(), 7 * center / 8, -(wheel_text_size * 1 / 4));
            ctx.fillText(text2.trim(), 7 * center / 8, wheel_text_size * 3 / 4);
        } else if (text1.trim() !== "" && text2.trim() !== "" && text3.trim() !== "") {
            ctx.fillText(text1.trim(), 7 * center / 8, -(wheel_text_size * 1 / 2));
            ctx.fillText(text2.trim(), 7 * center / 8, (wheel_text_size * 1 / 2));
            ctx.fillText(text3.trim(), 7 * center / 8, (wheel_text_size *1.5));
        } else {
            ctx.fillText(text.replace(/\\n/g, '').replace(/\/n/g, ''), 7 * center / 8, wheel_text_size / 2 - 2);
        }
        ctx.restore();
    }

    function wlwl_trim(x) {
        return x.replace(/^\s+|\s+$/gm, '');
    }

//cookie
    function setCookie(cname, cvalue, expire) {
        let d = new Date();
        d.setTime(d.getTime() + (expire * 1000));
        let expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
        let name = cname + "=";
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }

    function spins_wheel(stop_position, result_notification, result) {
        let canvas_1 = $('#wlwl_canvas');
        let canvas_3 = $('#wlwl_canvas2');
        let default_css = '';
        if (window.devicePixelRatio) {
            default_css = 'width:' + width + 'px;height:' + width + 'px;';
        }
        canvas_1.attr('style', default_css);
        canvas_3.attr('style', default_css);
        let stop_deg = 360 - sliceDeg * stop_position;
        let wheel_stop = wheel_speed * 360 * wlwl_spinning_time + stop_deg;
        let css = default_css + '-moz-transform: rotate(' + wheel_stop + 'deg);-webkit-transform: rotate(' + wheel_stop + 'deg);-o-transform: rotate(' + wheel_stop + 'deg);-ms-transform: rotate(' + wheel_stop + 'deg);transform: rotate(' + wheel_stop + 'deg);';
        css += '-webkit-transition: transform ' + wlwl_spinning_time + 's ease;-moz-transition: transform ' + wlwl_spinning_time + 's ease;-ms-transition: transform ' + wlwl_spinning_time + 's ease;-o-transition: transform ' + wlwl_spinning_time + 's ease;transition: transform ' + wlwl_spinning_time + 's ease;';
        canvas_1.attr('style', css);
        canvas_3.attr('style', css);
        setTimeout(function () {
            css = default_css + 'transform: rotate(' + stop_deg + 'deg);';
            canvas_1.attr('style', css);
            canvas_3.attr('style', css);
            if (result === 'win' && congratulations_effect === 'firework') {
                $('.wlwl-congratulations-effect').addClass('wlwl-congratulations-effect-firework');
            }
            $('.wlwl_user_lucky').removeClass('wlwl_user_lucky_spinning').html('<div class="wlwl-frontend-result">' + result_notification + '</div>').fadeIn(300);
            if (wlwl_auto_close > 0) {
                setTimeout(function () {
                    $('html').removeClass('wlwl-html');
                    $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
                }, wlwl_auto_close * 1000);
            }
        }, parseInt(wlwl_spinning_time * 1000))
    }

    function isValidEmailAddress(emailAddress) {
        let pattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/i;
        return pattern.test(emailAddress);
    }

    function validateRecaptcha(response) {
        if (response) {
            jQuery('.wlwl-recaptcha-field #wlwl-g-validate-response').val(response);
        }
    }

    function expireRecaptcha() {
        jQuery('.wlwl-recaptcha-field #wlwl-g-validate-response').val(null);
        /*   if (_wlwl_get_email_params.wlwl_layout == 3) {
               let old_width = jQuery('.wlwl-recaptcha > div').width();
               let parent_width = jQuery('.wlwl-recaptcha').width();
               jQuery('.wlwl-recaptcha > div').css({transform: 'scale(' + parent_width / old_width + ',1)'});
           }*/
    }

    /* Googele recaptcha */
    window.addEventListener('load', function () {
        if (_wlwl_get_email_params.wlwl_recaptcha == 'on') {
            if (_wlwl_get_email_params.wlwl_recaptcha_version == 2) {
                wlwlreCaptchaV2Onload();
            } else {
                wlwlreCaptchaV3Onload();
                jQuery('.wlwl-recaptcha-field').hide();
            }
        } else {
            jQuery('.wlwl-recaptcha-field').hide();
        }
    });

    function wlwlreCaptchaV3Onload() {
        grecaptcha.ready(function () {
            grecaptcha.execute(_wlwl_get_email_params.wlwl_recaptcha_site_key, {action: 'homepage'}).then(function (token) {
                validateRecaptcha(token);
            })
        });
    }

    function wlwlreCaptchaV2Onload() {
        if (jQuery.find('.wlwl-recaptcha').length == 0 || jQuery.find('.wlwl-recaptcha iframe').length) {
            return true;
        }
        grecaptcha.render('wlwl-recaptcha', {

            'sitekey': _wlwl_get_email_params.wlwl_recaptcha_site_key,

            'callback': validateRecaptcha,

            'expired-callback': expireRecaptcha,

            'theme': _wlwl_get_email_params.wlwl_recaptcha_secret_theme,

            'isolated': false
        });


    }

    function check_email() {
        $('.wlwl_field_input').on('keypress', function (e) {
            if ($(this).focus() && e.keyCode === 13) {
                $('#wlwl_chek_mail').click();
            }
        });

        /*reCaptcha*/
        $('.wheel-content-wrapper').on('renderReCaptcha', function () {
            if (_wlwl_get_email_params.wlwl_recaptcha == 'on') {
                if (_wlwl_get_email_params.wlwl_recaptcha_version == 2) {
                    wlwlreCaptchaV2Onload();
                } else {
                    wlwlreCaptchaV3Onload();
                    $('.wheel-content-wrapper').find('.wlwl-recaptcha-field').hide();
                }
            }
        });

        window.addEventListener('load', function () {
            if (_wlwl_get_email_params.wlwl_recaptcha == 'on') {
                if (_wlwl_get_email_params.wlwl_recaptcha_version == 2) {
                    wlwlreCaptchaV2Onload();
                } else {
                    wlwlreCaptchaV3Onload();
                    $('.wheel-content-wrapper').find('.wlwl-recaptcha-field').hide();
                }
            }
        });
        $('#wlwl_chek_mail').on('click', function () {
            $('#wlwl_error_mail').html('');
            $('#wlwl_error_name').html('');
            $('#wlwl_error_mobile').html('');
            $('#wlwl_warring_recaptcha').html('');
            $('.wlwl_field_name').removeClass('wlwl-required-field');
            $('.wlwl_field_mobile').removeClass('wlwl-required-field');
            $('.wlwl_field_email').removeClass('wlwl-required-field');
            $('.wlwl-recaptcha-field').removeClass('wlwl-required-field');
            let wlwl_email = $('#wlwl_player_mail').val();
            let wlwl_name = $('#wlwl_player_name').val();
            let wlwl_mobile = $('#wlwl_player_mobile').val();
            let g_validate_response = $('#wlwl-g-validate-response').val();
            let qualified = true;

            if (_wlwl_get_email_params.wlwl_recaptcha && _wlwl_get_email_params.wlwl_recaptcha_site_key && !g_validate_response) {
                $('.wlwl-recaptcha-field #wlwl-recaptcha > div').addClass('wlwl-required-field').focus();
                $('#wlwl_warring_recaptcha').html(_wlwl_get_email_params.wlwl_warring_recaptcha);
                qualified = false;
            } else if (_wlwl_get_email_params.wlwl_recaptcha && _wlwl_get_email_params.wlwl_recaptcha_site_key) {
                $('.wlwl-recaptcha-field #wlwl-recaptcha > div').removeClass('wlwl-required-field');
                qualified = true;
            }
            if ('on' === gdpr_checkbox && !$('.wlwl-gdpr-checkbox-wrap input[type="checkbox"]').prop('checked')) {
                alert(_wlwl_get_email_params.gdpr_warning);
                return false;
            }
            if (custom_field_name_enable === 'on' && custom_field_name_enable_mobile === 'on' && custom_field_name_required === 'on' && !wlwl_name) {
                $('#wlwl_error_name').html(_wlwl_get_email_params.custom_field_name_message);
                $('.wlwl_field_name').addClass('wlwl-required-field');
                qualified = false;
            }
            if (custom_field_mobile_enable === 'on' && custom_field_mobile_enable_mobile === 'on' && custom_field_mobile_required === 'on' && !wlwl_mobile) {
                $('#wlwl_error_mobile').html(_wlwl_get_email_params.custom_field_mobile_message);
                $('.wlwl_field_mobile').addClass('wlwl-required-field');
                qualified = false;
            }
            if (!wlwl_email) {
                $('#wlwl_player_mail').prop('disabled', false).focus();
                $('#wlwl_error_mail').html(_wlwl_get_email_params.empty_email_warning);
                $('.wlwl_field_email').addClass('wlwl-required-field');
                qualified = false;
            }

            if (qualified === false) {
                return false;
            }
            $(this).unbind();
            $('#wlwl_player_mail').prop('disabled', true);
            if (getCookie('wlwl_cookie') === "" || getCookie('wlwl_cookie') === 'closed') {
                if (isValidEmailAddress($('#wlwl_player_mail').val())) {
                    $('#wlwl_chek_mail').addClass('wlwl-adding');
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: _wlwl_get_email_params.ajaxurl,
                        data: {
                            origin_prize: coupon_type,
                            user_email: wlwl_email,
                            user_name: wlwl_name,
                            user_mobile: wlwl_mobile,
                            language: _wlwl_get_email_params.language,
                            g_validate_response: g_validate_response,
                            _woocommerce_lucky_wheel_nonce: $('#_woocommerce_lucky_wheel_nonce').val(),
                        },
                        success: function (response) {
                            if (response.allow_spin === 'yes') {
                                // $('.wlwl-show-again-option').fadeOut(300);
                                $('.wlwl_user_lucky').addClass('wlwl_user_lucky_spinning');
                                $('.wlwl-close-wheel').hide();
                                $('.wlwl-show-again-option').remove();

                                $('.wlwl-hide-after-spin').show();
                                setTimeout(function () {
                                    $('.wlwl_user_lucky').html(response.result_notification);
                                    spins_wheel(response.stop_position, response.result_notification, response.result);
                                }, 1000);
                                setCookie('wlwl_cookie', wlwl_email, wlwl_show_again);
                            } else {
                                alert(response.allow_spin);
                                $('#wlwl_chek_mail').removeClass('wlwl-adding');
                                $('#wlwl_player_mail').prop('disabled', false);
                                check_email();
                            }
                            if (response.hasOwnProperty('metrilo_response')) {
                                let metrilo_response = response.metrilo_response;
                                if (metrilo_response.status === 'success' && window.hasOwnProperty('metrilo')) {
                                    if (window.metrilo.hasOwnProperty('customEvent') && typeof window.metrilo.customEvent === 'function') {
                                        window.metrilo.customEvent('woocommerce_lucky_wheel');
                                    }
                                }
                            }
                        }
                    });

                } else {
                    $('#wlwl_player_mail').prop('disabled', false).focus();
                    check_email();
                    $('#wlwl_error_mail').html(_wlwl_get_email_params.invalid_email_warning);
                    $('.wlwl_field_email').addClass('wlwl-required-field');
                }

            } else {
                alert(_wlwl_get_email_params.limit_time_warning);
                $('#wlwl_player_mail').prop('disabled', false);
                check_email();
            }
        });
    }

    check_email();
    let center1 = 32;

    if (!getCookie('wlwl_cookie') || getCookie('wlwl_cookie') == "") {
        $('.wlwl-hide-after-spin').bind('click', function () {
            $('html').removeClass('wlwl-html');
            $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
            $('.wlwl_wheel_spin').css({'margin-left': '0', 'transition': '2s'});
        });

        $('.wlwl-reminder-later-a').unbind().bind('click', function () {
            setCookie('wlwl_cookie', 'reminder_later', 24 * 60 * 60);

            $('.wlwl_wheel_icon').addClass('wlwl_show');

            $('html').removeClass('wlwl-html');
            $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
        });
        $('.wlwl-never-again span').unbind().bind('click', function () {
            setCookie('wlwl_cookie', 'never_show_again', 30 * 24 * 60 * 60);

            $('.wlwl_wheel_icon').addClass('wlwl_show');

            $('html').removeClass('wlwl-html');
            $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
        });
        $('.wlwl-close span').on('click', function () {
            $('html').removeClass('wlwl-html');
            setCookie('wlwl_cookie', 'closed', time_if_close);
            $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
            if (wlwl_hide_popup !== 'on') {
                $('.wlwl_wheel_icon').addClass('wlwl_show');
            }
        });
        $('.wlwl-close-wheel span').on('click', function () {
            $('html').removeClass('wlwl-html');
            $('.wlwl_lucky_wheel_content').removeClass('lucky_wheel_content_show');
            setCookie('wlwl_cookie', 'closed', time_if_close);
            if (wlwl_hide_popup !== 'on') {
                $('.wlwl_wheel_icon').addClass('wlwl_show');
            }
        });


        $('.woocommerce-lucky-wheel-popup-icon').on('click', function () {
            $('.wlwl_wheel_icon').removeClass('wlwl_show');
            $('html').addClass('wlwl-html');
            $('.wlwl_lucky_wheel_content').addClass('lucky_wheel_content_show');
        });

        for (let i = 0; i < slices; i++) {
            drawSlice(deg, color[i]);
            drawText(deg + sliceDeg / 2, label[i], slices_text_color[i]);
            deg += sliceDeg;

        }
        cv = document.getElementById('wlwl_canvas1');
        ctx = cv.getContext('2d');
        cv.width = width;
        cv.height = width;
        if (window.devicePixelRatio) {
            let hidefCanvasWidth = $(cv).attr('width');
            let hidefCanvasHeight = $(cv).attr('height');
            let hidefCanvasCssWidth = hidefCanvasWidth;
            let hidefCanvasCssHeight = hidefCanvasHeight;

            $(cv).attr('width', hidefCanvasWidth * window.devicePixelRatio);
            $(cv).attr('height', hidefCanvasHeight * window.devicePixelRatio);
            $(cv).css('width', hidefCanvasCssWidth);
            $(cv).css('height', hidefCanvasCssHeight);
            ctx.scale(window.devicePixelRatio, window.devicePixelRatio);
        }
        drawPoint(deg, wlwl_center_color);
        if ($('#wlwl_center_image').val()) {
            let wl_image = new Image;
            wl_image.onload = function () {
                cv = document.getElementById('wlwl_canvas1');
                ctx = cv.getContext('2d');
                ctx.shadowBlur = 0;
                ctx.shadowOffsetX = 0;
                ctx.shadowOffsetY = 0;
                ctx.shadowColor = '';
                let image_size = 2 * (width / 8 - 7);
                ctx.arc(center, center, image_size / 2, 0, 2 * Math.PI);
                ctx.clip();
                ctx.drawImage(wl_image, center - image_size / 2, center - image_size / 2, image_size, image_size);

            };
            wl_image.src = $('#wlwl_center_image').val();
        }

        drawBorder(wlwl_border_color, 'rgba(0,0,0,0)', 20, 4, 5, 'rgba(0,0,0,0.2)');
        cv = document.getElementById('wlwl_canvas2');
        ctx = cv.getContext('2d');

        cv.width = width;
        cv.height = width;
        if (window.devicePixelRatio) {
            let hidefCanvasWidth = $(cv).attr('width');
            let hidefCanvasHeight = $(cv).attr('height');
            let hidefCanvasCssWidth = hidefCanvasWidth;
            let hidefCanvasCssHeight = hidefCanvasHeight;

            $(cv).attr('width', hidefCanvasWidth * window.devicePixelRatio);
            $(cv).attr('height', hidefCanvasHeight * window.devicePixelRatio);
            $(cv).css('width', hidefCanvasCssWidth);
            $(cv).css('height', hidefCanvasCssHeight);
            ctx.scale(window.devicePixelRatio, window.devicePixelRatio);
        }
        drawBorder('rgba(0,0,0,0)', wlwl_dot_color, 20, 4, 5, 'rgba(0,0,0,0)');
        if (intent_type === 'popup_icon') {
            let notify_time_out = setTimeout(function () {
                $('.wlwl_wheel_icon').addClass('wlwl_show');
            }, initial_time * 1000);
        } else if (intent_type === 'show_wheel') {
            setTimeout(function () {
                $('html').addClass('wlwl-html');
                $('.wlwl_lucky_wheel_content').addClass('lucky_wheel_content_show');
            }, initial_time * 1000);
        } else if (intent_type === 'on_scroll') {
            let htmlHeight, scrollHeight, scrollTop, scrollRate;
            $(document).on('scroll', function () {
                if (!getCookie('wlwl_cookie')) {
                    htmlHeight = $('html').prop('scrollHeight');
                    scrollHeight = window.innerHeight;
                    scrollTop = $('html').prop('scrollTop');
                    if (htmlHeight > 0) {
                        scrollRate = (scrollTop + scrollHeight) * 100 / (htmlHeight);
                        console.log(scrollRate);
                        if (scrollRate > scroll_amount) {
                            $('html').addClass('wlwl-html');
                            $('.wlwl_lucky_wheel_content').addClass('lucky_wheel_content_show');
                        }
                    }
                }
            });
        } else if (intent_type === 'on_exit') {
            $(window).on('mousemove', function (event) {
                let scrollTop = $('html').prop('scrollTop');
                let pageY = event.pageY;
                if (!getCookie('wlwl_cookie')) {
                    if (pageY - scrollTop < 15) {
                        $('html').addClass('wlwl-html');
                        $('.wlwl_lucky_wheel_content').addClass('lucky_wheel_content_show');
                    }
                }
            })
        }

    }

    function drawPopupIcon() {
        cv = document.getElementById('wlwl_popup_canvas');
        if (cv) {
            ctx = cv.getContext('2d');
            for (let k = 0; k < slices; k++) {
                drawSlice1(deg, color[k]);
                deg += sliceDeg;
            }
            drawPoint1(wlwl_center_color);
            drawBorder1(wlwl_border_color, wlwl_dot_color, 4, 1, 0);
        }
    }

    drawPopupIcon();

    function drawSlice1(deg, color) {
        ctx.beginPath();
        ctx.fillStyle = color;
        ctx.moveTo(center1, center1);
        ctx.arc(center1, center1, 32, deg2rad(deg), deg2rad(deg + sliceDeg));
        ctx.lineTo(center1, center1);
        ctx.fill();
    }

    function drawPoint1(color) {
        ctx.save();
        ctx.beginPath();
        ctx.fillStyle = color;
        ctx.arc(center1, center1, 8, 0, 2 * Math.PI);
        ctx.fill();
        ctx.restore();
    }

    function drawBorder1(borderC, dotC, lineW, dotR, des) {
        ctx.beginPath();
        ctx.strokeStyle = borderC;
        ctx.lineWidth = lineW;
        ctx.arc(center1, center1, center1, 0, 2 * Math.PI);
        ctx.stroke();
        let x_val, y_val, deg;
        deg = sliceDeg / 2;
        let center2 = center1 - des;
        for (let i = 0; i < slices; i++) {
            ctx.beginPath();
            ctx.fillStyle = dotC;
            x_val = center1 + center2 * Math.cos(deg * Math.PI / 180);
            y_val = center1 - center2 * Math.sin(deg * Math.PI / 180);
            ctx.arc(x_val, y_val, dotR, 0, 2 * Math.PI);
            ctx.fill();
            deg += sliceDeg;
        }
    }

    /*falling leaves effect*/
    let wlwlLeafScene = function (el) {
        this.viewport = el;
        this.world = document.createElement('div');
        this.leaves = [];

        this.options = {
            numLeaves: 20,
            wind: {
                magnitude: 1.2,
                maxSpeed: 2,
                duration: 500,
                start: 0,
                speed: 0
            }
        };

        this.width = this.viewport.offsetWidth;
        this.height = this.viewport.offsetHeight;

        // animation helper
        this.timer = 0;

        this._resetLeaf = function (leaf) {

            // place leaf towards the top left
            leaf.x = this.width * 2 - Math.random() * this.width * 1.75;
            leaf.y = -10;
            leaf.z = Math.random() * 200;
            if (leaf.x > this.width) {
                leaf.x = this.width + 10;
                leaf.y = Math.random() * this.height / 2;
            }
            // at the start, the leaf can be anywhere
            if (this.timer == 0) {
                leaf.y = Math.random() * this.height;
            }

            // Choose axis of rotation.
            // If axis is not X, chose a random static x-rotation for greater letiability
            leaf.rotation.speed = Math.random() * 10;
            let randomAxis = Math.random();
            if (randomAxis > 0.5) {
                leaf.rotation.axis = 'X';
            } else if (randomAxis > 0.25) {
                leaf.rotation.axis = 'Y';
                leaf.rotation.x = Math.random() * 180 + 90;
            } else {
                leaf.rotation.axis = 'Z';
                leaf.rotation.x = Math.random() * 360 - 180;
                // looks weird if the rotation is too fast around this axis
                leaf.rotation.speed = Math.random() * 3;
            }

            // random speed
            leaf.xSpeedVariation = Math.random() * 0.8 - 0.4;
            leaf.ySpeed = Math.random() + 1.5;

            return leaf;
        }

        this._updateLeaf = function (leaf) {
            let leafWindSpeed = this.options.wind.speed(this.timer - this.options.wind.start, leaf.y);

            let xSpeed = leafWindSpeed + leaf.xSpeedVariation;
            leaf.x -= xSpeed;
            leaf.y += leaf.ySpeed;
            leaf.rotation.value += leaf.rotation.speed;

            let t = 'translateX( ' + leaf.x + 'px ) translateY( ' + leaf.y + 'px ) translateZ( ' + leaf.z + 'px )';
            if (_wlwl_get_email_params.rotate) {
                t += ' rotate' + leaf.rotation.axis + '( ' + leaf.rotation.value + 'deg )';
                if (leaf.rotation.axis !== 'X') {
                    t += ' rotateX(' + leaf.rotation.x + 'deg)';
                }
            }
            leaf.el.style.webkitTransform = t;
            leaf.el.style.MozTransform = t;
            leaf.el.style.oTransform = t;
            leaf.el.style.transform = t;

            // reset if out of view
            if (leaf.x < -10 || leaf.y > this.height + 10) {
                this._resetLeaf(leaf);
            }
        }

        this._updateWind = function () {
            // wind follows a sine curve: asin(b*time + c) + a
            // where a = wind magnitude as a function of leaf position, b = wind.duration, c = offset
            // wind duration should be related to wind magnitude, e.g. higher windspeed means longer gust duration

            if (this.timer === 0 || this.timer > (this.options.wind.start + this.options.wind.duration)) {

                this.options.wind.magnitude = Math.random() * this.options.wind.maxSpeed;
                this.options.wind.duration = this.options.wind.magnitude * 50 + (Math.random() * 20 - 10);
                this.options.wind.start = this.timer;

                let screenHeight = this.height;

                this.options.wind.speed = function (t, y) {
                    // should go from full wind speed at the top, to 1/2 speed at the bottom, using leaf Y
                    let a = this.magnitude / 2 * (screenHeight - 2 * y / 3) / screenHeight;
                    return a * Math.sin(2 * Math.PI / this.duration * t + (3 * Math.PI / 2)) + a;
                }
            }
        }
    };

    wlwlLeafScene.prototype.init = function () {

        for (let i = 0; i < this.options.numLeaves; i++) {
            let leaf = {
                el: document.createElement('div'),
                x: 0,
                y: 0,
                z: 0,
                rotation: {
                    axis: 'X',
                    value: 0,
                    speed: 0,
                    x: 0
                },
                xSpeedVariation: 0,
                ySpeed: 0,
                path: {
                    type: 1,
                    start: 0,

                },
                image: 1
            };
            this._resetLeaf(leaf);
            this.leaves.push(leaf);
            this.world.appendChild(leaf.el);
        }

        this.world.className = 'wlwl-leaf-scene';
        this.viewport.appendChild(this.world);

        // set perspective
        this.world.style.webkitPerspective = "400px";
        this.world.style.MozPerspective = "400px";
        this.world.style.oPerspective = "400px";
        this.world.style.perspective = "400px";

        // reset window height/width on resize
        let self = this;
        window.onresize = function (event) {
            self.width = self.viewport.offsetWidth;
            self.height = self.viewport.offsetHeight;
        };
    };

    wlwlLeafScene.prototype.render = function () {
        this._updateWind();
        for (let i = 0; i < this.leaves.length; i++) {
            this._updateLeaf(this.leaves[i]);
        }

        this.timer++;

        requestAnimationFrame(this.render.bind(this));
    };
    if ($('.wlwl_lucky_wheel_content').hasClass('wlwl-background-effect-falling-leaves')) {
        let leafContainer = document.querySelector('.wheel_content_right');
        let leaves = new wlwlLeafScene(leafContainer);
        leaves.init();
        leaves.render();
    }
});