<?php
/*
Class Name: VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendy
Author: Andy Ha (support@villatheme.com)
Author URI: http://villatheme.com
Copyright 2015 villatheme.com. All rights reserved.
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendy {
	protected $settings;
	protected $api_key;
	protected $login_url;
	protected $brand_id;

	function __construct() {
		$this->settings  = new VI_WOOCOMMERCE_LUCKY_WHEEL_DATA();
		$this->api_key   = $this->settings->get_params( 'wlwl_sendy_api' );
		$this->login_url = $this->settings->get_params( 'wlwl_sendy_login_url' );
		$this->brand_id  = $this->settings->get_params( 'wlwl_sendy_brand' );
	}

	public function get_brands() {
		if ( ! $this->api_key || ! $this->login_url ) {
			return array();
		}

		try {
			$r = wp_remote_post( $this->login_url . '/api/brands/get-brands.php', [
				'body' => [
					'api_key' => $this->api_key,
				]
			] );

			$body = wp_remote_retrieve_body( $r );

			return json_decode( $body ) ?? [];

		} catch ( \Exception $e ) {

		}

		return [];
	}

	public function get_lists() {
		if ( ! $this->api_key || ! $this->login_url || ! $this->brand_id ) {
			return array();
		}

		try {
			$r = wp_remote_post( $this->login_url . '/api/lists/get-lists.php', [
				'body' => [
					'api_key'  => $this->api_key,
					'brand_id' => $this->brand_id,
				]
			] );

			$body = wp_remote_retrieve_body( $r );

			return json_decode( $body ) ?? [];

		} catch ( \Exception $e ) {

		}

		return [];
	}

	public function add_subscribe( $email = '', $firstname = '', $lastname = '', $language = '' ) {
		if ( ! $this->api_key || ! $this->login_url || ! $email ) {
			return;
		}
		$sendy_list_id = $this->settings->get_params( 'wlwl_sendy_list', '', $language );
		$body          = [
			'api_key' => $this->api_key,
			"name"    => $firstname . ' ' . $lastname,
			'email'   => $email,
			"list"    => $sendy_list_id,
			'hp'      => ''
		];
		try {
			$r = wp_remote_post( $this->login_url . '/subscribe', [
				'body' => $body,
			] );

		} catch ( \Exception $e ) {

		}
	}

}
