<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Metrilo {
	protected $settings;
	protected $api_key;
	protected $url;

	public function __construct() {
		$this->settings = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance();
		$this->api_key  = $this->settings->get_params( 'metrilo_token' );
	}

	public function contact_add( $email, $firstname = '', $lastname = '', $language = '' ) {
		global $wp_version, $wc_version;
		$return = array(
			'status' => 'error',
			'data'   => '',
			'code'   => '',
		);

		if ( $this->api_key ) {
			$time           = 1000 * time();
			$metrilo_tag    = $this->settings->get_params( 'metrilo_tag', '', $language );
			$request        = wp_remote_post( 'https://trk.mtrl.me/customer', array(
				'headers' => array( 'Content-Type' => 'text/plain' ),
				'timeout' => 10,
				'body'    => json_encode( array(
					"time"          => $time,
					"token"         => $this->api_key,
					"platform"      => "Wordpress {$wp_version} / WooCommerce {$wc_version}",
					"pluginVersion" => VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION,
					"params"        => array(
						"email"      => $email,
						"createdAt"  => $time,
						"firstName"  => $firstname,
						"lastName"   => $lastname,
						"subscribed" => boolval( $this->settings->get_params( 'metrilo_subscribed' ) ),
						"tags"       => $metrilo_tag ? array_values( array_filter( explode( ',', $metrilo_tag ) ) ) : array()
					)
				) )
			) );
			$code           = wp_remote_retrieve_response_code( $request );
			$return['code'] = $code;
			$return['data'] = wp_remote_retrieve_response_message( $request );
			if ( ! is_wp_error( $request ) ) {
				if ( $code == 200 ) {
					$return['status'] = 'success';
				}
			} else {
				$return['data'] = $request->get_error_message();
			}
		} else {
			$return['data'] = esc_html__( 'Missing token', 'woocommerce-lucky-wheel' );
		}

		return $return;
	}
}
