<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Mailchimp {
	protected $settings;
	protected $api_key;

	public function __construct() {
		$this->settings = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance();
		$this->api_key  = $this->settings->get_params( 'mailchimp', 'api_key' );
	}

	public function get_lists() {
		if ( $this->api_key ) {
			$dash_position = strpos( $this->api_key, '-' );
			if ( $dash_position !== false ) {
				$api_url = 'https://' . substr( $this->api_key, $dash_position + 1 ) . '.api.mailchimp.com/3.0/lists?fields=lists.name,lists.id&count=1000';
				$auth       = base64_encode( 'user:' . esc_attr( $this->api_key ) );

				try {
					$r = wp_remote_get( $api_url, [
						'headers' => [
							'Authorization' => "Basic $auth",
							'Accept'        => 'application/json',
							'Content-Type'  => 'application/json',
						],
					] );

					$body = wp_remote_retrieve_body( $r );

					return json_decode( $body );

				} catch ( \Exception $e ) {

					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}


	public function add_email( $email, $list_id, $fname = '', $lname = '', $phone = '', $birthday = '' ) {
		if ( $this->api_key && $list_id ) {
			$status = 'subscribed';
			if ( $this->settings->get_params( 'mailchimp', 'double_optin' ) == 'on' ) {
				$status = 'pending';
			}
			$data = array(
				'email_address' => $email,
				'status'        => $status,
				'merge_fields'  => array(
					'FNAME'    => $fname,
					'LNAME'    => $lname,
					'PHONE'    => $phone,
					'BIRTHDAY' => $birthday,
				),
			);

			$dataCenter = substr( $this->api_key, strpos( $this->api_key, '-' ) + 1 );
			$url        = 'https://' . esc_attr( $dataCenter ) . '.api.mailchimp.com/3.0/lists/' . esc_attr( $list_id ) . '/members/' . md5( strtolower( $email ) );
			$auth       = base64_encode( 'user:' . esc_attr( $this->api_key ) );

			try {
				$r = wp_remote_post( $url, [
					'method'  => 'PUT',
					'headers' => [
						'Authorization' => "Basic $auth",
						'Accept'        => 'application/json',
						'Content-Type'  => 'application/json',
					],
					'body'    => json_encode( $data ),
				] );

				$body = wp_remote_retrieve_body( $r );

				return true;

			} catch ( \Exception $e ) {

				return false;
			}
		} else {
			return false;
		}
	}


}
