<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Admin {
	protected $settings;
	protected $footer_text;
	protected $language;
	protected $languages;
	protected $default_language;
	protected $languages_data;
	protected $languages_count;

	function __construct() {
		$this->settings         = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance();
		$this->languages        = array();
		$this->languages_count  = 0;
		$this->languages_data   = array();
		$this->default_language = '';
		add_action( 'admin_menu', array( $this, 'add_menu' ) );
		add_action( 'admin_init', array( $this, 'export_emails' ) );
		add_action( 'admin_init', array( $this, 'save_settings' ) );
		add_action( 'admin_init', array( $this, 'check_update' ) );
		add_action( 'wp_ajax_wlwl_search_active_campaign_list', array( $this, 'search_active_campaign_list' ) );
		add_action( 'wp_ajax_wlwl_search_coupon', array( $this, 'search_coupon' ) );
		add_action( 'wp_ajax_wlwl_search_cate', array( $this, 'search_cate' ) );
		add_action( 'wp_ajax_wlwl_search_product', array( $this, 'search_product' ) );
		add_action( 'wp_ajax_wlwl_search_suggested_product', array( $this, 'search_suggested_product' ) );
		add_action( 'wp_ajax_wlwl_preview_emails', array( $this, 'preview_emails_ajax' ) );
		add_action( 'wp_ajax_wlwl_preview_wheel', array( $this, 'preview_wheel_ajax' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		add_action( 'media_buttons', array( $this, 'preview_emails_button' ) );
		add_action( 'admin_footer', array( $this, 'preview_emails_html' ) );
	}

	public function export_emails() {
		$nonce = isset( $_POST['wlwl_export_emails_nonce'] ) ? sanitize_text_field( $_POST['wlwl_export_emails_nonce'] ) : '';
		if ( isset( $_POST['wlwl_export_emails'] ) && wp_verify_nonce( $nonce, 'wlwl_export_emails_nonce_action' ) ) {
			$start    = isset( $_POST['wlwl_export_start'] ) ? sanitize_text_field( $_POST['wlwl_export_start'] ) : '';
			$end      = isset( $_POST['wlwl_export_end'] ) ? sanitize_text_field( $_POST['wlwl_export_end'] ) : '';
			$filename = "lucky_wheel_email";
			if ( ! $start && ! $end ) {
				$args1    = array(
					'post_type'      => 'wlwl_email',
					'posts_per_page' => - 1,
					'post_status'    => 'publish',
				);
				$filename .= date( 'Y-m-d_h-i-s', time() ) . ".csv";
			} elseif ( ! $start ) {
				$args1    = array(
					'post_type'      => 'wlwl_email',
					'posts_per_page' => - 1,
					'post_status'    => 'publish',
					'date_query'     => array(
						array(
							'before'    => $end,
							'inclusive' => true

						)
					),
				);
				$filename .= 'before_' . $end . ".csv";
			} elseif ( ! $end ) {
				$args1    = array(
					'post_type'      => 'wlwl_email',
					'posts_per_page' => - 1,
					'post_status'    => 'publish',
					'date_query'     => array(
						array(
							'after'     => $start,
							'inclusive' => true
						)
					),

				);
				$filename .= 'from' . $start . 'to' . date( 'Y-m-d' ) . ".csv";
			} else {
				if ( strtotime( $start ) > strtotime( $end ) ) {
					wp_die( 'Incorrect input date' );
				}
				$args1    = array(
					'post_type'      => 'wlwl_email',
					'posts_per_page' => - 1,
					'post_status'    => 'publish',
					'date_query'     => array(
						array(
							'before'    => $end,
							'after'     => $start,
							'inclusive' => true

						)
					),
				);
				$filename .= 'from' . $start . 'to' . $end . ".csv";
			}
			$the_query        = new WP_Query( $args1 );
			$csv_source_array = array();
			$names            = array();
			$mobiles          = array();
			$coupons          = array();
			$coupons_labels   = array();
			if ( $the_query->have_posts() ) {
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					$id                 = get_the_ID();
					$csv_source_array[] = get_the_title();
					$names[]            = get_the_content();
					$mobiles[]          = ! empty( get_post_meta( $id, 'wlwl_email_mobile', true ) ) ? get_post_meta( $id, 'wlwl_email_mobile', true ) : '';
					$coupon             = ! empty( get_post_meta( $id, 'wlwl_email_coupons', true ) ) ? get_post_meta( $id, 'wlwl_email_coupons', true ) : array( '' );
					$label              = ! empty( get_post_meta( $id, 'wlwl_email_labels', true ) ) ? get_post_meta( $id, 'wlwl_email_labels', true ) : array( '' );
					if ( is_array( $coupon ) && count( $coupon ) ) {
						$coupons[] = implode( ", ", $coupon );
					}
					if ( is_array( $label ) && count( $label ) ) {
						$coupons_labels[] = implode( ", ", array_map( 'html_entity_decode', $label ) );
					}
				}
				wp_reset_postdata();
				$data_rows  = array();
				$header_row = array(
					'Order',
					'Email',
					'Name',
					'Mobile',
					'Coupon codes',
					'Coupon labels',
				);
				$i          = 1;
				foreach ( $csv_source_array as $key => $result ) {
					$row         = array(
						$i,
						$result,
						$names[ $key ],
						$mobiles[ $key ],
						$coupons[ $key ],
						$coupons_labels[ $key ]
					);
					$data_rows[] = $row;
					$i ++;
				}

				$fh = @fopen( 'php://output', 'w' );
				fprintf( $fh, chr( 0xEF ) . chr( 0xBB ) . chr( 0xBF ) );
				if ( function_exists( 'gc_enable' ) ) {
					gc_enable(); // phpcs:ignore PHPCompatibility.FunctionUse.NewFunctions.gc_enableFound
				}
				if ( function_exists( 'apache_setenv' ) ) {
					@apache_setenv( 'no-gzip', 1 ); // @codingStandardsIgnoreLine
				}
				@ini_set( 'zlib.output_compression', 'Off' ); // @codingStandardsIgnoreLine
				@ini_set( 'output_buffering', 'Off' ); // @codingStandardsIgnoreLine
				@ini_set( 'output_handler', '' ); // @codingStandardsIgnoreLine
				ignore_user_abort( true );
				wc_set_time_limit( 0 );
				wc_nocache_headers();
				header( 'Content-Type: text/csv; charset=utf-8' );
				header( 'Content-Disposition: attachment; filename=' . $filename );
				header( 'Pragma: no-cache' );
				header( 'Expires: 0' );
				fputcsv( $fh, $header_row );
				foreach ( $data_rows as $data_row ) {
					fputcsv( $fh, $data_row );
				}
				$csvFile = stream_get_contents( $fh );
				fclose( $fh );
				die();
			}
		}
	}

	public function preview_emails_html() {
		global $pagenow;
		if ( $pagenow == 'admin.php' && isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'woocommerce-lucky-wheel' ) {
			?>
            <div class="preview-emails-html-container preview-html-hidden">
                <div class="preview-emails-html-overlay"></div>
                <div class="preview-emails-html"></div>
            </div>
			<?php
		}
	}

	function add_menu() {
		add_menu_page(
			esc_html__( 'WooCommerce Lucky Wheel', 'woocommerce-lucky-wheel' ),
			esc_html__( 'WC Lucky Wheel', 'woocommerce-lucky-wheel' ),
			'manage_options',
			'woocommerce-lucky-wheel', array(
			$this,
			'settings_page'
		), 'dashicons-wheel', 2
		);
		add_submenu_page(
			'woocommerce-lucky-wheel',
			esc_html__( 'Wheel Prizes', 'woocommerce-lucky-wheel' ),
			esc_html__( 'Wheel Prizes', 'woocommerce-lucky-wheel' ),
			'manage_options',
			'edit.php?post_type=wlwl_wheel_prize'
		);
		add_submenu_page(
			'woocommerce-lucky-wheel',
			esc_html__( 'Emails', 'woocommerce-lucky-wheel' ),
			esc_html__( 'Emails', 'woocommerce-lucky-wheel' ),
			'manage_options',
			'edit.php?post_type=wlwl_email'
		);
		add_submenu_page(
			'woocommerce-lucky-wheel', esc_html__( 'Report', 'woocommerce-lucky-wheel' ), esc_html__( 'Report', 'woocommerce-lucky-wheel' ), 'manage_options', 'wlwl-report', array(
				$this,
				'report_callback'
			)
		);
		add_submenu_page(
			'woocommerce-lucky-wheel', esc_html__( 'System Status', 'woocommerce-lucky-wheel' ), esc_html__( 'System Status', 'woocommerce-lucky-wheel' ), 'manage_options', 'wlwl-system-status', array(
				$this,
				'system_status'
			)
		);
	}


	public function preview_emails_button( $editor_id ) {
		global $pagenow;
		if ( $pagenow == 'admin.php' && isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'woocommerce-lucky-wheel' ) {
			$editor_ids = array( 'content' );
			if ( $this->languages_count ) {
				foreach ( $this->languages as $key => $value ) {
					$editor_ids[] = 'content_' . $value;
				}
			}
			if ( in_array( $editor_id, $editor_ids ) ) {
				ob_start();
				?>
                <span class="button wlwl-preview-emails-button"
                      data-wlwl_language="<?php echo esc_attr( str_replace( 'content', '', $editor_id ) ) ?>"><?php esc_html_e( 'Preview emails', 'woocommerce-lucky-wheel' ) ?></span>
				<?php
				echo ob_get_clean();
			}
		}
	}

	public function wc_price( $price, $args = array() ) {
		extract(
			apply_filters(
				'wc_price_args', wp_parse_args(
					$args, array(
						'ex_tax_label'       => false,
						'currency'           => get_option( 'woocommerce_currency' ),
						'decimal_separator'  => get_option( 'woocommerce_price_decimal_sep' ),
						'thousand_separator' => get_option( 'woocommerce_price_thousand_sep' ),
						'decimals'           => get_option( 'woocommerce_price_num_decimals', 2 ),
						'price_format'       => get_woocommerce_price_format(),
					)
				)
			)
		);
		$currency_pos = get_option( 'woocommerce_currency_pos' );
		$price_format = '%1$s%2$s';

		switch ( $currency_pos ) {
			case 'left' :
				$price_format = '%1$s%2$s';
				break;
			case 'right' :
				$price_format = '%2$s%1$s';
				break;
			case 'left_space' :
				$price_format = '%1$s&nbsp;%2$s';
				break;
			case 'right_space' :
				$price_format = '%2$s&nbsp;%1$s';
				break;
		}

		$unformatted_price = $price;
		$negative          = $price < 0;
		$price             = apply_filters( 'raw_woocommerce_price', floatval( $negative ? $price * - 1 : $price ) );
		$price             = apply_filters( 'formatted_woocommerce_price', number_format( $price, $decimals, $decimal_separator, $thousand_separator ), $price, $decimals, $decimal_separator, $thousand_separator );

		if ( apply_filters( 'woocommerce_price_trim_zeros', false ) && $decimals > 0 ) {
			$price = wc_trim_zeros( $price );
		}
		if ( isset( $this->settings->get_params( 'wheel' )['currency'] ) && $this->settings->get_params( 'wheel' )['currency'] == 'code' ) {
			$formatted_price = ( $negative ? '-' : '' ) . sprintf( $price_format, ( $currency ), $price );
		} else {
			$formatted_price = ( $negative ? '-' : '' ) . sprintf( $price_format, wlwl_get_currency_symbol( $currency ), $price );
		}

		return $formatted_price;
	}

	public function preview_wheel_ajax() {
		$label          = isset( $_GET['label'] ) ? wc_clean( $_GET['label'] ) : array();
		$coupon_type    = isset( $_GET['coupon_type'] ) ? wc_clean( $_GET['coupon_type'] ) : array();
		$prize_quantity = isset( $_GET['prize_quantity'] ) ? wc_clean( $_GET['prize_quantity'] ) : array();
		$quantity_label = isset( $_GET['quantity_label'] ) ? wc_clean( $_GET['quantity_label'] ) : array();
		$coupon_amount  = isset( $_GET['coupon_amount'] ) ? wc_clean( $_GET['coupon_amount'] ) : array();
		$labels         = array();
		if ( is_array( $label ) && count( $label ) ) {
			for ( $i = 0; $i < count( $label ); $i ++ ) {
				$wheel_label      = stripslashes( $label[ $i ] );
				$quantity_label_1 = '';
				if ( $coupon_type[ $i ] !== 'non' ) {
					if ( $prize_quantity[ $i ] > 0 ) {
						$quantity_label_1 = str_replace( '{prize_quantity}', $prize_quantity[ $i ], $quantity_label );
					}
					switch ( $coupon_type[ $i ] ) {
						case 'custom':
						case 'existing_coupon':
							break;
						case 'percent':
							$wheel_label = str_replace( '{coupon_amount}', $coupon_amount[ $i ] . '%', $wheel_label );
							break;
						case 'fixed_cart':
						case 'fixed_product':
							$wheel_label = str_replace( '{coupon_amount}', $this->wc_price( $coupon_amount[ $i ] ), $wheel_label );
							$wheel_label = str_replace( '&nbsp;', ' ', $wheel_label );
							break;
						default:
							$post = get_post( $coupon_type[ $i ] );
							if ( $post && $post->post_status === 'publish' ) {
								$wheel_label = str_replace( '{wheel_prize_title}', $post->post_title, $wheel_label );
								if ( get_post_meta( $coupon_type[ $i ], 'coupon_type', true ) === 'percent' ) {
									$wheel_label = str_replace( '{coupon_amount}', get_post_meta( $coupon_type[ $i ], 'coupon_amount', true ) . '%', $wheel_label );
								} else {
									$wheel_label = str_replace( '{coupon_amount}', $this->wc_price( get_post_meta( $coupon_type[ $i ], 'coupon_amount', true ) ), $wheel_label );
									$wheel_label = str_replace( '&nbsp;', ' ', $wheel_label );
								}
							} else {
								$wheel_label = esc_html__( 'Coupon not exists, please select an other one.', 'woocommerce-lucky-wheel' );
							}
					}
				}
				$wheel_label = str_replace( '{quantity_label}', $quantity_label_1, $wheel_label );
				$wheel_label = str_replace( array( '{coupon_amount}', '{wheel_prize_title}' ), '', $wheel_label );
				$labels[]    = $wheel_label;
			}
		}
		wp_send_json( array( 'labels' => $labels ) );
	}

	public function preview_emails_ajax() {
		$content              = isset( $_GET['content'] ) ? wp_kses_post( stripslashes( $_GET['content'] ) ) : '';
		$email_heading        = isset( $_GET['heading'] ) ? wc_clean( stripslashes( $_GET['heading'] ) ) : '';
		$this->footer_text    = isset( $_GET['footer_text'] ) ? wc_clean( stripslashes( $_GET['footer_text'] ) ) : '';
		$button_shop_url      = isset( $_GET['button_shop_url'] ) ? wc_clean( stripslashes( $_GET['button_shop_url'] ) ) : '';
		$button_shop_size     = isset( $_GET['button_shop_size'] ) ? wc_clean( stripslashes( $_GET['button_shop_size'] ) ) : '';
		$button_shop_color    = isset( $_GET['button_shop_color'] ) ? wc_clean( stripslashes( $_GET['button_shop_color'] ) ) : '';
		$button_shop_bg_color = isset( $_GET['button_shop_bg_color'] ) ? wc_clean( stripslashes( $_GET['button_shop_bg_color'] ) ) : '';
		$button_shop_title    = isset( $_GET['button_shop_title'] ) ? wc_clean( stripslashes( $_GET['button_shop_title'] ) ) : '';
		$suggested_products   = isset( $_GET['suggested_products'] ) ? wc_clean( array_map( 'stripslashes', ( $_GET['suggested_products'] ) ) ) : array();

		$button_shop_now        = '<a href="' . esc_url( $button_shop_url ) . '" target="_blank" style="text-decoration:none;display:inline-block;padding:10px 30px;margin:10px 0;font-size:' . esc_attr( $button_shop_size ) . 'px;color:' . esc_attr( $button_shop_color ) . ';background:' . esc_attr( $button_shop_bg_color ) . ';">' . esc_html( $button_shop_title ) . '</a>';
		$coupon_label           = '10% OFF';
		$coupon_code            = 'LUCKY_WHEEL';
		$date_expires           = strtotime( '+30 days' );
		$customer_name          = 'John';
		$content                = str_replace( '{coupon_label}', $coupon_label, $content );
		$content                = str_replace( '{customer_name}', $customer_name, $content );
		$content                = str_replace( '{coupon_code}', '<span style="font-size: x-large;">' . strtoupper( $coupon_code ) . '</span>', $content );
		$content                = str_replace( '{date_expires}', empty( $date_expires ) ? esc_html__( 'never expires', 'woocommerce-lucky-wheel' ) : date_i18n( 'F d, Y', ( $date_expires ) ), $content );
		$content                = str_replace( '{shop_now}', $button_shop_now, $content );
		$featured_products      = wc_get_featured_product_ids();
		$featured_products_html = '';
		if ( is_array( $featured_products ) && count( $featured_products ) ) {
			$featured_products_html = '<table style="width: 100%;">';
			foreach ( $featured_products as $p ) {
				$product                = wc_get_product( $p );
				$featured_products_html .= '<tr><td style="text-align: center;"><a href="' . esc_url( $product->get_permalink() ) . '" target="_blank"><img style="width: 150px;" src="' . wp_get_attachment_thumb_url( $product->get_image_id() ) . '"></a></td><td><p>' . $product->get_title() . '</p><p>' . $product->get_price_html() . '</p><a target="_blank" style="text-align: center;font-size:' . $button_shop_size . 'px; background-color: ' . ( $button_shop_bg_color ) . ';color: ' . ( $button_shop_color ) . ';padding: 10px;text-decoration: none;" href="' . $product->get_permalink() . '" >' . $button_shop_title . '</a></td></tr>';
			}
			$featured_products_html .= '</table>';
		}
		$content = str_replace( '{featured_products}', $featured_products_html, $content );
		if ( is_array( $suggested_products ) && count( $suggested_products ) ) {
			$content .= '<table style="width: 100%;">';
			foreach ( $suggested_products as $suggested_product ) {
				$product = wc_get_product( $suggested_product );
				if ( $product->get_parent_id() ) {
					continue;
				}
				$content .= '<tr><td style="text-align: center;"><a href="' . esc_url( $product->get_permalink() ) . '" target="_blank"><img style="width: 150px;" src="' . wp_get_attachment_thumb_url( $product->get_image_id() ) . '"></a></td><td><p>' . esc_html( $product->get_title() ) . '</p><p>' . wp_kses_post( $product->get_price_html() ) . '</p><a target="_blank" style="text-align: center;font-size:' . esc_html( $button_shop_size ) . 'px; background-color: ' . esc_html( $button_shop_bg_color ) . ';color: ' . esc_html( $button_shop_color ) . ';padding: 10px;text-decoration: none;" href="' . esc_html( $product->get_permalink() ) . '" >' . esc_html( $button_shop_title ) . '</a></td></tr>';
			}
			$content .= '</table>';
		}
		$email_heading = str_replace( '{coupon_label}', $coupon_label, $email_heading );

		// load the mailer class
		$mailer = WC()->mailer();

		// create a new email
		$email             = new WC_Email();
		$this->footer_text = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::replace_placeholders( $this->footer_text );
		add_filter( 'woocommerce_email_footer_text', array( $this, 'woocommerce_email_footer_text' ) );
		// wrap the content with the email template and then add styles
		$message = apply_filters( 'woocommerce_mail_content', $email->style_inline( $mailer->wrap_message( $email_heading, $content ) ) );
		remove_filter( 'woocommerce_email_footer_text', array( $this, 'woocommerce_email_footer_text' ) );
		// print the preview email
		wp_send_json(
			array(
				'html' => $message,
			)
		);
	}

	public function woocommerce_email_footer_text( $footer_text ) {
		$footer_text = $this->footer_text;

		return $footer_text;
	}

	public function search_active_campaign_list() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		ob_start();
		$keyword = filter_input( INPUT_GET, 'keyword', FILTER_SANITIZE_STRING );
		if ( empty( $keyword ) ) {
			die();
		}
		$active_campaign = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Active_Campaign();
		$list            = $active_campaign->list_list( $keyword );
		$found_products  = array();
		if ( $list['result_code'] == 1 ) {
			foreach ( $list as $key => $val ) {
				if ( is_array( $val ) ) {
					if ( isset( $val['id'] ) ) {
						$product          = array( 'id' => $val['id'], 'text' => $val['name'] );
						$found_products[] = $product;
					}
				}
			}
		}
		wp_send_json( $found_products );
	}

	public function search_cate() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		ob_start();

		$keyword = filter_input( INPUT_GET, 'keyword', FILTER_SANITIZE_STRING );
		if ( ! $keyword ) {
			$keyword = filter_input( INPUT_POST, 'keyword', FILTER_SANITIZE_STRING );
		}
		if ( empty( $keyword ) ) {
			die();
		}
		$categories = get_terms(
			array(
				'taxonomy' => 'product_cat',
				'orderby'  => 'name',
				'order'    => 'ASC',
				'search'   => $keyword,
				'number'   => 100
			)
		);
		$items      = array();
		if ( count( $categories ) ) {
			foreach ( $categories as $category ) {
				$item    = array(
					'id'   => $category->term_id,
					'text' => $category->name
				);
				$items[] = $item;
			}
		}
		wp_send_json( $items );
	}

	public function search_product() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		$keyword = filter_input( INPUT_GET, 'keyword', FILTER_SANITIZE_STRING );
		if ( empty( $keyword ) ) {
			die();
		}
		$arg            = array(
			'post_status'    => 'publish',
			'post_type'      => 'product',
			'posts_per_page' => 50,
			's'              => $keyword
		);
		$the_query      = new WP_Query( $arg );
		$found_products = array();
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$prd = wc_get_product( get_the_ID() );
				if ( $prd->has_child() && $prd->is_type( 'variable' ) ) {
					$product_children = $prd->get_children();
					if ( count( $product_children ) ) {
						foreach ( $product_children as $product_child ) {
							if ( woocommerce_version_check() ) {
								$product = array(
									'id'   => $product_child,
									'text' => get_the_title( $product_child )
								);
							} else {
								$child_wc  = wc_get_product( $product_child );
								$get_atts  = $child_wc->get_variation_attributes();
								$attr_name = array_values( $get_atts )[0];
								$product   = array(
									'id'   => $product_child,
									'text' => get_the_title() . ' - ' . $attr_name
								);
							}
							$found_products[] = $product;
						}
					}
				} else {
					$product          = array( 'id' => get_the_ID(), 'text' => get_the_title() );
					$found_products[] = $product;
				}
			}
		}
		wp_send_json( $found_products );
	}

	public function search_coupon() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		ob_start();
		$keyword = filter_input( INPUT_GET, 'keyword', FILTER_SANITIZE_STRING );
		if ( empty( $keyword ) ) {
			die();
		}
		$arg            = array(
			'post_status'    => 'publish',
			'post_type'      => 'shop_coupon',
			'posts_per_page' => 50,
			'meta_query'     => array(
				'relation' => 'AND',
				array(
					'key'     => 'wlwl_unique_coupon',
					'compare' => 'NOT EXISTS'
				),
				array(
					'key'     => 'kt_unique_coupon',
					'compare' => 'NOT EXISTS'
				)
			),
			's'              => $keyword
		);
		$the_query      = new WP_Query( $arg );
		$found_products = array();
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$coupon = new WC_Coupon( get_the_ID() );
				if ( $coupon->get_usage_limit() > 0 && $coupon->get_usage_count() >= $coupon->get_usage_limit() ) {
					continue;
				}
				if ( $coupon->get_date_expires() && time() > $coupon->get_date_expires()->getTimestamp() ) {
					continue;
				}
				$product          = array( 'id' => get_the_ID(), 'text' => get_the_title() );
				$found_products[] = $product;
			}
		}
		wp_send_json( $found_products );
	}

	public function search_suggested_product() {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		ob_start();

		$keyword = filter_input( INPUT_GET, 'keyword', FILTER_SANITIZE_STRING );

		if ( empty( $keyword ) ) {
			die();
		}
		$arg            = array(
			'post_status'    => 'publish',
			'post_type'      => 'product',
			'posts_per_page' => 50,
			's'              => $keyword

		);
		$the_query      = new WP_Query( $arg );
		$found_products = array();
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				$product_id    = get_the_ID();
				$product_title = get_the_title();
				$the_product   = new WC_Product( $product_id );
				if ( ! $the_product->is_in_stock() ) {
					$product_title .= ' (out-of-stock)';
				}
				$product          = array( 'id' => $product_id, 'text' => $product_title );
				$found_products[] = $product;
			}
		}
		wp_send_json( $found_products );
	}

	public function admin_enqueue_scripts() {
		if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] === 'woocommerce-lucky-wheel' ) {
			global $wp_scripts;
			$scripts = $wp_scripts->registered;
			foreach ( $scripts as $k => $script ) {
				preg_match( '/select2/i', $k, $result );
				if ( count( array_filter( $result ) ) ) {
					unset( $wp_scripts->registered[ $k ] );
					wp_dequeue_script( $script->handle );
				}
				preg_match( '/bootstrap/i', $k, $result );
				if ( count( array_filter( $result ) ) ) {
					unset( $wp_scripts->registered[ $k ] );
					wp_dequeue_script( $script->handle );
				}
			}
			wp_enqueue_script( 'woocommerce-lucky-wheel-fontselect-js', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'jquery.fontselect.min.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-gift-icons-css', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'giftbox.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-fontselect-css', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'fontselect-default.css' );

			wp_enqueue_script( 'woocommerce-lucky-wheel-semantic-js-form', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'form.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-form', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'form.min.css' );
			wp_enqueue_script( 'woocommerce-lucky-wheel-semantic-js-transition', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'transition.min.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-transition', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'transition.min.css' );
			wp_enqueue_script( 'woocommerce-lucky-wheel-semantic-js-dropdown', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'dropdown.min.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-dropdown', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'dropdown.min.css' );
			wp_enqueue_script( 'woocommerce-lucky-wheel-semantic-js-checkbox', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'checkbox.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-checkbox', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'checkbox.min.css' );
			wp_enqueue_script( 'woocommerce-lucky-wheel-select2-js', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'select2.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-select2-css', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'select2.min.css' );
			wp_enqueue_script( 'woocommerce-lucky-wheel-semantic-js-tab', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'tab.js', array( 'jquery' ) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-tab', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'tab.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-input', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'input.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-button', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'button.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-icon', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'icon.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-table', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'table.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-segment', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'segment.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-label', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'label.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-menu', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'menu.min.css' );
			wp_enqueue_style( 'woocommerce-lucky-wheel-semantic-css-message', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'message.min.css' );
			wp_enqueue_script( 'jquery-ui-sortable' );
			/*Color picker*/
			wp_enqueue_script(
				'iris', admin_url( 'js/iris.min.js' ), array(
				'jquery-ui-draggable',
				'jquery-ui-slider',
				'jquery-touch-punch'
			), false, 1
			);

			wp_enqueue_script( 'media-upload' );
			if ( ! did_action( 'wp_enqueue_media' ) ) {
				wp_enqueue_media();
			}

			wp_enqueue_script( 'woocommerce-lucky-wheel-jquery-address-javascript', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'jquery.address-1.6.min.js', array( 'jquery' ), VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION );
			wp_enqueue_script( 'woocommerce-lucky-wheel-admin-javascript', VI_WOOCOMMERCE_LUCKY_WHEEL_JS . 'admin-javascript.js', array( 'jquery' ), VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION );
			wp_localize_script( 'woocommerce-lucky-wheel-admin-javascript', 'woo_lucky_wheel_params_admin', array(
				'url' => admin_url( 'admin-ajax.php' ),
			) );
			wp_enqueue_style( 'woocommerce-lucky-wheel-admin-style', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'admin-style.css', array(), VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION );
			$inline_css          = '';
			$popup_icon_color    = $this->settings->get_params( 'notify', 'popup_icon_color' );
			$popup_icon_bg_color = $this->settings->get_params( 'notify', 'popup_icon_bg_color' );
			if ( $popup_icon_color ) {
				$inline_css .= ".vi-ui.button.wheel-popup-icon.wheel-popup-icon-selected{color:{$popup_icon_color};}";
			}
			if ( $popup_icon_bg_color ) {
				$inline_css .= ".vi-ui.button.wheel-popup-icon.wheel-popup-icon-selected{background-color:{$popup_icon_bg_color};}";
			}
			wp_add_inline_style( 'woocommerce-lucky-wheel-admin-style', $inline_css );
		}
		wp_enqueue_style( 'woocommerce-lucky-wheel-admin-icon-style', VI_WOOCOMMERCE_LUCKY_WHEEL_CSS . 'admin-icon-style.css' );
	}

	public function settings_page() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		?>
        <div class="wrap">
            <h2><?php esc_html_e( 'WooCommerce Lucky Wheel Settings', 'woocommerce-lucky-wheel' ); ?></h2>
            <form action="" method="POST" class="vi-ui form">
				<?php wp_nonce_field( 'wlwl_settings_page_save', 'wlwl_nonce_field' ); ?>
                <div class="vi-ui top attached tabular menu">
                    <div class="item active"
                         data-tab="general"><?php esc_html_e( 'General', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="popup"><?php esc_html_e( 'Pop-up', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="wheel-wrap"><?php esc_html_e( 'Wheel Background', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="custom-fields"><?php esc_html_e( 'Custom Fields', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="wheel"><?php esc_html_e( 'Wheel Settings', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="result"><?php esc_html_e( 'Inform Result', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="coupon"><?php esc_html_e( 'Unique Coupon', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="email_api"><?php esc_html_e( 'Email API', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="grecaptcha"><?php esc_html_e( 'Google reCAPTCHA', 'woocommerce-lucky-wheel' ); ?></div>
                    <div class="item"
                         data-tab="update"><?php esc_html_e( 'Update', 'woocommerce-lucky-wheel' ); ?></div>
                </div>
                <!--General-->
                <div class="vi-ui bottom attached active tab segment" data-tab="general">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th>
                                <label for="wlwl_enable"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="wlwl_enable"
                                           id="wlwl_enable" <?php checked( $this->settings->get_params( 'general', 'enable' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wlwl_enable_mobile"><?php esc_html_e( 'Enable mobile', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="wlwl_enable_mobile"
                                           id="wlwl_enable_mobile" <?php checked( $this->settings->get_params( 'general', 'mobile' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="ajax_endpoint"><?php esc_html_e( 'Ajax endpoint', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="equal width fields">
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input type="radio" name="ajax_endpoint"
                                                   id="ajax_endpoint_ajax"
                                                   value="ajax" <?php checked( $this->settings->get_params( 'ajax_endpoint' ), 'ajax' ) ?>>
                                            <label for="ajax_endpoint_ajax"><?php esc_html_e( 'Ajax', 'woocommerce-lucky-wheel' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input type="radio" name="ajax_endpoint"
                                                   id="ajax_endpoint_rest_api"
                                                   value="rest_api" <?php checked( $this->settings->get_params( 'ajax_endpoint' ), 'rest_api' ) ?>>
                                            <label for="ajax_endpoint_rest_api"><?php esc_html_e( 'REST API', 'woocommerce-lucky-wheel' ); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <p><?php esc_html_e( 'Only use REST API if Ajax is not working for you', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wlwl_spin_num"><?php esc_html_e( 'The number of spins per email', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <input type="number" id="wlwl_spin_num" name="wlwl_spin_num" min="1"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'general', 'spin_num' ) ); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wlwl_delay"><?php esc_html_e( 'Gap between 2 spins', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input type="number" id="wlwl_delay" name="wlwl_delay"
                                       min="0"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'general', 'delay' ) ); ?>">
                                <p><?php esc_html_e( 'Gap time between 2 consecutive spins of an email', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                            <td>
                                <select name="wlwl_delay_unit" class="vi-ui fluid dropdown">
                                    <option value="s" <?php selected( $this->settings->get_params( 'general', 'delay_unit' ), 's' ) ?>>
										<?php esc_html_e( 'Seconds', 'woocommerce-lucky-wheel' ); ?>
                                    </option>
                                    <option value="m" <?php selected( $this->settings->get_params( 'general', 'delay_unit' ), 'm' ) ?>><?php esc_html_e( 'Minutes', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="h" <?php selected( $this->settings->get_params( 'general', 'delay_unit' ), 'h' ) ?>><?php esc_html_e( 'Hours', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="d" <?php selected( $this->settings->get_params( 'general', 'delay_unit' ), 'd' ) ?>><?php esc_html_e( 'Days', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="choose_using_white_black_list"><?php esc_html_e( 'Choose using white/black list', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="equal width fields">
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input type="radio" name="choose_using_white_black_list"
                                                   id="choose_using_white_list"
                                                   value="white_list" <?php checked( $this->settings->get_params( 'choose_using_white_black_list' ), 'white_list' ) ?>>
                                            <label for="choose_using_white_list"><?php esc_html_e( 'White List', 'woocommerce-lucky-wheel' ); ?></label>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input type="radio" name="choose_using_white_black_list"
                                                   id="choose_using_black_list"
                                                   value="black_list" <?php checked( $this->settings->get_params( 'choose_using_white_black_list' ), 'black_list' ) ?>>
                                            <label for="choose_using_black_list"><?php esc_html_e( 'Black List', 'woocommerce-lucky-wheel' ); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <p><?php esc_html_e( 'Choose white or black list email can spin', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="white_list"><?php esc_html_e( 'White list', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <textarea name="white_list"><?php echo wp_kses_post( $this->settings->get_params( 'white_list' ) ) ?></textarea>
                                <p class="description"><?php esc_html_e( 'Enter domains to this list, each domain per line, leave empty if not use this feature', 'woocommerce-lucky-wheel' ) ?></p>
                                <p class="description"><?php esc_html_e( 'Ex: abc@email.com is "email.com"', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="black_list"><?php esc_html_e( 'Black list', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <textarea name="black_list"><?php echo wp_kses_post( $this->settings->get_params( 'black_list' ) ) ?></textarea>
                                <p class="description"><?php esc_html_e( 'Enter domains to this list, each domain per line, leave empty if not use this feature', 'woocommerce-lucky-wheel' ) ?></p>
                                <p class="description"><?php esc_html_e( 'Ex: abc@email.com is "email.com"', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Popup-->
                <div class="vi-ui bottom attached tab segment" data-tab="popup">
                    <table class="form-table">
                        <tbody>
						<?php
						$icons               = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_gift_icons();
						$popup_icon          = $this->settings->get_params( 'notify', 'popup_icon' );
						$popup_icon_color    = $this->settings->get_params( 'notify', 'popup_icon_color' );
						$popup_icon_bg_color = $this->settings->get_params( 'notify', 'popup_icon_bg_color' );
						?>
                        <tr>
                            <th>
                                <label><?php esc_html_e( 'Custom popup icon', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui segment wheel-popup-icons-container">
									<?php
									foreach ( $icons as $icon ) {
										?>
                                        <span class="vi-ui button wheel-popup-icon <?php echo esc_attr( $popup_icon === $icon ? 'wheel-popup-icon-selected' : '' ); ?>"
                                              data-wheel_popup_icon="<?php echo esc_attr( $icon ) ?>"><span
                                                    class="<?php echo esc_attr( VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_gift_icon_class( $icon ) ) ?>"></span></span>
										<?php
									}
									?>
                                    <input type="hidden" name="wheel_popup_icon"
                                           value="<?php echo esc_attr( $popup_icon ); ?>">
                                </div>
                                <p><?php esc_html_e( 'If no icon is selected, a small version of your real wheel will be used', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_popup_icon_color"><?php esc_html_e( 'Custom popup icon color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <input type="text" class="color-picker" name="wheel_popup_icon_color"
                                       id="wheel_popup_icon_color"
                                       value="<?php if ( $popup_icon_color ) {
									       echo esc_attr( $popup_icon_color );
								       } ?>"
                                       style="background-color:<?php if ( $popup_icon_color ) {
									       echo esc_attr( $popup_icon_color );
								       } ?>;">
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_popup_icon_bg_color"><?php esc_html_e( 'Custom popup icon background color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <input type="text" class="color-picker" name="wheel_popup_icon_bg_color"
                                       id="wheel_popup_icon_bg_color"
                                       value="<?php if ( $popup_icon_bg_color ) {
									       echo esc_attr( $popup_icon_bg_color );
								       } ?>"
                                       style="background-color:<?php if ( $popup_icon_bg_color ) {
									       echo esc_attr( $popup_icon_bg_color );
								       } ?>;">
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_position"><?php esc_html_e( 'Popup icon position', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <select name="notify_position" id="notify_position" class="vi-ui fluid dropdown">
                                    <option value="top-left" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'top-left' ) ?>><?php esc_html_e( 'Top Left', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="top-right" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'top-right' ) ?>><?php esc_html_e( 'Top Right', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="middle-left" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'middle-left' ) ?>><?php esc_html_e( 'Middle Left', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="middle-right" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'middle-right' ) ?>><?php esc_html_e( 'Middle Right', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="bottom-left" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'bottom-left' ) ?>><?php esc_html_e( 'Bottom Left', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="bottom-right" <?php selected( $this->settings->get_params( 'notify', 'position' ), 'bottom-right' ) ?>><?php esc_html_e( 'Bottom Right', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>
                                <p><?php esc_html_e( 'Position of the popup on screen', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>

                        <tr>
                            <th>
                                <label for="notify_intent"><?php esc_html_e( 'Trigger wheel with', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td colspan="2">
                                <select name="notify_intent" class="vi-ui fluid dropdown">
                                    <option value="popup_icon" <?php selected( $this->settings->get_params( 'notify', 'intent' ), 'popup_icon' ) ?>><?php esc_html_e( 'Popup icon', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="show_wheel" <?php selected( $this->settings->get_params( 'notify', 'intent' ), 'show_wheel' ) ?>><?php esc_html_e( 'Automatically show wheel after initial time', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="on_scroll" <?php selected( $this->settings->get_params( 'notify', 'intent' ), 'on_scroll' ) ?>><?php esc_html_e( 'Show wheel after users scroll down a specific value', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="on_exit" <?php selected( $this->settings->get_params( 'notify', 'intent' ), 'on_exit' ) ?>><?php esc_html_e( 'Show wheel when users move mouse over the top to close browser', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="random" <?php selected( $this->settings->get_params( 'notify', 'intent' ), 'random' ) ?>><?php esc_html_e( 'Random one of these above', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>
                            </td>

                        </tr>
                        <tr>
                            <th>
                                <label for="show_wheel"><?php esc_html_e( 'Initial time', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td colspan="2">
                                <input type="text" id="show_wheel" name="show_wheel"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'notify', 'show_wheel' ) ); ?>">
                                <p><?php esc_html_e( 'Gap time before the popup icon appears after the action to trigger is done. This gap time is selected randomly within the range you add. Enter min,max time (seconds). For example: 1,2', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="scroll_amount"><?php esc_html_e( 'Scroll amount(%)', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td colspan="2">
                                <input type="number" id="scroll_amount" name="scroll_amount"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'notify', 'scroll_amount' ) ); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_hide_popup"><?php esc_html_e( 'Hide popup icon', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="notify_hide_popup"
                                           id="notify_hide_popup" <?php checked( $this->settings->get_params( 'notify', 'hide_popup' ), 'on' ) ?>>
                                    <label>
                                        <p class="description"><?php esc_html_e( 'Enable to hide the popup icon after the user closes the wheel.', 'woocommerce-lucky-wheel' ); ?></p>
                                    </label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_time_on_close"><?php esc_html_e( 'If the wheel is closed without a spin, show the popup again after', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input type="number" id="notify_time_on_close" name="notify_time_on_close"
                                       min="0"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'notify', 'time_on_close' ) ); ?>">
                            </td>
                            <td>
                                <select name="notify_time_on_close_unit" class="vi-ui fluid dropdown">
                                    <option value="m" <?php selected( $this->settings->get_params( 'notify', 'time_on_close_unit' ), 'm' ) ?>><?php esc_html_e( 'Minutes', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="h" <?php selected( $this->settings->get_params( 'notify', 'time_on_close_unit' ), 'h' ) ?>><?php esc_html_e( 'Hours', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="d" <?php selected( $this->settings->get_params( 'notify', 'time_on_close_unit' ), 'd' ) ?>><?php esc_html_e( 'Days', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>
                            </td>
                        </tr>

                        <tr>
                            <th>
                                <label for="notify_show_again"><?php esc_html_e( 'When the spin is done, show the popup again after', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input type="number" id="notify_show_again" name="notify_show_again"
                                       min="0"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'notify', 'show_again' ) ); ?>">
                            </td>
                            <td>
                                <select name="notify_show_again_unit" class="vi-ui fluid dropdown">
                                    <option value="s" <?php selected( $this->settings->get_params( 'notify', 'show_again_unit' ), 's' ) ?>><?php esc_html_e( 'Seconds', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="m" <?php selected( $this->settings->get_params( 'notify', 'show_again_unit' ), 'm' ) ?>><?php esc_html_e( 'Minutes', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="h" <?php selected( $this->settings->get_params( 'notify', 'show_again_unit' ), 'h' ) ?>><?php esc_html_e( 'Hours', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="d" <?php selected( $this->settings->get_params( 'notify', 'show_again_unit' ), 'd' ) ?>><?php esc_html_e( 'Days', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_frontpage_only"><?php esc_html_e( 'Show only on Homepage', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="notify_frontpage_only"
                                           id="notify_frontpage_only" <?php checked( $this->settings->get_params( 'notify', 'show_only_front' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                                <p><?php esc_html_e( 'Enable to make the popup icon only work on the Home page', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_blogpage_only"><?php esc_html_e( 'Show only on Blog page', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="notify_blogpage_only"
                                           id="notify_blogpage_only" <?php checked( $this->settings->get_params( 'notify', 'show_only_blog' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                                <p><?php esc_html_e( 'Enable to make the popup icon only work on the Blog page', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>

                        <tr>
                            <th>
                                <label for="notify_shop_only"><?php esc_html_e( 'Show only on Shop page', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="notify_shop_only"
                                           id="notify_shop_only" <?php checked( $this->settings->get_params( 'notify', 'show_only_shop' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                                <p><?php esc_html_e( 'Enable to make the popup icon only work on the Shop page', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="notify_conditional_tags"><?php esc_html_e( 'Conditional tags', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td colspan="2">
                                <input type="text" name="notify_conditional_tags"
                                       placeholder="<?php esc_html_e( 'Ex: !is_page(array(123,41,20))', 'woocommerce-lucky-wheel' ) ?>"
                                       id="notify_conditional_tags"
                                       value="<?php if ( $this->settings->get_params( 'notify', 'conditional_tags' ) ) {
									       echo htmlentities( $this->settings->get_params( 'notify', 'conditional_tags' ) );
								       } ?>">
                                <p class="description"><?php esc_html_e( 'Let you control on which pages Woocommerce Lucky wheel icon appears using ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="http://codex.wordpress.org/Conditional_Tags"><?php esc_html_e( 'WP\'s conditional tags', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                                <p class="description">
                                    <strong>*</strong><?php esc_html_e( '"Home page", "Blog page" and "Shop page" options above must be disabled to run these conditional tags.', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description"><?php esc_html_e( 'Use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_cart()</strong><?php esc_html_e( ' to show only on cart page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description"><?php esc_html_e( 'Use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_checkout()</strong><?php esc_html_e( ' to show only on checkout page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description"><?php esc_html_e( 'Use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_product_category()</strong><?php esc_html_e( 'to show only on WooCommerce category page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description"><?php esc_html_e( 'Use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_shop()</strong><?php esc_html_e( ' to show only on WooCommerce shop page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description"><?php esc_html_e( 'Use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_product()</strong><?php esc_html_e( ' to show only on WooCommerce single product page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description">
                                    <strong>**</strong><?php esc_html_e( 'Combining 2 or more conditionals using || to show wheel if 1 of the conditionals matched. e.g use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>is_cart() ||
                                        is_checkout()</strong><?php esc_html_e( ' to show only on cart page and checkout page', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                                <p class="description">
                                    <strong>***</strong><?php esc_html_e( 'Use exclamation mark(!) before a conditional to hide wheel if the conditional matched. e.g use ', 'woocommerce-lucky-wheel' ); ?>
                                    <strong>!is_home()</strong><?php esc_html_e( ' to hide wheel on homepage', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                </div>
                <!--Wheel Background-->
                <div class="vi-ui bottom attached tab segment" data-tab="wheel-wrap">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th>
                                <label for="wheel_wrap_bg_image"><?php esc_html_e( 'Background image', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td id="wlwl-bg-image">
								<?php
								if ( $this->settings->get_params( 'wheel_wrap', 'bg_image' ) ) {
									$bg_image_url = wc_is_valid_url( $this->settings->get_params( 'wheel_wrap', 'bg_image' ) ) ? $this->settings->get_params( 'wheel_wrap', 'bg_image' ) : wp_get_attachment_url( $this->settings->get_params( 'wheel_wrap', 'bg_image' ) );
									?>
                                    <div class="wlwl-image-container">
                                        <img style="border: 1px solid;width: 300px;" class="review-images"
                                             src="<?php echo esc_url( $bg_image_url ); ?>"/>
                                        <input class="wheel_wrap_bg_image" name="wheel_wrap_bg_image"
                                               type="hidden"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'bg_image' ) ); ?>"/>
                                        <span class="wlwl-remove-image negative vi-ui button"><?php esc_html_e( 'Remove', 'woocommerce-lucky-wheel' ); ?></span>
                                    </div>
                                    <div id="wlwl-new-image" style="float: left;">
                                    </div>
                                    <span style="display: none;"
                                          class="positive vi-ui button wlwl-upload-custom-img tiny"><?php esc_html_e( 'Add Image', 'woocommerce-lucky-wheel' ); ?></span>
									<?php
								} else {
									?>
                                    <div id="wlwl-new-image" style="float: left;">
                                    </div>
                                    <span class="positive vi-ui button wlwl-upload-custom-img tiny"><?php esc_html_e( 'Add Image', 'woocommerce-lucky-wheel' ); ?></span>
									<?php
								}
								?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_bg_color"><?php esc_html_e( 'Background color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="wheel_wrap_bg_color" id="wheel_wrap_bg_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'bg_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'bg_color' ) );
								       } ?>"
                                       style="background: <?php if ( $this->settings->get_params( 'wheel_wrap', 'bg_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'bg_color' ) );
								       } ?>;"/>
                            </td>
                        </tr>
						<?php
						$background_effect  = $this->settings->get_params( 'wheel_wrap', 'background_effect' );
						$background_effects = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_all_bg_effects();
						?>
                        <tr>
                            <th>
                                <label for="background_effect"><?php esc_html_e( 'Background effect', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <select name="background_effect" id="background_effect"
                                        class="vi-ui fluid dropdown">
									<?php
									foreach ( $background_effects as $bg_e_k => $bg_e ) {
										?>
                                        <option value="<?php echo esc_attr( $bg_e_k ) ?>" <?php selected( $background_effect, $bg_e_k ) ?>>
											<?php echo esc_html( $bg_e ); ?>
                                        </option>
										<?php
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_text_color"><?php esc_html_e( 'Content text color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="wheel_wrap_text_color" id="wheel_wrap_text_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'text_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'text_color' ) );
								       } ?>"
                                       style="background: <?php if ( $this->settings->get_params( 'wheel_wrap', 'text_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'text_color' ) );
								       } ?>;"/>
                                <p><?php esc_html_e( 'Text color in the wheel background content, including wheel description, text to not show the wheel again... Note: This option may be affected by your theme.', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_description"><?php esc_html_e( 'Wheel description', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td>
								<?php
								$desc_option = array( 'editor_height' => 200, 'media_buttons' => true );
								$this->print_default_country_flag();
								wp_editor( stripslashes( $this->settings->get_params( 'wheel_wrap', 'description' ) ), 'wheel_wrap_description', $desc_option );
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'wheel_wrap_description_' . esc_attr( $value ); ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_attr( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
										<?php
										wp_editor( stripslashes( $this->settings->get_params( 'wheel_wrap', 'description', $value ) ), 'wheel_wrap_description_' . $value, $desc_option );
									}
								}
								?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_spin_button"><?php esc_html_e( 'Spin Wheel button', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
								<?php $this->print_default_country_flag() ?>
                                <input type="text" name="wheel_wrap_spin_button" id="wheel_wrap_spin_button"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'spin_button' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button' ) );
								       } ?>">
								<?php
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'wheel_wrap_spin_button_' . esc_attr( $value ); ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_attr( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
                                        <input id="<?php echo 'wheel_wrap_spin_button_' . esc_attr( $value ) ?>"
                                               type="text"
                                               name="<?php echo 'wheel_wrap_spin_button_' . esc_attr( $value ) ?>"
                                               value="<?php echo stripslashes( esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button', $value ) ) ); ?>">
										<?php
									}
								}
								?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_spin_button_color"><?php esc_html_e( 'Spin Wheel button color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input type="text" class="color-picker" name="wheel_wrap_spin_button_color"
                                       id="wheel_wrap_spin_button_color"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'spin_button_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button_color' ) );
								       } ?>"
                                       style="background-color:<?php if ( $this->settings->get_params( 'wheel_wrap', 'spin_button_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button_color' ) );
								       } ?>;">
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_wrap_spin_button_bg_color"><?php esc_html_e( 'Spin Wheel button background color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input type="text" class="color-picker" name="wheel_wrap_spin_button_bg_color"
                                       id="wheel_wrap_spin_button_bg_color"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'spin_button_bg_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button_bg_color' ) );
								       } ?>"
                                       style="background-color:<?php if ( $this->settings->get_params( 'wheel_wrap', 'spin_button_bg_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'spin_button_bg_color' ) );
								       } ?>;">
                            </td>
                        </tr>


                        <tr>
                            <th>
                                <label for="wheel_wrap_close_option"><?php esc_html_e( 'Not display wheel again', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" name="wheel_wrap_close_option"
                                           id="wheel_wrap_close_option" <?php checked( $this->settings->get_params( 'wheel_wrap', 'close_option' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Enable this option to show "Never", "Remind later" and "No thanks" below the Spin Wheel button. The wheel will be hidden afterward if the user clicks one of these text.', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wlwl-google-font-select"><?php esc_html_e( 'Select font', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>

                                <input type="text" name="wlwl_google_font_select"
                                       id="wlwl-google-font-select"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'font' ) ); ?>"><span
                                        class="wlwl-google-font-select-remove wlwl-cancel"
                                        style="<?php if ( ! $this->settings->get_params( 'wheel_wrap', 'font' ) ) {
											echo 'display:none';
										} ?>"></span>
                                <p><?php esc_html_e( 'Only works with the content of wheel background.', 'woocommerce-lucky-wheel' ); ?></p>


                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="gdpr_policy"><?php esc_html_e( 'GDPR checkbox', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="gdpr_policy" type="checkbox" id="gdpr_policy"
                                           name="gdpr_policy"
                                           value="on" <?php checked( $this->settings->get_params( 'wheel_wrap', 'gdpr' ), 'on' ) ?>>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="gdpr_message"><?php esc_html_e( 'GDPR message', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								$option = array( 'editor_height' => 200, 'media_buttons' => false );
								$this->print_default_country_flag();
								wp_editor( stripslashes( $this->settings->get_params( 'wheel_wrap', 'gdpr_message' ) ), 'gdpr_message', $option );
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'gdpr_message_' . esc_attr( $value ); ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_html( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
										<?php
										wp_editor( stripslashes( $this->settings->get_params( 'wheel_wrap', 'gdpr_message', $value ) ), 'gdpr_message_' . $value, $option );
									}
								}
								?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_css"><?php esc_html_e( 'Custom css', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <textarea
                                        name="custom_css"><?php echo wp_kses_post( $this->settings->get_params( 'wheel_wrap', 'custom_css' ) ) ?></textarea>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Custom Fields-->
                <div class="vi-ui bottom attached tab segment" data-tab="custom-fields">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th>
                                <label for="custom_field_name_enable"><?php esc_html_e( '"Name" field', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_name_enable" type="checkbox"
                                           id="custom_field_name_enable"
                                           name="custom_field_name_enable"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_name_enable' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Enable a field for customers to enter their name before spinning', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_field_name_enable_mobile"><?php esc_html_e( '"Name" field on mobile', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_name_enable_mobile" type="checkbox"
                                           id="custom_field_name_enable_mobile"
                                           name="custom_field_name_enable_mobile"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_name_enable_mobile' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Enable the "Name" field for mobile users', 'woocommerce-lucky-wheel' ); ?></label>

                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_field_name_required"><?php esc_html_e( '"Name" field is required', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_name_required" type="checkbox"
                                           id="custom_field_name_required"
                                           name="custom_field_name_required"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_name_required' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Make the field mandatory. User must enter their name before spinning', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_field_mobile_enable"><?php esc_html_e( '"Phone number" field', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_mobile_enable" type="checkbox"
                                           id="custom_field_mobile_enable"
                                           name="custom_field_mobile_enable"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_mobile_enable' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Enable a field for customers to enter their phone number before spinning', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_field_mobile_enable_mobile"><?php esc_html_e( '"Phone number" field on mobile', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_mobile_enable_mobile" type="checkbox"
                                           id="custom_field_mobile_enable_mobile"
                                           name="custom_field_mobile_enable_mobile"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_mobile_enable_mobile' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Enable the "Phone number" field for mobile users', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="custom_field_mobile_required"><?php esc_html_e( '"Phone number" field is required', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="custom_field_mobile_required" type="checkbox"
                                           id="custom_field_mobile_required"
                                           name="custom_field_mobile_required"
                                           value="on" <?php checked( $this->settings->get_params( 'custom_field_mobile_required' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Make the field mandatory. User must enter their phone number before spinning', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Wheels Settings-->
                <div class="vi-ui bottom attached tab segment" data-tab="wheel">
                    <span class="vi-ui positive button preview-lucky-wheel labeled icon tiny"><i
                                class="icon eye"></i><?php esc_html_e( 'Preview Wheel', 'woocommerce-lucky-wheel' ); ?></span>
                    <table class="form-table wheel-settings">
                        <tbody class="content">
                        <tr>
                            <th>
                                <label for="pointer_position"><?php esc_html_e( 'Pointer position', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>

                                <select name="pointer_position" id="pointer_position" class="vi-ui fluid dropdown">
                                    <option value="center" <?php selected( $this->settings->get_params( 'wheel_wrap', 'pointer_position' ), 'center' ) ?>><?php esc_html_e( 'Center', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="top" <?php selected( $this->settings->get_params( 'wheel_wrap', 'pointer_position' ), 'top' ) ?>><?php esc_html_e( 'Top', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="right" <?php selected( $this->settings->get_params( 'wheel_wrap', 'pointer_position' ), 'right' ) ?>><?php esc_html_e( 'Right', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="bottom" <?php selected( $this->settings->get_params( 'wheel_wrap', 'pointer_position' ), 'bottom' ) ?>><?php esc_html_e( 'Bottom', 'woocommerce-lucky-wheel' ); ?></option>
                                    <option value="random" <?php selected( $this->settings->get_params( 'wheel_wrap', 'pointer_position' ), 'random' ) ?>><?php esc_html_e( 'Random', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="pointer_color"><?php esc_html_e( 'Wheel pointer color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="pointer_color" id="pointer_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'pointer_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'pointer_color' ) );
								       } ?>"
                                       style="background-color: <?php if ( $this->settings->get_params( 'wheel_wrap', 'pointer_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'pointer_color' ) );
								       } ?>;"/>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wlwl-center-image1"><?php esc_html_e( 'Wheel center background image', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td id="wlwl-bg-image1">
								<?php
								if ( $this->settings->get_params( 'wheel_wrap', 'wheel_center_image' ) ) {
									?>
                                    <div class="wlwl-image-container1">
                                        <img style="border: 1px solid;" class="review-images1"
                                             src="<?php echo wp_get_attachment_thumb_url( $this->settings->get_params( 'wheel_wrap', 'wheel_center_image' ) ); ?>"/>
                                        <input class="wheel_center_image" name="wheel_center_image"
                                               type="hidden"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_center_image' ) ); ?>"/>
                                        <span class="wlwl-remove-image1 negative vi-ui button"><?php esc_html_e( 'Remove', 'woocommerce-lucky-wheel' ); ?></span>
                                    </div>
                                    <div id="wlwl-new-image1" style="float: left;">
                                    </div>
                                    <span style="display: none;"
                                          class="positive vi-ui button wlwl-upload-custom-img1 tiny"><?php esc_html_e( 'Add Image', 'woocommerce-lucky-wheel' ); ?></span>
									<?php
								} else {
									?>
                                    <div id="wlwl-new-image1" style="float: left;">
                                    </div>
                                    <span class="positive vi-ui button wlwl-upload-custom-img1 tiny"><?php esc_html_e( 'Add Image', 'woocommerce-lucky-wheel' ); ?></span>
									<?php
								}
								?>
                            </td>
                        </tr>


                        <tr>
                            <th>
                                <label for="wheel_center_color"><?php esc_html_e( 'Wheel center color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="wheel_center_color" id="wheel_center_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_center_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_center_color' ) );
								       } ?>"
                                       style="background-color: <?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_center_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_center_color' ) );
								       } ?>;"/>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_border_color"><?php esc_html_e( 'Wheel border color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="wheel_border_color" id="wheel_border_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_border_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_border_color' ) );
								       } ?>"
                                       style="background-color: <?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_border_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_border_color' ) );
								       } ?>;"/>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_dot_color"><?php esc_html_e( 'Wheel border dot color', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <input name="wheel_dot_color" id="wheel_dot_color" type="text"
                                       class="color-picker"
                                       value="<?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_dot_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_dot_color' ) );
								       } ?>"
                                       style="background-color: <?php if ( $this->settings->get_params( 'wheel_wrap', 'wheel_dot_color' ) ) {
									       echo esc_attr( $this->settings->get_params( 'wheel_wrap', 'wheel_dot_color' ) );
								       } ?>;"/>
                            </td>
                        </tr>

                        <tr>
                            <th>
                                <label for="wlwl-currency"><?php esc_html_e( 'Displayed Currency', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>

                                <select name="wlwl_currency" id="wlwl-currency" class="vi-ui fluid dropdown">
                                    <option value="symbol" <?php selected( $this->settings->get_params( 'wheel', 'currency' ), 'symbol' ) ?>><?php esc_html_e( 'Symbol', 'woocommerce-lucky-wheel' ); ?>
                                        (₫, $, &euro;, &pound;...)
                                    </option>
                                    <option value="code" <?php selected( $this->settings->get_params( 'wheel', 'currency' ), 'code' ) ?>><?php esc_html_e( 'Currency code in English(VND, USD, EUR, GBP ...)', 'woocommerce-lucky-wheel' ); ?></option>
                                </select>

                            </td>
                        </tr>
                        <tr>
                        <tr>
                            <th>
                                <label for="wheel_speed"><?php esc_html_e( 'Wheel speed', 'woocommerce-lucky-wheel' ); ?></label>
                            </th>
                            <td>
                                <select name="wheel_speed" id="wheel_speed" class="vi-ui fluid dropdown">
									<?php
									for ( $i = 1; $i <= 10; $i ++ ) {
										?>
                                        <option value="<?php esc_attr_e( $i ) ?>" <?php selected( $this->settings->get_params( 'wheel', 'wheel_speed' ), $i ) ?>><?php esc_html_e( $i ); ?></option>
										<?php
									}
									?>
                                </select>
                                <p><?php esc_html_e( 'The number of spins per one second. For example, if you select 10, it means the wheel spins 10 rolls in one second', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_spinning_time">
									<?php esc_html_e( 'Spinning duration', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td colspan="4">
                                <div class="vi-ui right labeled input">
                                    <input type="number" min="3" max="15" name="wheel_spinning_time"
                                           id="wheel_spinning_time"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'wheel', 'spinning_time' ) ); ?>">
                                    <label class="vi-ui label">
										<?php esc_html_e( 'Seconds', 'woocommerce-lucky-wheel' ); ?>
                                    </label>
                                </div>
                                <p><?php esc_html_e( 'How long the wheel will spin. Valid duration from 3 to 15 seconds', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="show_full_wheel"><?php esc_html_e( 'Show full wheel', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input class="show_full_wheel" type="checkbox" id="show_full_wheel"
                                           name="show_full_wheel"
                                           value="on" <?php checked( $this->settings->get_params( 'wheel', 'show_full_wheel' ), 'on' ) ?>>
                                    <label><?php esc_html_e( 'Make all wheel slices visible on desktop.By default, the wheel on desktop shows partially. Enable this option to to make it show fully.', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="font_size"><?php esc_html_e( 'Adjust font size of text on the wheel by', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui right labeled input">
                                    <input type="number" class="font_size" id="font_size"
                                           name="font_size"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'wheel', 'font_size' ) ); ?>">
                                    <label class="vi-ui label"><?php esc_html_e( '%', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="wheel_size"><?php esc_html_e( 'Adjust wheel size by', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui right labeled input">
                                    <input type="number" class="wheel_size" id="wheel_size"
                                           name="wheel_size"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'wheel', 'wheel_size' ) ); ?>">
                                    <label class="vi-ui label"><?php esc_html_e( '%', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <div class="vi-ui message positive tiny">
                        <ul class="list">
                            <li><?php _e( 'Use <strong>{coupon_amount}</strong> for WooCommerce coupon type to refer to the amount of that coupon. e.g: Coupon type is percentage discount, coupon value is 10 then <strong>{coupon_amount}</strong> will become 10% when printing out on the wheel.', 'woocommerce-lucky-wheel' ); ?></li>
                            <li><?php _e( '<strong>{quantity_label}</strong> is used in prize label if quantity is greater than 0', 'woocommerce-lucky-wheel' ); ?></li>
                            <li><?php _e( '<strong>{wheel_prize_title}</strong> can be used to refer to the title if coupon type is a <a href="edit.php?post_type=wlwl_wheel_prize" target="_blank">Wheel Prize</a>', 'woocommerce-lucky-wheel' ); ?></li>
                            <li><?php _e( 'If quantity of a prize is down to zero, its probability will be 0 instead its original probability and <strong>{quantity_label}</strong> will be replace with empty string', 'woocommerce-lucky-wheel' ); ?></li>
                            <li><?php _e( 'To use different emails for each prize, please use <a href="https://1.envato.market/BZZv1" target="_blank">WooCommerce Email Template Customizer</a> or <a href="http://bit.ly/woo-email-template-customizer" target="_blank">Email Template Customizer for WooCommerce</a> to create and customize your own email template.', 'woocommerce-lucky-wheel' ) ?></li>
							<?php
							if ( VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::is_email_template_customizer_active() ) {
								?>
                                <li>
                                    <a href="edit.php?post_type=viwec_template"
                                       target="_blank"><?php esc_html_e( 'View all Email templates', 'woocommerce-lucky-wheel' ) ?></a>
									<?php esc_html_e( 'or', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="post-new.php?post_type=viwec_template&sample=wlwl_coupon_email&style=basic"
                                       target="_blank"><?php esc_html_e( 'Create a new email template', 'woocommerce-lucky-wheel' ) ?></a>
                                </li>
								<?php
							}
							?>
                        </ul>
                    </div>
                    <table class="form-table">
                        <tr>
                            <th>
                                <label for="quantity_label"><?php esc_html_e( '{quantity_label}', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								self::print_default_country_flag();
								?>
                                <input type="text" class="quantity_label" id="quantity_label"
                                       name="quantity_label"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wheel', 'quantity_label' ) ) ?>">
								<?php
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'subject_' . esc_attr( $value ); ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_html( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
                                        <input id="<?php echo 'quantity_label_' . esc_attr( $value ) ?>" type="text"
                                               name="<?php echo 'quantity_label_' . esc_attr( $value ) ?>"
                                               value="<?php echo esc_attr( stripslashes( $this->settings->get_params( 'wheel', 'quantity_label', $value ) ) ); ?>">
										<?php
									}
								}
								?>
                                <p><?php esc_html_e( '{prize_quantity} - The quantity of respective prize', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                    </table>
                    <div class="wheel-settings-container">
                        <table class="vi-ui celled table wheel-settings">
                            <thead>
                            <tr class="wheel-slices">
                                <th width="1%"
                                    rowspan="2"
                                    class="wheel-index-th"><?php esc_html_e( 'Index', 'woocommerce-lucky-wheel' ) ?></th>
                                <th rowspan="2"><?php esc_html_e( 'Coupon Type', 'woocommerce-lucky-wheel' ) ?></th>
								<?php
								if ( $this->languages_count ) {
									?>
                                    <th colspan="<?php echo esc_attr( ( 1 + $this->languages_count ) ) ?>"><?php esc_html_e( 'Label', 'woocommerce-lucky-wheel' ) ?></th>
									<?php
								} else {
									?>
                                    <th rowspan="2"><?php esc_html_e( 'Label', 'woocommerce-lucky-wheel' ) ?></th>
									<?php
								}
								?>
                                <th rowspan="2"><?php esc_html_e( 'Value', 'woocommerce-lucky-wheel' ) ?></th>
                                <th width="123px"
                                    colspan="2"><?php esc_html_e( 'Probability', 'woocommerce-lucky-wheel' ) ?></th>
                                <th width="1%"
                                    rowspan="2"><?php esc_html_e( 'Quantity', 'woocommerce-lucky-wheel' ) ?></th>
								<?php
								if ( $this->languages_count ) {
									?>
                                    <th colspan="<?php echo esc_attr( ( 1 + $this->languages_count ) ) ?>"><?php esc_html_e( 'Email Template', 'woocommerce-lucky-wheel' ) ?></th>
									<?php
								} else {
									?>
                                    <th rowspan="2"><?php esc_html_e( 'Email Template', 'woocommerce-lucky-wheel' ) ?></th>
									<?php
								}
								?>
                                <th width="110px"
                                    rowspan="2"><?php esc_html_e( 'Color', 'woocommerce-lucky-wheel' ) ?></th>
                                <th width="110px"
                                    rowspan="2"><?php esc_html_e( 'Text Color', 'woocommerce-lucky-wheel' ) ?></th>
                            </tr>
                            <tr class="wheel-slices">
								<?php
								if ( $this->languages_count ) {
									?>
                                    <th style="border-left: 1px solid rgba(34,36,38,.1);">
										<?php
										if ( isset( $this->languages_data[ $this->default_language ]['country_flag_url'] ) && $this->languages_data[ $this->default_language ]['country_flag_url'] ) {
											?>
                                            <img src="<?php echo esc_url( $this->languages_data[ $this->default_language ]['country_flag_url'] ); ?>">
											<?php
										}
										echo esc_html( $this->default_language );
										if ( isset( $this->languages_data[ $this->default_language ]['translated_name'] ) ) {
											echo '(' . esc_html( $this->languages_data[ $this->default_language ]['translated_name'] ) . ')';
										}
										?>
                                    </th>
									<?php
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <th><?php
											if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
												?>
                                                <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
												<?php
											}
											echo esc_html( $value );
											if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
												echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
											}
											?>
                                        </th>
										<?php
									}
								}
								?>
                                <th style="border-left: 1px solid rgba(34,36,38,.1);"><?php esc_html_e( 'Weight', 'woocommerce-lucky-wheel' ) ?></th>
                                <th><?php esc_html_e( 'Percentage', 'woocommerce-lucky-wheel' ) ?></th>
								<?php
								if ( $this->languages_count ) {
									?>
                                    <th>
										<?php
										if ( isset( $this->languages_data[ $this->default_language ]['country_flag_url'] ) && $this->languages_data[ $this->default_language ]['country_flag_url'] ) {
											?>
                                            <img alt="image"
                                                 src="<?php echo esc_url( $this->languages_data[ $this->default_language ]['country_flag_url'] ); ?>">
											<?php
										}
										echo esc_html( $this->default_language );
										if ( isset( $this->languages_data[ $this->default_language ]['translated_name'] ) ) {
											echo '(' . esc_html( $this->languages_data[ $this->default_language ]['translated_name'] ) . ')';
										}
										?>
                                    </th>
									<?php
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <th><?php
											if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
												?>
                                                <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
												<?php
											}
											echo esc_html( $value );
											if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
												echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
											}
											?>
                                        </th>
										<?php
									}
								}
								?>
                            </tr>
                            </thead>
                            <tbody class="ui-sortable">
							<?php
							$coupon_type         = $this->settings->get_params( 'wheel', 'coupon_type' );
							$coupon_amount       = $this->settings->get_params( 'wheel', 'coupon_amount' );
							$probability         = $this->settings->get_params( 'wheel', 'probability' );
							$existing_coupon     = $this->settings->get_params( 'wheel', 'existing_coupon' );
							$custom_value        = $this->settings->get_params( 'wheel', 'custom_value' );
							$custom_label        = $this->settings->get_params( 'wheel', 'custom_label' );
							$slices_text_color   = $this->settings->get_params( 'wheel', 'slices_text_color' );
							$bg_color            = $this->settings->get_params( 'wheel', 'bg_color' );
							$coupon_count        = count( $coupon_type );
							$all_email_templates = self::get_email_templates();
							$email_templates     = $this->settings->get_params( 'wheel', 'email_templates' );
							$prize_quantity      = $this->settings->get_params( 'wheel', 'prize_quantity' );
							if ( count( $email_templates ) !== $coupon_count ) {
								$email_templates = array_fill( 0, $coupon_count, '' );
							}
							if ( count( $prize_quantity ) !== $coupon_count ) {
								$prize_quantity = array_fill( 0, $coupon_count, - 1 );
							}
							$dynamic_coupons = VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Wheel_Prize::get_coupons();
							for ( $count = 0; $count < $coupon_count; $count ++ ) {
								$coupon_amount_unit = '';
								if ( $coupon_type[ $count ] === 'percent' ) {
									$coupon_amount_unit = '%';
								} elseif ( $coupon_type[ $count ] === 'fixed_product' || $coupon_type[ $count ] === 'fixed_cart' ) {
									$coupon_amount_unit = get_woocommerce_currency_symbol();
								}
								$is_dynamic_coupon = ! in_array( $coupon_type[ $count ], array(
									'non',
									'existing_coupon',
									'percent',
									'fixed_product',
									'fixed_cart',
									'custom'
								) );
								?>
                                <tr class="wheel_col <?php echo esc_attr( $is_dynamic_coupon ? 'wheel_col-dynamic_coupon' : "wheel_col-{$coupon_type[ $count ]}" ); ?>">
                                    <td class="wheel_col_index remove_field_wrap" width="1%">
                                        <span class="wheel-col-index"><?php echo( $count + 1 ); ?></span>
                                        <span class="remove_field negative vi-ui button"
                                              title="<?php esc_attr_e( 'Remove this item', 'woocommerce-lucky-wheel' ); ?>"><i
                                                    class="icon trash"></i></span>
                                        <span class="clone_piece positive vi-ui button"
                                              title="<?php esc_attr_e( 'Clone this item', 'woocommerce-lucky-wheel' ); ?>"><i
                                                    class="icon copy"></i></span>
                                    </td>
                                    <td class="wheel_col_coupons">
                                        <select name="coupon_type[]" class="coupons_select vi-ui fluid dropdown">
                                            <option value="non" <?php selected( $coupon_type[ $count ], 'non' ); ?>><?php esc_html_e( 'Non', 'woocommerce-lucky-wheel' ) ?></option>
                                            <option value="existing_coupon" <?php selected( $coupon_type[ $count ], 'existing_coupon' ); ?>><?php esc_html_e( 'Existing coupon', 'woocommerce-lucky-wheel' ) ?></option>
                                            <option value="percent" <?php selected( $coupon_type[ $count ], 'percent' ); ?>><?php esc_html_e( 'Percentage discount', 'woocommerce-lucky-wheel' ) ?></option>
                                            <option value="fixed_product" <?php selected( $coupon_type[ $count ], 'fixed_product' ); ?>><?php esc_html_e( 'Fixed product discount', 'woocommerce-lucky-wheel' ) ?></option>
                                            <option value="fixed_cart" <?php selected( $coupon_type[ $count ], 'fixed_cart' ); ?>><?php esc_html_e( 'Fixed cart discount', 'woocommerce-lucky-wheel' ) ?></option>
                                            <option value="custom" <?php selected( $coupon_type[ $count ], 'custom' ); ?>><?php esc_html_e( 'Custom', 'woocommerce-lucky-wheel' ) ?></option>
											<?php
											if ( count( $dynamic_coupons ) ) {
												foreach ( $dynamic_coupons as $dynamic_coupon ) {
													?>
                                                    <option value="<?php echo esc_attr( $dynamic_coupon->ID ) ?>" <?php selected( $coupon_type[ $count ], $dynamic_coupon->ID ); ?>
                                                            data-coupon_amount="<?php echo esc_attr( get_post_meta( $dynamic_coupon->ID, 'coupon_amount', true ) ) ?>"><?php echo esc_html( "(#{$dynamic_coupon->ID}){$dynamic_coupon->post_title}" ) ?></option>
													<?php
												}
											}
											?>
                                        </select>
                                    </td>
                                    <td class="wheel_col_coupons_label">
                                        <input type="text" name="custom_type_label[]" class="custom_type_label"
                                               value="<?php echo esc_attr( $custom_label[ $count ] ); ?>"
                                               placeholder="Label"/>
                                    </td>
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											$custom_label_lang = $this->settings->get_params( 'wheel', 'custom_label', $value );
											?>
                                            <td class="wheel_col_coupons_label">
                                                <input type="text"
                                                       name="<?php echo esc_attr( "custom_type_label_{$value}[]" ) ?>"
                                                       class="custom_type_label"
                                                       value="<?php echo isset( $custom_label_lang[ $count ] ) ? esc_attr( $custom_label_lang[ $count ] ) : esc_attr( $custom_label[ $count ] ); ?>"
                                                       placeholder="Label"/>
                                            </td>
											<?php
										}
									}
									?>
                                    <td class="wheel_col_coupons_value">
                                        <input type="number" name="coupon_amount[]" min="0" step=".01"
                                               class="coupon_amount <?php echo ( $is_dynamic_coupon || $coupon_type[ $count ] === 'non' ) ? 'coupon-amount-readonly' : ''; ?>"
                                               value="<?php echo esc_attr( $coupon_amount[ $count ] ); ?>"
                                               placeholder="Coupon Amount" <?php if ( $is_dynamic_coupon || $coupon_type[ $count ] === 'non' ) {
											echo 'readonly';
										} ?>/>
                                        <input type="text" name="custom_type_value[]" class="custom_type_value"
                                               value="<?php echo isset( $custom_value[ $count ] ) ? esc_attr( $custom_value[ $count ] ) : ''; ?>"
                                               placeholder="Value/Code"/>
                                        <div class="wlwl_existing_coupon">
                                            <select name="wlwl_existing_coupon[]"
                                                    class="coupon-search wlwl_existing_coupon select2-selection--single"
                                                    data-placeholder="<?php esc_attr_e( 'Enter Code', 'woocommerce-lucky-wheel' ) ?>">
												<?php
												$coupon_id    = '';
												$coupon_title = '';
												if ( isset( $existing_coupon[ $count ] ) ) {
													$coupon_obj = get_post( $existing_coupon[ $count ] );
													if ( $coupon_obj ) {
														$coupon_id    = $existing_coupon[ $count ];
														$coupon_title = $coupon_obj->post_title;
													}
												}
												?>
                                                <option value="<?php echo esc_attr( $coupon_id ) ?>"
                                                        selected><?php echo esc_html( $coupon_title ) ?></option>
                                            </select>
                                        </div>
                                    </td>
                                    <td class="wheel_col_probability">
                                        <input type="number" name="probability[]"
                                               class="probability probability_<?php echo esc_attr( $count ); ?>" min="0"
                                               placeholder="Probability"
                                               value="<?php echo esc_attr( absint( $probability[ $count ] ) ) ?>"/>
                                    </td>
                                    <td class="wheel_col_probability_percent">
                                        <div class="vi-ui right labeled left input fluid">
                                            <input type="text"
                                                   class="probability-percent probability-percent-<?php echo esc_attr( $count ); ?>"
                                                   min="0" readonly disabled>
                                            <label for="" class="vi-ui label">%</label>
                                        </div>

                                    </td>
                                    <td class="wheel_col_prize_quantity">
                                        <input type="number" name="prize_quantity[]"
                                               class="prize_quantity prize_quantity_<?php echo esc_attr( $count ); ?>"
                                               min="-1"
                                               value="<?php echo esc_attr( intval( $prize_quantity[ $count ] ) ) ?>"/>
                                    </td>
                                    <td class="wheel_email_template">
                                        <select class="vi-ui dropdown fluid" type="text"
                                                name="email_templates[]">
                                            <option value=""><?php esc_html_e( 'None', 'woocommerce-lucky-wheel' ) ?></option>
											<?php
											if ( count( $all_email_templates ) ) {
												foreach ( $all_email_templates as $all_email_templates_k => $all_email_templates_v ) {
													?>
                                                    <option value="<?php echo esc_attr( $all_email_templates_v->ID ); ?>" <?php selected( $all_email_templates_v->ID, $email_templates[ $count ] ); ?>><?php echo esc_html( "(#{$all_email_templates_v->ID}){$all_email_templates_v->post_title}" ); ?></option>
													<?php
												}
											}
											?>
                                        </select>
                                    </td>
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											$email_templates_lang = $this->settings->get_params( 'wheel', 'email_templates', $value );
											?>
                                            <td class="wheel_col_email_templates">
                                                <select class="vi-ui dropdown fluid" type="text"
                                                        name="<?php echo esc_attr( "email_templates_{$value}[]" ) ?>">
                                                    <option value=""><?php esc_html_e( 'None', 'woocommerce-lucky-wheel' ) ?></option>
													<?php
													if ( count( $all_email_templates ) ) {
														foreach ( $all_email_templates as $all_email_templates_k => $all_email_templates_v ) {
															?>
                                                            <option value="<?php echo esc_attr( $all_email_templates_v->ID ); ?>" <?php selected( $all_email_templates_v->ID, $email_templates_lang[ $count ] ); ?>><?php echo esc_html( "(#{$all_email_templates_v->ID}){$all_email_templates_v->post_title}" ); ?></option>
															<?php
														}
													}
													?>
                                                </select>
                                            </td>
											<?php
										}
									}
									?>
                                    <td>
                                        <input type="text" name="bg_color[]" class="color-picker"
                                               value=" <?php echo esc_attr( trim( $bg_color[ $count ] ) ); ?>"
                                               style="background: <?php echo esc_attr( trim( $bg_color[ $count ] ) ); ?>"/>
                                    </td>
                                    <td>
                                        <input type="text" name="slices_text_color[]"
                                               class="color-picker"
                                               value="<?php echo isset( $slices_text_color[ $count ] ) ? esc_attr( trim( $slices_text_color[ $count ] ) ) : ''; ?>"
                                               style="background:<?php echo isset( $slices_text_color[ $count ] ) ? esc_attr( trim( $slices_text_color[ $count ] ) ) : ''; ?>"/>
                                    </td>
                                </tr>
								<?php
							}
							?>
                            <tfoot>
                            <tr>
                                <th class="col_add_new" colspan="4">
                                    <div class="vi-ui message tiny">
                                        <ul class="list">
                                            <li><?php esc_html_e( 'You can drag and drop slices to rearrange them.', 'woocommerce-lucky-wheel' ); ?></li>
                                            <li><?php _e( 'To create more flexible prizes, please go to <a href="edit.php?post_type=wlwl_wheel_prize" target="_blank">Wheel Prizes</a>', 'woocommerce-lucky-wheel' ); ?></li>
                                        </ul>
                                    </div>
                                </th>
                                <th class="col_add_new col_total_probability" colspan="3">
                                    <div class="vi-ui message tiny">
                                        <ul class="list">
                                            <li><?php esc_html_e( 'To change probability, please adjust weight', 'woocommerce-lucky-wheel' ) ?></li>
                                            <li><?php esc_html_e( 'Each time a customer wins a prize, its quantity will be automatically reduced by 1', 'woocommerce-lucky-wheel' ); ?></li>
                                            <li><?php _e( 'Set quantity to <strong>-1</strong> to not limit the number of prizes', 'woocommerce-lucky-wheel' ); ?></li>
                                        </ul>
                                    </div>
                                </th>
                                <th class="col_add_new" colspan="3">
									<?php
									self::auto_color();
									?>
                                    <p>
                                        <span class="auto_color positive vi-ui button tiny"><?php esc_html_e( 'Auto Color', 'woocommerce-lucky-wheel' ) ?></span>
                                    </p>
                                    <div class="vi-ui toggle checkbox">
                                        <p>
                                            <input class="random_color" type="checkbox" id="random_color"
                                                   name="random_color"
                                                   value="on" <?php checked( $this->settings->get_params( 'wheel', 'random_color' ), 'on' ) ?>>
                                            <label><?php esc_html_e( 'Color is set randomly from predefined sets for each visitor', 'woocommerce-lucky-wheel' ) ?></label>
                                        </p>
                                    </div>
                                </th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <!--Inform Result-->
                <div class="vi-ui bottom attached tab segment" data-tab="result">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th>
                                <label for="result-auto_close"><?php esc_html_e( 'Automatically hide wheel after spinning', 'woocommerce-lucky-wheel' ); ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui right labeled input">
                                    <input type="number" name="result-auto_close" min="0"
                                           id="result-auto_close"
                                           value="<?php echo intval( $this->settings->get_params( 'result', 'auto_close' ) ) ?>">
                                    <label class="vi-ui label"><?php esc_html_e( 'Second(s)', 'woocommerce-lucky-wheel' ); ?></label>
                                </div>
                                <p><?php esc_html_e( 'Hide the wheel in how many seconds after one spin. Leave 0 to disable this feature', 'woocommerce-lucky-wheel' ); ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <div class="vi-ui segment">
                        <div class="vi-ui message positive">
                            <ul class="list">
                                <li><?php esc_html_e( 'This email is used if no email template is selected.', 'woocommerce-lucky-wheel' ); ?></li>
                                <li><?php _e( 'To use different emails for each prize, please use <a href="https://1.envato.market/BZZv1" target="_blank">WooCommerce Email Template Customizer</a> or <a href="http://bit.ly/woo-email-template-customizer" target="_blank">Email Template Customizer for WooCommerce</a> to create and customize your own email template.', 'woocommerce-lucky-wheel' ) ?></li>
								<?php
								if ( VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::is_email_template_customizer_active() ) {
									?>
                                    <li>
                                        <a href="edit.php?post_type=viwec_template"
                                           target="_blank"><?php esc_html_e( 'View all Email templates', 'woocommerce-lucky-wheel' ) ?></a>
										<?php esc_html_e( 'or', 'woocommerce-lucky-wheel' ) ?>
                                        <a href="post-new.php?post_type=viwec_template&sample=wlwl_coupon_email&style=basic"
                                           target="_blank"><?php esc_html_e( 'Create a new email template', 'woocommerce-lucky-wheel' ) ?></a>
                                    </li>
                                    <li>
										<?php printf( esc_html__( 'Important note: The custom email template must be assigned to each index (wheel segment). Otherwise, notification for that segment will use the default generic email instead. For more info, please see this %s.', 'woocommerce-lucky-wheel' ), '<a href="https://docs.villatheme.com/woocommerce-email-template-customizer/#configuration_child_menu_4818">documentation</a>' ); ?>
                                    </li>
									<?php
								}
								?>
                            </ul>
                        </div>
                        <table class="form-table">
							<?php
							$result_email = $this->settings->get_params( 'result', 'email' );
							?>
                            <tbody>
                            <tr>
                                <th>
                                    <label for="subject"><?php esc_html_e( 'Email subject', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input id="subject" type="text" name="subject"
                                           value="<?php echo htmlentities( $result_email['subject'] ); ?>">
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'subject_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'subject_' . esc_attr( $value ) ?>" type="text"
                                                   name="<?php echo 'subject_' . esc_attr( $value ) ?>"
                                                   value="<?php echo esc_attr( stripslashes( $this->settings->get_params( 'result', 'email', $value )['subject'] ) ); ?>">
											<?php
										}
									}
									?>
                                    <p><?php esc_html_e( 'The subject of emails sending to customers which include discount coupon code.', 'woocommerce-lucky-wheel' ) ?></p>
                                    <p>{coupon_label}
                                        - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="heading"><?php esc_html_e( 'Email heading', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input id="heading" type="text" name="heading"
                                           value="<?php echo htmlentities( $result_email['heading'] ); ?>">
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'heading_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'heading_' . esc_attr( $value ) ?>" type="text"
                                                   name="<?php echo 'heading_' . esc_attr( $value ) ?>"
                                                   value="<?php echo esc_attr( stripslashes( $this->settings->get_params( 'result', 'email', $value )['heading'] ) ); ?>">
											<?php
										}
									}
									?>
                                    <p><?php esc_html_e( 'The heading of emails sending to customers which include discount coupon code.', 'woocommerce-lucky-wheel' ) ?></p>
                                    <p>{coupon_label}
                                        - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="content"><?php esc_html_e( 'Email content', 'woocommerce-lucky-wheel' ) ?></label>
                                    <p><?php esc_html_e( 'The content of email sending to customers to inform them the coupon code they receive', 'woocommerce-lucky-wheel' ) ?></p>
                                </th>
                                <td>
									<?php
									$option = array( 'editor_height' => 200, 'media_buttons' => true );
									$this->print_default_country_flag();
									wp_editor( stripslashes( $result_email['content'] ), 'content', $option );
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'content_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
											<?php
											wp_editor( stripslashes( $this->settings->get_params( 'result', 'email', $value )['content'] ), 'content_' . $value, $option );
										}
									}
									?>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <ul>
                                        <li>{customer_name}
                                            - <?php esc_html_e( 'Customer\'s name.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{coupon_code}
                                            - <?php esc_html_e( 'Coupon code/custom value will be sent to customer.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{coupon_label}
                                            - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{date_expires}
                                            - <?php esc_html_e( 'Expiry date of the coupon.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{featured_products}
                                            - <?php esc_html_e( 'List of featured products with product image thumbnail, product title, product price and a button linked to product page which is design the same as button {shop_now}(Beware of using this shortcode if your store has too many featured products)', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{shop_now}
                                            - <?php esc_html_e( 'Button ' );
											echo '<a class="wlwl-button-shop-now" href="' . esc_url( $this->settings->get_params( 'button_shop_url' ) ) . '" target="_blank" style="text-decoration:none;display:inline-block;padding:10px 30px;margin:10px 0;font-size:' . esc_attr( $this->settings->get_params( 'button_shop_size' ) ) . 'px;color:' . esc_attr( $this->settings->get_params( 'button_shop_color' ) ) . ';background:' . esc_attr( $this->settings->get_params( 'button_shop_bg_color' ) ) . ';">' . esc_html( $this->settings->get_params( 'button_shop_title' ) ) . '</a>' ?></li>
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="footer_text"><?php esc_html_e( 'Custom footer text', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input id="footer_text" type="text" name="footer_text"
                                           value="<?php echo htmlentities( isset( $result_email['footer_text'] ) ? $result_email['footer_text'] : get_option( 'woocommerce_email_footer_text' ) ); ?>">
                                    <p><?php esc_html_e( 'Available placeholders: ', 'woocommerce-lucky-wheel' ) ?>
                                        {site_title}, {site_address}</p>
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											$result_email_l = $this->settings->get_params( 'result', 'email', $value );
											?>
                                            <p>
                                                <label for="<?php echo 'footer_text_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'footer_text_' . esc_attr( $value ) ?>" type="text"
                                                   name="<?php echo 'footer_text_' . esc_attr( $value ) ?>"
                                                   value="<?php echo esc_attr( stripslashes( isset( $result_email_l['footer_text'] ) ? $result_email_l['footer_text'] : get_option( 'woocommerce_email_footer_text' ) ) ); ?>">
											<?php
										}
									}
									?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="wlwl_suggested_products"><?php esc_html_e( 'Suggested products', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <select id="wlwl_suggested_products" name="wlwl_suggested_products[]"
                                            multiple="multiple"
                                            class="suggested-product-search"
                                            data-placeholder="<?php esc_html_e( 'Please Fill In Your Product Title', 'woocommerce-lucky-wheel' ) ?>">
										<?php
										$product_ids = $this->settings->get_params( 'suggested_products' );
										if ( is_array( $product_ids ) && count( $product_ids ) ) {
											foreach ( $product_ids as $ps ) {
												$suggest_product = get_post( $ps );
												if ( $suggest_product ) {
													echo '<option selected value="' . esc_attr( $ps ) . '">' . esc_html( $suggest_product->post_title ) . '</option>';
												}
											}
										}
										?>
                                    </select>
                                    <p><?php esc_html_e( 'These products will be added at the end of email content with product image thumbnail, product title, product price and a button linked to product page which is design the same as button {shop_now}', 'woocommerce-lucky-wheel' ) ?></p>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_shop_title"><?php esc_html_e( '"Shop now" button title', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input type="text" name="wlwl_button_shop_title" id="wlwl_button_shop_title"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'button_shop_title' ) ) ?>">
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'wlwl_button_shop_title_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'wlwl_button_shop_title_' . esc_attr( $value ) ?>"
                                                   type="text"
                                                   name="<?php echo 'wlwl_button_shop_title_' . esc_attr( $value ) ?>"
                                                   value="<?php echo esc_attr( stripslashes( $this->settings->get_params( 'button_shop_title', '', $value ) ) ); ?>">
											<?php
										}
									}
									?>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_shop_url"><?php esc_html_e( '"Shop now" button URL', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input type="text" name="wlwl_button_shop_url" id="wlwl_button_shop_url"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'button_shop_url' ) ) ?>">
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'wlwl_button_shop_url_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'wlwl_button_shop_url_' . esc_attr( $value ) ?>"
                                                   type="text"
                                                   name="<?php echo 'wlwl_button_shop_url_' . esc_attr( $value ) ?>"
                                                   value="<?php echo esc_attr( stripslashes( $this->settings->get_params( 'button_shop_url', '', $value ) ) ); ?>">
											<?php
										}
									}
									?>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_shop_color"><?php esc_html_e( '"Shop now" button text color', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input type="text" name="wlwl_button_shop_color" id="wlwl_button_shop_color"
                                           class="color-picker"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'button_shop_color' ) ); ?>"
                                           style="background-color: <?php echo wp_kses_post( $this->settings->get_params( 'button_shop_color' ) ) ?>;">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_shop_bg_color"><?php esc_html_e( '"Shop now" button background color', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input type="text" name="wlwl_button_shop_bg_color"
                                           id="wlwl_button_shop_bg_color" class="color-picker"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'button_shop_bg_color' ) ); ?>"
                                           style="background-color: <?php echo wp_kses_post( $this->settings->get_params( 'button_shop_bg_color' ) ) ?>;">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_shop_size"><?php esc_html_e( '"Shop now" button font size', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui right labeled input">
                                        <input type="number" name="wlwl_button_shop_size" id="wlwl_button_shop_size"
                                               min="1"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'button_shop_size' ) ); ?>">
                                        <label class="vi-ui label"><?php esc_html_e( 'PX', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="vi-ui segment">
                        <table class="form-table">
                            <tbody>
                            <tr>
                                <th>
                                    <label for="admin_email_enable"><?php esc_html_e( 'Admin notification', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui toggle checkbox">
                                        <input id="admin_email_enable" type="checkbox" name="admin_email_enable"
                                               value="1" <?php checked( $this->settings->get_params( 'result', 'admin_email' )['enable'], 1 ) ?>><label><?php esc_html_e( 'Send email notification to admin when a customer wins a prize', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="admin_email_address"><?php esc_html_e( 'Sender\'s custom address', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input id="admin_email_address" type="text" name="admin_email_address"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'result', 'admin_email' )['address'] ); ?>">
									<?php esc_html_e( 'The address of emails sent to customers which includes the coupon code.', 'woocommerce-lucky-wheel' ) ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="admin_email_subject"><?php esc_html_e( 'Admin Email subject', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input id="admin_email_subject" type="text" name="admin_email_subject"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'result', 'admin_email' )['subject'] ); ?>">
                                    <p>{coupon_label}
                                        - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="admin_email_heading"><?php esc_html_e( 'Admin Email heading', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input id="admin_email_heading" type="text" name="admin_email_heading"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'result', 'admin_email' )['heading'] ); ?>">
                                    <p>{coupon_label}
                                        - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="admin_email_content"><?php esc_html_e( 'Admin Email content', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php
									$option = array( 'editor_height' => 300, 'media_buttons' => true );
									wp_editor( stripslashes( $this->settings->get_params( 'result', 'admin_email' )['content'] ), 'admin_email_content', $option ); ?>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <ul>
                                        <li>{customer_name}
                                            - <?php esc_html_e( 'Customer\'s name.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{customer_mobile}
                                            - <?php esc_html_e( 'Customer\'s mobile.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{coupon_code}
                                            - <?php esc_html_e( 'Coupon code/custom value will be sent to customer.', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{coupon_label}
                                            - <?php esc_html_e( 'Coupon label/custom label that customers win', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{customer_email}
                                            - <?php esc_html_e( 'Email of customer who wins a prize', 'woocommerce-lucky-wheel' ) ?></li>
                                    </ul>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="vi-ui segment">
                        <table class="form-table">
                            <tbody>
                            <tr>
                                <th>
                                    <label for="result_win"><?php esc_html_e( 'Winning message if prize is WooCommerce coupon', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php
									$win_option       = array( 'editor_height' => 200, 'media_buttons' => true );
									$frontend_message = $this->settings->get_params( 'result', 'notification' );
									$this->print_default_country_flag();
									wp_editor( stripslashes( $frontend_message['win'] ), 'result_win', $win_option );
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'result_win_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
											<?php
											wp_editor( stripslashes( $this->settings->get_params( 'result', 'notification', $value )['win'] ), 'result_win_' . $value, $win_option );
										}
									}
									?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="result_win_custom"><?php esc_html_e( 'Winning message if prize is custom type', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php
									$win_custom = isset( $frontend_message['win_custom'] ) ? $frontend_message['win_custom'] : $frontend_message['win'];
									$this->print_default_country_flag();
									wp_editor( stripslashes( $win_custom ), 'result_win_custom', $win_option );
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'result_win_custom_' . esc_attr( $value ); ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
											<?php
											$frontend_message_lang = $this->settings->get_params( 'result', 'notification', $value );
											wp_editor( stripslashes( isset( $frontend_message_lang['win_custom'] ) ? $frontend_message_lang['win_custom'] : $win_custom ), 'result_win_custom_' . $value, $win_option );
										}
									}
									?>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <ul>
                                        <li>{coupon_label}
                                            - <?php esc_html_e( 'Label of coupon that customers win', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{checkout}
                                            - <?php esc_html_e( '"Checkout" with link to checkout page', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{customer_name}
                                            - <?php esc_html_e( 'Customers\'name if they enter', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{customer_email}
                                            - <?php esc_html_e( 'Email that customers enter to spin', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{coupon_code}
                                            - <?php esc_html_e( 'Coupon code/custom value will be sent to customer.', 'woocommerce-lucky-wheel' ) ?></li>
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="wlwl_button_apply_coupon"><?php esc_html_e( '"Apply Coupon" button', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui toggle checkbox">
                                        <input id="wlwl_button_apply_coupon" type="checkbox"
                                               name="wlwl_button_apply_coupon"
                                               value="1" <?php checked( $this->settings->get_params( 'button_apply_coupon' ), 1 ) ?>><label><?php esc_html_e( 'Enable to show the "Apply Coupon" button if the prize is WooCommerce Coupon.', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_apply_coupon_redirect"><?php esc_html_e( '"Apply Coupon" button redirect', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php $this->print_default_country_flag() ?>
                                    <input type="text" name="wlwl_button_apply_coupon_redirect"
                                           id="wlwl_button_apply_coupon_redirect"
                                           value="<?php echo htmlentities( $this->settings->get_params( 'button_apply_coupon_redirect' ) ) ?>">
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'wlwl_button_apply_coupon_redirect_' . $value; ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
                                            <input id="<?php echo 'wlwl_button_apply_coupon_redirect_' . esc_attr( $value ) ?>"
                                                   type="text"
                                                   name="<?php echo 'wlwl_button_apply_coupon_redirect_' . esc_attr( $value ) ?>"
                                                   value="<?php echo stripslashes( esc_attr( $this->settings->get_params( 'button_apply_coupon_redirect', '', $value ) ) ); ?>">
											<?php
										}
									}
									?>
                                    <p><?php esc_html_e( 'Enter the page URL the user is redirected to after clicking the button. 2 shortcodes below are to replace the URL of the Checkout and the Cart pages. Simply add them instead of the address of your website pages.' ) ?></p>
                                    <ul>
                                        <li>{checkout_page}
                                            - <?php esc_html_e( 'Url of checkout page', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li>{cart_page}
                                            - <?php esc_html_e( 'Url of cart page', 'woocommerce-lucky-wheel' ) ?></li>
                                    </ul>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_apply_coupon_color"><?php esc_html_e( '"Apply Coupon" button color', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input type="text" name="wlwl_button_apply_coupon_color"
                                           id="wlwl_button_apply_coupon_color"
                                           class="color-picker"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'button_apply_coupon_color' ) ); ?>"
                                           style="background-color: <?php echo wp_kses_post( $this->settings->get_params( 'button_apply_coupon_color' ) ) ?>;">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_apply_coupon_bg_color"><?php esc_html_e( '"Apply Coupon" button background color', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <input type="text" name="wlwl_button_apply_coupon_bg_color"
                                           id="wlwl_button_apply_coupon_bg_color" class="color-picker"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'button_apply_coupon_bg_color' ) ); ?>"
                                           style="background-color: <?php echo wp_kses_post( $this->settings->get_params( 'button_apply_coupon_bg_color' ) ) ?>;">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_apply_coupon_font_size"><?php esc_html_e( '"Apply Coupon" button font size', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui right labeled input">
                                        <input type="number" name="wlwl_button_apply_coupon_font_size"
                                               id="wlwl_button_apply_coupon_font_size"
                                               min="1"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'button_apply_coupon_font_size' ) ); ?>">
                                        <label class="vi-ui label"><?php esc_html_e( 'PX', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_button_apply_coupon_border_radius"><?php esc_html_e( '"Apply Coupon" button rounded corner', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui right labeled input">
                                        <input type="number" name="wlwl_button_apply_coupon_border_radius"
                                               id="wlwl_button_apply_coupon_border_radius"
                                               min="1"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'button_apply_coupon_border_radius' ) ); ?>">
                                        <label class="vi-ui label"><?php esc_html_e( 'PX', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for="congratulations_effect"><?php esc_html_e( 'Winning effect', 'woocommerce-lucky-wheel' ); ?></label>
                                </th>
                                <td>

                                    <select name="congratulations_effect" id="congratulations_effect"
                                            class="vi-ui fluid dropdown">
                                        <option value="none" <?php selected( $this->settings->get_params( 'wheel_wrap', 'congratulations_effect' ), 'none' ) ?>>
											<?php esc_html_e( 'None', 'woocommerce-lucky-wheel' ); ?>
                                        </option>
                                        <option value="firework" <?php selected( $this->settings->get_params( 'wheel_wrap', 'congratulations_effect' ), 'firework' ) ?>>
											<?php esc_html_e( 'Firework', 'woocommerce-lucky-wheel' ); ?>
                                        </option>
                                    </select>

                                </td>
                            </tr>

                            <tr>
                                <th>
                                    <label for="result_lost"><?php esc_html_e( 'Frontend message if lost', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
									<?php
									$lost_option = array( 'editor_height' => 50, 'media_buttons' => true );
									$this->print_default_country_flag();
									wp_editor( stripslashes( $this->settings->get_params( 'result', 'notification' )['lost'] ), 'result_lost', $lost_option );
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value ) {
											?>
                                            <p>
                                                <label for="<?php echo 'result_lost_' . $value; ?>"><?php
													if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value );
													if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
													}
													?>:</label>
                                            </p>
											<?php
											wp_editor( stripslashes( $this->settings->get_params( 'result', 'notification', $value )['lost'] ), 'result_lost_' . $value, $lost_option );
										}
									}
									?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--Unique Coupon-->
                <div class="vi-ui bottom attached tab segment" data-tab="coupon">
                    <table class="form-table">
                        <tbody>
                        <tr class="wlwl-custom-coupon">
                            <th><?php esc_html_e( 'Email restriction', 'woocommerce-lucky-wheel' ) ?></th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox"
                                           class="checkbox" <?php checked( $this->settings->get_params( 'coupon', 'email_restriction' ), 'yes' ) ?>
                                           name="wlwl_email_restriction" id="wlwl_email_restriction" value="yes">
                                    <label for="wlwl_email_restriction"><?php esc_html_e( 'Add received email to coupon\'s allowed emails list', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th><?php esc_html_e( 'Allow free shipping', 'woocommerce-lucky-wheel' ) ?></th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox"
                                           class="checkbox" <?php checked( $this->settings->get_params( 'coupon', 'allow_free_shipping' ), 'yes' ) ?>
                                           name="wlwl_free_shipping" id="wlwl_free_shipping" value="yes">
                                    <label for="wlwl_free_shipping"><?php esc_html_e( 'Check this box if the coupon grants free shipping. A ', 'woocommerce-lucky-wheel' ) ?>
                                        <a href="https://docs.woocommerce.com/document/free-shipping/"
                                           target="_blank"><?php esc_html_e( 'free shipping method', 'woocommerce-lucky-wheel' ); ?></a><?php esc_html_e( ' must be enabled in your shipping zone and be set to require "a valid free shipping coupon" (see the "Free Shipping Requires" setting).', 'woocommerce-lucky-wheel' ); ?>
                                    </label>
                                </div>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_expiry_date"><?php esc_html_e( 'Time to live', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui right labeled input">
                                    <input type="number" min="0" name="wlwl_expiry_date" id="wlwl_expiry_date"
                                           value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'expiry_date' ) ); ?>">
                                    <label class="vi-ui label"><?php esc_html_e( 'Day(s)', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                                <p><?php esc_html_e( 'Coupon will expire after x day(s) since it\'s generated and sent', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_min_spend"><?php esc_html_e( 'Minimum spend', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <input type="text" class="short wc_input_price" name="wlwl_min_spend"
                                       id="wlwl_min_spend"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'min_spend' ) ); ?>"
                                       placeholder="<?php esc_html_e( 'No minimum', 'woocommerce-lucky-wheel' ) ?>">
                                <p><?php esc_html_e( 'The minimum spend to use the coupon.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>

                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_max_spend"><?php esc_html_e( 'Maximum spend', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <input type="text" class="short wc_input_price" name="wlwl_max_spend"
                                       id="wlwl_max_spend"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'max_spend' ) ); ?>"
                                       placeholder="<?php esc_html_e( 'No maximum', 'woocommerce-lucky-wheel' ) ?>">
                                <p><?php esc_html_e( 'The maximum spend to use the coupon.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th><?php esc_html_e( 'Individual use only', 'woocommerce-lucky-wheel' ) ?></th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" <?php checked( $this->settings->get_params( 'coupon', 'individual_use' ), 'yes' ) ?>
                                           class="checkbox" name="wlwl_individual_use" id="wlwl_individual_use"
                                           value="yes"><label
                                            for="wlwl_individual_use"><?php esc_html_e( 'Check this box if the coupon cannot be used in conjunction with other coupons.', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th><?php esc_html_e( 'Exclude sale items', 'woocommerce-lucky-wheel' ) ?></th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input type="checkbox" <?php checked( $this->settings->get_params( 'coupon', 'exclude_sale_items' ), 'yes' ) ?>
                                           class="checkbox" name="wlwl_exclude_sale_items"
                                           id="wlwl_exclude_sale_items"
                                           value="yes"><label
                                            for="wlwl_exclude_sale_items"><?php esc_html_e( 'Check this box if the coupon should not apply to items on sale. Per-item coupons will only work if the item is not on sale. Per-cart coupons will only work if there are items in the cart that are not on sale.', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_product_ids"><?php esc_html_e( 'Include Products', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <select id="wlwl_product_ids" name="wlwl_product_ids[]" multiple="multiple"
                                        class="product-search"
                                        data-placeholder="<?php esc_html_e( 'Please Fill In Your Product Title', 'woocommerce-lucky-wheel' ) ?>">
									<?php
									$product_ids = $this->settings->get_params( 'coupon', 'product_ids' );
									if ( count( $product_ids ) ) {
										foreach ( $product_ids as $ps ) {
											$product = wc_get_product( $ps );
											if ( $product ) {
												?>
                                                <option selected
                                                        value="<?php echo esc_attr( $ps ) ?>"><?php echo esc_html( $product->get_title() ) ?></option>
												<?php
											}
										}
									}
									?>
                                </select>
                                <p><?php esc_html_e( 'Products that the coupon will be applied to, or that need to be in the cart in order for the "Fixed cart discount" to be applied', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_exclude_product_ids"><?php esc_html_e( 'Exclude Products', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <select id="wlwl_exclude_product_ids" name="wlwl_exclude_product_ids[]"
                                        multiple="multiple"
                                        class="product-search"
                                        data-placeholder="<?php esc_html_e( 'Please Fill In Your Product Title', 'woocommerce-lucky-wheel' ) ?>">
									<?php
									$exclude_product_ids = $this->settings->get_params( 'coupon', 'exclude_product_ids' );
									if ( count( $exclude_product_ids ) ) {
										foreach ( $exclude_product_ids as $ps ) {
											$product = wc_get_product( $ps );
											if ( $product ) {
												?>
                                                <option selected
                                                        value="<?php echo esc_attr( $ps ) ?>"><?php echo esc_html( $product->get_title() ) ?></option>
												<?php
											}
										}
									}
									?>
                                </select>
                                <p><?php esc_html_e( 'Products that the coupon will not be applied to, or that cannot be in the cart in order for the "Fixed cart discount" to be applied.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_product_categories"><?php esc_html_e( 'Include categories', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <select id="wlwl_product_categories" name="wlwl_product_categories[]"
                                        multiple="multiple"
                                        class="category-search"
                                        data-placeholder="<?php esc_html_e( 'Please enter category name', 'woocommerce-lucky-wheel' ) ?>">
									<?php
									$product_categories = $this->settings->get_params( 'coupon', 'product_categories' );
									if ( count( $product_categories ) ) {
										foreach ( $product_categories as $category_id ) {
											$category = get_term( $category_id );
											if ( $category ) {
												?>
                                                <option value="<?php echo esc_attr( $category_id ) ?>"
                                                        selected><?php echo esc_html( $category->name ); ?></option>
												<?php
											}
										}
									}
									?>
                                </select>
                                <p><?php esc_html_e( 'Product categories that the coupon will be applied to, or that need to be in the cart in order for the "Fixed cart discount" to be applied.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_exclude_product_categories"><?php esc_html_e( 'Exclude categories', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <select id="wlwl_exclude_product_categories" name="wlwl_exclude_product_categories[]"
                                        multiple="multiple"
                                        class="category-search"
                                        data-placeholder="<?php esc_html_e( 'Please enter category name', 'woocommerce-lucky-wheel' ) ?>">
									<?php
									$exclude_product_categories = $this->settings->get_params( 'coupon', 'exclude_product_categories' );
									if ( count( $exclude_product_categories ) ) {
										foreach ( $exclude_product_categories as $category_id ) {
											$category = get_term( $category_id );
											if ( $category ) {
												?>
                                                <option value="<?php echo esc_attr( $category_id ) ?>"
                                                        selected><?php echo esc_html( $category->name ); ?></option>
												<?php
											}
										}
									}
									?>
                                </select>
                                <p><?php esc_html_e( 'Product categories that the coupon will not be applied to, or that cannot be in the cart in order for the "Fixed cart discount" to be applied.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_limit_per_coupon"><?php esc_html_e( 'Usage limit per coupon', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <input type="number" class="short" name="wlwl_limit_per_coupon"
                                       id="wlwl_limit_per_coupon"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'limit_per_coupon' ) ); ?>"
                                       placeholder="Unlimited usage" step="1" min="0">
                                <p><?php esc_html_e( 'How many times this coupon can be used before it is void.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_limit_to_x_items"><?php esc_html_e( 'Limit usage to X items', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <input type="number" class="short" name="wlwl_limit_to_x_items"
                                       id="wlwl_limit_to_x_items"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'limit_to_x_items' ) ); ?>"
                                       placeholder="<?php esc_html_e( 'Apply To All Qualifying Items In Cart', 'woocommerce-lucky-wheel' ) ?>"
                                       step="1" min="0">
                                <p><?php esc_html_e( 'The maximum number of individual items this coupon can apply to when using product discount.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_limit_per_user"><?php esc_html_e( 'Usage limit per user', 'woocommerce-lucky-wheel' ) ?></label>

                            </th>
                            <td>
                                <input type="number" class="short" name="wlwl_limit_per_user"
                                       id="wlwl_limit_per_user"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'limit_per_user' ) ); ?>"
                                       placeholder="<?php esc_html_e( 'Unlimited Usage', 'woocommerce-lucky-wheel' ) ?>"
                                       step="1" min="0">
                                <p><?php esc_html_e( 'How many times this coupon can be used by an individual user.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wlwl-custom-coupon">
                            <th>
                                <label for="wlwl_coupon_code_prefix"><?php esc_html_e( 'Coupon code prefix', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <input id="wlwl_coupon_code_prefix" type="text" name="wlwl_coupon_code_prefix"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'coupon', 'coupon_code_prefix' ) ); ?>">
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Email Api-->
                <div class="vi-ui bottom attached tab segment" data-tab="email_api">
                    <table class="form-table">
                        <tbody>
                        <!--Mailchimp-->
                        <tr valign="top">
                            <th scope="row">
                                <label for="mailchimp_enable"><?php esc_html_e( 'Enable Mailchimp', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="mailchimp_enable"
                                           id="mailchimp_enable" <?php checked( $this->settings->get_params( 'mailchimp', 'enable' ), 'on' ) ?>>
                                    <label for="mailchimp_enable"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Turn on to use MailChimp system', 'woocommerce-lucky-wheel' ) ?></p>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_mailchimp_double_optin"><?php esc_html_e( 'Mailchimp double optin', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="mailchimp_double_optin"
                                           id="wlwl_mailchimp_double_optin" <?php checked( $this->settings->get_params( 'mailchimp', 'double_optin' ), 'on' ); ?>>
                                    <label for="wlwl_mailchimp_double_optin"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'If enabled, a confirm subscription email will be sent to each subscriber for them to confirm that they subscribe to your list.', 'woocommerce-lucky-wheel' ) ?></p>
								<?php
								?>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="mailchimp_api"></label><?php esc_html_e( 'API key', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="mailchimp_api" name="mailchimp_api"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'mailchimp', 'api_key' ) ); ?>">

                                <p class="description"><?php esc_html_e( ' The API key for connecting with your MailChimp account. Get your API key ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://admin.mailchimp.com/account/api"><?php esc_html_e( 'here', 'woocommerce-lucky-wheel' ) ?></a>.
                                </p>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="mailchimp_lists"><?php esc_html_e( 'Mailchimp lists', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								$this->print_default_country_flag();

								$mailchimp      = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Mailchimp();
								$mail_lists     = $mailchimp->get_lists();
								$mailchimp_list = $mail_lists->lists ?? array();
								?>
                                <select class="select-who vi-ui fluid dropdown" name="mailchimp_lists"
                                        id="mailchimp_lists">
									<?php
									if ( is_array( $mailchimp_list ) && ! empty( $mailchimp_list ) ) {
										foreach ( $mailchimp_list as $mail_list ) {
											?>
                                            <option value='<?php echo esc_attr( $mail_list->id ); ?>' <?php selected( $this->settings->get_params( 'mailchimp', 'lists' ), $mail_list->id ); ?> ><?php echo esc_html( $mail_list->name ); ?></option>
											<?php
										}
									}
									?>
                                </select>
								<?php
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'mailchimp_lists_' . $value; ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_html( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
                                        <select class="select-who vi-ui fluid dropdown"
                                                name="<?php echo 'mailchimp_lists_' . $value; ?>"
                                                id="<?php echo 'mailchimp_lists_' . $value; ?>">
											<?php
											$mail_lists = $mailchimp->get_lists();
											if ( is_array( $mail_lists ) && count( $mail_lists ) ) {
												foreach ( $mail_lists as $key_m => $mail_list ) {
													echo "<option value='$key_m' " . selected( $this->settings->get_params( 'mailchimp', 'lists', $value ), $key_m ) . ">$mail_list</option>";
												}
											}
											?>
                                        </select>
										<?php
									}
								}
								?>
                            </td>
                        </tr>

                        <!--Active Campaign-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_enable_active_campaign"><?php esc_html_e( 'Active Campaign', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_enable_active_campaign"
                                           id="wlwl_enable_active_campaign" <?php checked( $this->settings->get_params( 'active_campaign', 'enable' ), 'on' ) ?>>
                                    <label for="wlwl_enable_active_campaign"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_active_campaign_key"></label><?php esc_html_e( 'Active Campaign API Key', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_active_campaign_key" name="wlwl_active_campaign_key"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'active_campaign', 'key' ) ); ?>">

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_active_campaign_url"></label><?php esc_html_e( 'Active Campaign API URL', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_active_campaign_url" name="wlwl_active_campaign_url"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'active_campaign', 'url' ) ); ?>">

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_active_campaign_list"><?php esc_html_e( 'Active Campaign list', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <select class="wlwl-ac-search-list" name="wlwl_active_campaign_list">
									<?php
									if ( $this->settings->get_params( 'active_campaign', 'list' ) ) {
										?>
                                        <option value="<?php echo esc_attr( $this->settings->get_params( 'active_campaign', 'list' ) ); ?>"
                                                selected>
											<?php
											$active_campaign = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Active_Campaign();
											$result          = $active_campaign->list_view( $this->settings->get_params( 'active_campaign', 'list' ) );
											if ( isset( $result['name'] ) && $result['name'] ) {
												echo esc_html( $result['name'] );
											}
											?>
                                        </option>
										<?php
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <!--SendGrid-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_sendgrid_enable"><?php esc_html_e( 'SendGrid', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_sendgrid_enable"
                                           id="wlwl_sendgrid_enable" <?php checked( $this->settings->get_params( 'sendgrid', 'enable' ), 'on' ) ?>>
                                    <label for="wlwl_sendgrid_enable"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_sendgrid_key"></label><?php esc_html_e( 'SendGrid API Key', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_sendgrid_key" name="wlwl_sendgrid_key"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'sendgrid', 'key' ) ); ?>">
                                <p><?php esc_html_e( '*This is the API key that\'s shown only once when your created it, not the API key ID.', 'woocommerce-lucky-wheel' ) ?></p>
                                <p><?php esc_html_e( '**This API Key must have full-access permission of API Keys. You can set it ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://app.sendgrid.com/settings/api_keys"
                                       target="_blank"><?php esc_html_e( 'here.', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="sendgrid_lists"><?php esc_html_e( 'Sendgrid lists', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								$sendgrid          = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendgrid();
								$mail_lists        = $sendgrid->get_lists();//return false or object
								$get_sendgrid_list = $mail_lists->result ?? array();
								?>
                                <select class="select-who vi-ui fluid dropdown" name="sendgrid_lists"
                                        id="sendgrid_lists">
                                    <option value="none"><?php esc_html_e( 'Do not add to any list', 'woocommerce-lucky-wheel' ) ?></option>
									<?php

									$sendgrid_list = $this->settings->get_params( 'sendgrid', 'list' );
									if ( $mail_lists && count( $get_sendgrid_list ) ) {
										foreach ( $get_sendgrid_list as $key_m => $mail_list ) {
											?>
                                            <option value="<?php echo esc_attr( $mail_list->id ) ?>" <?php selected( $sendgrid_list, $mail_list->id ) ?>><?php echo esc_html( $mail_list->name ) ?></option>
											<?php
										}
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <!--Metrilo-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_metrilo_enable"><?php esc_html_e( 'Metrilo', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_metrilo_enable" value="1"
                                           id="wlwl_metrilo_enable" <?php checked( $this->settings->get_params( 'metrilo_enable' ), 1 ) ?>>
                                    <label for="wlwl_metrilo_enable"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_metrilo_token"></label><?php esc_html_e( 'Metrilo Token', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_metrilo_token" name="wlwl_metrilo_token"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'metrilo_token' ) ); ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_metrilo_tag"></label><?php esc_html_e( 'Metrilo tag', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_metrilo_tag" name="wlwl_metrilo_tag"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'metrilo_tag' ) ); ?>">
								<?php
								if ( $this->languages_count ) {
									foreach ( $this->languages as $key => $value ) {
										?>
                                        <p>
                                            <label for="<?php echo 'wlwl_metrilo_tag_' . $value; ?>"><?php
												if ( isset( $this->languages_data[ $value ]['country_flag_url'] ) && $this->languages_data[ $value ]['country_flag_url'] ) {
													?>
                                                    <img src="<?php echo esc_url( $this->languages_data[ $value ]['country_flag_url'] ); ?>">
													<?php
												}
												echo esc_html( $value );
												if ( isset( $this->languages_data[ $value ]['translated_name'] ) ) {
													echo '(' . esc_html( $this->languages_data[ $value ]['translated_name'] ) . ')';
												}
												?>:</label>
                                        </p>
                                        <input type="text"
                                               name="<?php echo 'wlwl_metrilo_tag_' . esc_attr( $value ); ?>"
                                               id="<?php echo 'wlwl_metrilo_tag_' . esc_attr( $value ); ?>"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'metrilo_tag', '', $value ) ) ?>">
										<?php
									}
								}
								?>
                                <p><?php esc_html_e( 'Please enter tags separated by comma(,)', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_metrilo_subscribed"><?php esc_html_e( 'Subscribed', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_metrilo_subscribed" value="1"
                                           id="wlwl_metrilo_subscribed" <?php checked( $this->settings->get_params( 'metrilo_subscribed' ), 1 ) ?>>
                                    <label for="wlwl_metrilo_subscribed"><?php esc_html_e( 'Yes', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                                <p><?php esc_html_e( 'If the user has opted in for receiving emails.', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>

                        <!--Hubspot-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_enable_hubspot"><?php esc_html_e( 'Hubspot', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_enable_hubspot"
                                           id="wlwl_enable_hubspot" <?php checked( $this->settings->get_params( 'wlwl_enable_hubspot' ), 1 ); ?>
                                           value="1">
                                    <label for="wlwl_enable_hubspot"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top" class="vi_wbs_enable_hubspot">
                            <th scope="row">
                                <label for="wlwl_hubspot_api"></label><?php esc_html_e( 'Hubspot API Key', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <input type="text" id="wlwl_hubspot_api" name="wlwl_hubspot_api"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_hubspot_api' ) ); ?>">
                                <p><?php esc_html_e( '**The API key for connecting with your Hubspot account. Get your API key ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://knowledge.hubspot.com/integrations/how-do-i-get-my-hubspot-api-key"
                                       target="_blank"><?php esc_html_e( 'here.', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                            </td>

                        </tr>
                        <!--Klaviyo-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_enable_klaviyo">
									<?php esc_html_e( 'Klaviyo', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_enable_klaviyo"
                                           id="wlwl_enable_klaviyo" <?php checked( $this->settings->get_params( 'wlwl_enable_klaviyo' ), 1 ); ?>
                                           value="1">
                                    <label for="wlwl_enable_klaviyo"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_klaviyo_api">
									<?php esc_html_e( 'Klaviyo API Key', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" id="wlwl_klaviyo_api" name="wlwl_klaviyo_api"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_klaviyo_api' ) ); ?>">
                                <p><?php esc_html_e( '**The API key for connecting with your Klaviyo account. Get your API key ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://developers.klaviyo.com/en/docs/retrieve-api-credentials"
                                       target="_blank"><?php esc_html_e( 'here.', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_klaviyo_list"><?php esc_html_e( 'Klaviyo list', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								$klaviyo      = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Klaviyo();
								$mail_lists   = $klaviyo->get_lists();
								$klaviyo_list = $this->settings->get_params( 'wlwl_klaviyo_list' );
								?>
                                <select class="vi-ui fluid dropdown" name="wlwl_klaviyo_list">
									<?php

									if ( is_array( $mail_lists ) && ! empty( $mail_lists ) ) {
										foreach ( $mail_lists as $key_m => $mail_list ) {
											printf( '<option value="%s" %s>%s</option>',
												esc_attr( $mail_list->list_id ), selected( $klaviyo_list, $mail_list->list_id ), esc_html( $mail_list->list_name ) );
										}
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <!--Sendinblue-->
                        <tr>
                            <td></td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_enable_sendinblue">
									<?php esc_html_e( 'Sendinblue', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_enable_sendinblue"
                                           id="wlwl_enable_sendinblue" <?php checked( $this->settings->get_params( 'wlwl_enable_sendinblue' ), 1 ); ?>
                                           value="1">
                                    <label for="wlwl_enable_sendinblue"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_sendinblue_api">
									<?php esc_html_e( 'Sendinblue API Key', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" id="wlwl_sendinblue_api" name="wlwl_sendinblue_api"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_sendinblue_api' ) ); ?>">
                                <p><?php esc_html_e( '**The API key for connecting with your Sendinblue account. Get your API key ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://developers.sendinblue.com/docs/migration-guide-for-api-v2-users-1"
                                       target="_blank"><?php esc_html_e( 'here.', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_sendinblue_list"><?php esc_html_e( 'Sendinblue list', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
								<?php
								$sendinblue      = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendinblue();
								$mail_lists      = $sendinblue->get_lists();
								$sendinblue_list = $this->settings->get_params( 'wlwl_sendinblue_list' );
								?>
                                <select class="vi-ui fluid dropdown" name="wlwl_sendinblue_list[]" multiple>
									<?php

									if ( is_array( $mail_lists ) && ! empty( $mail_lists ) ) {
										foreach ( $mail_lists as $key_m => $mail_list ) {
											$selected = in_array( $mail_list->id, $sendinblue_list ) ? 'selected' : '';
											printf( '<option value="%s" %s>%s</option>',
												esc_attr( $mail_list->id ), esc_attr( $selected ), esc_html( $mail_list->name ) );
										}
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <!--Mail poet-->
						<?php
						if ( class_exists( \MailPoet\API\API::class ) ) {
							$mailpoet_api   = \MailPoet\API\API::MP( 'v1' );
							$mailpoet_lists = $mailpoet_api->getLists();

							$mailpoet_selected_list = $this->settings->get_params( 'wlwl_mailpoet_list' );
							?>
                            <tr>
                                <td></td>
                            </tr>

                            <!--MailPoet-->
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_enable_mailpoet"><?php esc_html_e( 'MailPoet', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui toggle checkbox checked">
                                        <input type="checkbox" name="wlwl_enable_mailpoet"
                                               id="wlwl_enable_mailpoet" <?php checked( $this->settings->get_params( 'wlwl_enable_mailpoet' ), 1 ); ?>
                                               value="1">
                                        <label for="wlwl_enable_mailpoet"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr valign="top" class="wlwl_mailpoet_list">
                                <th scope="row">
                                    <label for="wlwl_mailpoet_list">
										<?php esc_html_e( 'MailPoet list', 'woocommerce-lucky-wheel' ) ?>
                                    </label>
                                </th>
                                <td>
                                    <select class="vi-ui fluid dropdown" name="wlwl_mailpoet_list[]"
                                            id="wlwl_mailpoet_list" multiple>
										<?php
										foreach ( $mailpoet_lists as $list ) {
											$selected = in_array( $list['id'], (array) $mailpoet_selected_list ) ? 'selected' : '';
											printf( '<option value="%s" %s>%s</option>',
												esc_attr( $list['id'] ), esc_attr( $selected ), esc_html( $list['name'] ) );
										}
										?>
                                    </select>
                                </td>
                            </tr>
							<?php
						}
						?>
                        <!--Mailster-->
						<?php
						if ( function_exists( 'mailster' ) ) {
							$mailster_lists = mailster( 'lists' )->get();

							$mailster_selected_list = $this->settings->get_params( 'wlwl_mailster_list' ) ?? [];
							?>
                            <tr>
                                <td></td>
                            </tr>

                            <!--Mailster-->
                            <tr valign="top">
                                <th scope="row">
                                    <label for="wlwl_enable_mailster"><?php esc_html_e( 'Mailster', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>
                                    <div class="vi-ui toggle checkbox checked">
                                        <input type="checkbox" name="wlwl_enable_mailster"
                                               id="wlwl_enable_mailster" <?php checked( $this->settings->get_params( 'wlwl_enable_mailster' ), 1 ); ?>
                                               value="1">
                                        <label for="wlwl_enable_mailster"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                    </div>
                                </td>
                            </tr>
                            <tr valign="top" class="wlwl_mailster_list">
                                <th scope="row">
                                    <label for="wlwl_mailster_list">
										<?php esc_html_e( 'Mailster list', 'woocommerce-lucky-wheel' ) ?>
                                    </label>
                                </th>
                                <td>
                                    <select class="vi-ui fluid dropdown" name="wlwl_mailster_list[]"
                                            id="wlwl_mailster_list" multiple>
										<?php
										foreach ( $mailster_lists as $list ) {
											$selected = in_array( $list->ID, (array) $mailster_selected_list ) ? 'selected' : '';
											printf( '<option value="%s" %s>%s</option>',
												esc_attr( $list->ID ), esc_attr( $selected ), esc_html( $list->name ) );
										}
										?>
                                    </select>
                                </td>
                            </tr>
							<?php
						}
						?>
                        <!--Sendy api-->
                        <tr>
                            <td></td>
                        </tr>
						<?php
						$sendy       = new VI_WOOCOMMERCE_LUCKY_WHEEL_Admin_Sendy();
						$mail_brands = (array) $sendy->get_brands();
						$mail_lists  = (array) $sendy->get_lists();
						$sendy_brand = $this->settings->get_params( 'wlwl_sendy_brand' );
						$sendy_list  = $this->settings->get_params( 'wlwl_sendy_list' );

						?>
                        <tr valign="top">
                            <th scope="row">
                                <label for="wlwl_enable_sendy">
									<?php esc_html_e( 'Sendy', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox" name="wlwl_enable_sendy"
                                           id="wlwl_enable_sendy" <?php checked( $this->settings->get_params( 'wlwl_enable_sendy' ), 1 ); ?>
                                           value="1">
                                    <label for="wlwl_enable_sendy"><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_sendy_api">
									<?php esc_html_e( 'Sendy API Key', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" id="wlwl_sendy_api" name="wlwl_sendy_api"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_sendy_api' ) ); ?>">
                                <p><?php esc_html_e( '**The API key for connecting with your Sendy account. Get your API key ', 'woocommerce-lucky-wheel' ) ?>
                                    <a href="https://sendy.co/api"
                                       target="_blank"><?php esc_html_e( 'here.', 'woocommerce-lucky-wheel' ) ?></a>
                                </p>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_sendy_login_url">
									<?php esc_html_e( 'Sendy login url', 'woocommerce-lucky-wheel' ) ?>
                                </label>
                            </th>
                            <td>
                                <input type="text" id="wlwl_sendy_login_url" name="wlwl_sendy_login_url"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_sendy_login_url' ) ); ?>">
                                <p><?php esc_html_e( '**Your domain Sendy url, including http:// or https:// in the url. Example: https://sendy.co/demo', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr valign="top" class="">
                            <th scope="row">
                                <label for="wlwl_sendy_brand"><?php esc_html_e( 'Sendy Brand', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <select class="vi-ui fluid dropdown" name="wlwl_sendy_brand">
									<?php

									if ( is_array( $mail_brands ) && ! empty( $mail_brands ) ) {
										foreach ( $mail_brands as $key_m => $mail_brand ) {
											$selected = ( $mail_brand->id === $sendy_brand ) ? 'selected' : '';
											printf( '<option value="%s" %s>%s</option>',
												esc_attr( $mail_brand->id ), esc_attr( $selected ), esc_html( $mail_brand->name ) );
										}
									}
									?>
                                </select>
                            </td>
                        </tr>
						<?php if ( ! empty( $sendy_brand ) ) {

							?>
                            <tr valign="top" class="">
                                <th scope="row">
                                    <label for="wlwl_sendy_list"><?php esc_html_e( 'Sendy list', 'woocommerce-lucky-wheel' ) ?></label>
                                </th>
                                <td>

									<?php
									$this->print_default_country_flag();
									?>
                                    <select class="vi-ui fluid dropdown" name="wlwl_sendy_list">
										<?php
										if ( is_array( $mail_lists ) && ! empty( $mail_lists ) ) {
											foreach ( $mail_lists as $key_m => $mail_list ) {
												$selected = ( $mail_list->id === $sendy_list ) ? 'selected' : '';
												printf( '<option value="%s" %s>%s</option>',
													esc_attr( $mail_list->id ), esc_attr( $selected ), esc_html( $mail_list->name ) );
											}
										}
										?>
                                    </select>
									<?php
									if ( $this->languages_count ) {
										foreach ( $this->languages as $key => $value_lang ) {
											$sendy_list_per_language = $this->settings->get_params( 'wlwl_sendy_list', '', $value_lang );
											?>
                                            <p>
                                                <label for="<?php echo esc_attr( 'wlwl_sendy_list_' . $value_lang ); ?>">
													<?php
													if ( isset( $this->languages_data[ $value_lang ]['country_flag_url'] ) && $this->languages_data[ $value_lang ]['country_flag_url'] ) {
														?>
                                                        <img src="<?php echo esc_url( $this->languages_data[ $value_lang ]['country_flag_url'] ); ?>">
														<?php
													}
													echo esc_html( $value_lang );
													if ( isset( $this->languages_data[ $value_lang ]['translated_name'] ) ) {
														echo '(' . esc_html( $this->languages_data[ $value_lang ]['translated_name'] ) . ')';
													}
													?>
                                                </label>
                                            </p>
                                            <select class="vi-ui fluid dropdown" name="<?php echo esc_attr( 'wlwl_sendy_list_' . $value_lang ); ?>">
												<?php
												if ( is_array( $mail_lists ) && ! empty( $mail_lists ) ) {
													foreach ( $mail_lists as $key_m => $mail_list ) {
														$selected = ( $mail_list->id === $sendy_list_per_language ) ? 'selected' : '';
														printf( '<option value="%s" %s>%s</option>',
															esc_attr( $mail_list->id ), esc_attr( $selected ), esc_html( $mail_list->name ) );
													}
												}
												?>
                                            </select>
											<?php
										}
									}
									?>
                                </td>
                            </tr>
							<?php

						}
						?>
                        </tbody>
                    </table>
                </div>
                <!--ReCaptcha Api-->
                <div class="vi-ui bottom attached tab segment" data-tab="grecaptcha">
                    <table class="form-table">
                        <tbody>
                        <tr align="top">
                            <th>
                                <label for=""><?php esc_html_e( 'Enable', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox checked">
                                    <input type="checkbox"
                                           name="wlwl_recaptcha"
                                           class="checkbox"
                                           id="wlwl_recaptcha"
                                           tabindex="0" <?php checked( $this->settings->get_params( 'wlwl_recaptcha' ), 'on' ) ?>>
                                    <label for="wlwl_recaptcha"></label>
                                </div>

                                <p class="description"><?php esc_html_e( 'Turn on to use Google ReCaptcha', 'woocommerce-lucky-wheel' ) ?></p>
                            </td>
                        </tr>
                        <tr align="top">
                            <th>
                                <label for="wlwl_recaptcha_version"><?php esc_html_e( 'Version', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <select name="wlwl_recaptcha_version" id="wlwl_recaptcha_version"
                                        class="vi-ui fluid dropdown wlwl_recaptcha_version">
                                    <option value="2" <?php selected( $this->settings->get_params( 'wlwl_recaptcha_version' ), '2' ) ?>><?php esc_html_e( 'reCAPTCHA v2', 'woocommerce-lucky-wheel' ) ?></option>
                                    <option value="3" <?php selected( $this->settings->get_params( 'wlwl_recaptcha_version' ), '3' ) ?>><?php esc_html_e( 'reCAPTCHA v3', 'woocommerce-lucky-wheel' ) ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr align="top">
                            <th>
                                <label for="wlwl_recaptcha_site_key"><?php esc_html_e( 'Site key', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <input type="text" name="wlwl_recaptcha_site_key"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_recaptcha_site_key' ) ); ?>">
                            </td>
                        </tr>
                        <tr align="top">
                            <th>
                                <label for="wlwl_recaptcha_secret_key"><?php esc_html_e( 'Secret key', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <input type="text" name="wlwl_recaptcha_secret_key"
                                       value="<?php echo esc_attr( $this->settings->get_params( 'wlwl_recaptcha_secret_key' ) ); ?>">
                            </td>
                        </tr>
                        <tr align="top" class="wlwl-recaptcha-v2-wrap"
                            style="<?php echo $this->settings->get_params( 'wlwl_recaptcha_version' ) == 2 ? '' : 'display:none;'; ?>">
                            <th>
                                <label for="wlwl_recaptcha_secret_theme"><?php esc_html_e( 'Theme', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <select name="wlwl_recaptcha_secret_theme" id="wlwl_recaptcha_secret_theme"
                                        class="vi-ui fluid dropdown wlwl_recaptcha_secret_theme">
                                    <option value="dark" <?php selected( $this->settings->get_params( 'wlwl_recaptcha_secret_theme' ), 'dark' ) ?>><?php esc_html_e( 'Dark', 'woocommerce-lucky-wheel' ) ?></option>
                                    <option value="light" <?php selected( $this->settings->get_params( 'wlwl_recaptcha_secret_theme' ), 'light' ) ?>><?php esc_html_e( 'Light', 'woocommerce-lucky-wheel' ) ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th>
                                <label for=""><?php esc_html_e( 'Guide', 'woocommerce-lucky-wheel' ) ?></label>
                            </th>
                            <td>
                                <div>
                                    <strong class="w-recaptcha-v2-wrap"
                                            style="<?php echo $this->settings->get_params( 'wlwl_recaptcha_version' ) == 2 ? '' : 'display:none;'; ?>">
										<?php esc_html_e( 'Get Google reCAPTCHA V2 Site and Secret key', 'woocommerce-lucky-wheel' ) ?>
                                    </strong>
                                    <strong class="wlwl-recaptcha-v3-wrap"
                                            style="<?php echo $this->settings->get_params( 'wlwl_recaptcha_version' ) == 3 ? '' : 'display:none;'; ?>">
										<?php esc_html_e( 'Get Google reCAPTCHA V3 Site and Secret key', 'woocommerce-lucky-wheel' ) ?>
                                    </strong>
                                    <ul>
                                        <li><?php _e( '1, Visit <a target="_blank" href="http://www.google.com/recaptcha/admin">page</a> to sign up for an API key pair with your Gmail account', 'woocommerce-lucky-wheel' ) ?></li>

                                        <li class="wlwl-recaptcha-v2-wrap"
                                            style="<?php echo $this->settings->get_params( 'wlwl_recaptcha_version' ) == 2 ? '' : 'display:none;'; ?>">
											<?php esc_html_e( '2, Choose reCAPTCHA v2 checkbox ', 'woocommerce-lucky-wheel' ) ?>
                                        </li>
                                        <li class="wlwl-recaptcha-v3-wrap"
                                            style="<?php echo $this->settings->get_params( 'wlwl_recaptcha_version' ) == 3 ? '' : 'display:none;'; ?>">
											<?php esc_html_e( '2, Choose reCAPTCHA v3', 'woocommerce-lucky-wheel' ) ?>
                                        </li>
                                        <li><?php esc_html_e( '3, Fill in authorized domains', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li><?php esc_html_e( '4, Accept terms of service and click Register button', 'woocommerce-lucky-wheel' ) ?></li>
                                        <li><?php esc_html_e( '5, Copy and paste the site and secret key into the above field', 'woocommerce-lucky-wheel' ) ?></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Update-->
                <div class="vi-ui bottom attached tab segment" data-tab="update">
                    <table class="form-table">
                        <tbody>
                        <tr valign="top">
                            <th scope="row">
                                <label for="auto-update-key"></label><?php esc_html_e( 'Auto update key', 'woocommerce-lucky-wheel' ) ?>
                            </th>
                            <td>
                                <div class="fields">
                                    <div class="ten wide field">
                                        <input type="text" name="wlwl_update_key" id="auto-update-key"
                                               class="villatheme-autoupdate-key-field"
                                               value="<?php echo esc_attr( $this->settings->get_params( 'key' ) ); ?>">
                                    </div>
                                    <div class="six wide field">
                                        <span class="vi-ui button green villatheme-get-key-button"
                                              data-href="https://api.envato.com/authorization?response_type=code&client_id=villatheme-download-keys-6wzzaeue&redirect_uri=https://villatheme.com/update-key"
                                              data-id="21604585"><?php echo esc_html__( 'Get Key', 'woocommerce-lucky-wheel' ) ?></span>
                                    </div>
                                </div>
								<?php do_action( 'woocommerce-lucky-wheel_key' ) ?>
                                <p class="description"><?php _e( 'Please fill your key what you get from <a target="_blank" href="https://villatheme.com/my-download">https://villatheme.com/my-download</a>. See <a target="_blank" href="https://villatheme.com/knowledge-base/how-to-use-auto-update-feature/">guide</a>.', 'woocommerce-lucky-wheel' ) ?>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <p class="wlwl-button-save-settings-container">
                    <button class="vi-ui primary button labeled icon wlw-submit" name="wlwl_save_settings"><i
                                class="icon save"></i><?php esc_html_e( 'Save', 'woocommerce-lucky-wheel' ); ?></button>
                    <button type="submit" class="vi-ui button labeled icon"
                            name="wlwl_check_key"><i
                                class="icon save"></i><?php esc_html_e( 'Save & Check Key', 'woocommerce-lucky-wheel' ); ?>
                    </button>
                </p>
            </form>
        </div>
        <div class="woocommerce-lucky-wheel-preview preview-html-hidden">
            <div class="woocommerce-lucky-wheel-preview-overlay"></div>
            <div class="woocommerce-lucky-wheel-preview-html">
                <canvas id="wlwl_canvas"></canvas>
                <canvas id="wlwl_canvas1"></canvas>
                <canvas id="wlwl_canvas2"></canvas>
            </div>
        </div>
		<?php
		do_action( 'villatheme_support_woocommerce-lucky-wheel' );
	}

	public function check_update() {
		/**
		 * Check update
		 */
		$key = $this->settings->get_params( 'key' );
		/*Check update*/
		if ( class_exists( 'VillaTheme_Plugin_Check_Update' ) ) {
			$setting_url = admin_url( 'admin.php?page=woocommerce-lucky-wheel' );
			new VillaTheme_Plugin_Check_Update (
				VI_WOOCOMMERCE_LUCKY_WHEEL_VERSION,                    // current version
				'https://villatheme.com/wp-json/downloads/v3',  // update path
				'woocommerce-lucky-wheel/woocommerce-lucky-wheel.php',                  // plugin file slug
				'woocommerce-lucky-wheel', '12884', $key, $setting_url
			);
			new VillaTheme_Plugin_Updater( 'woocommerce-lucky-wheel/woocommerce-lucky-wheel.php', 'woocommerce-lucky-wheel', $setting_url );

		}
	}

	public function save_settings() {
		global $pagenow;

		if ( $pagenow != 'admin.php' || ! isset( $_REQUEST['page'] ) || $_REQUEST['page'] != 'woocommerce-lucky-wheel' ) {
			return;
		}
		global $woo_lucky_wheel_settings;

		/*wpml*/
		if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
			global $sitepress;
			$default_lang           = $sitepress->get_default_language();
			$this->default_language = $default_lang;
			$languages              = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );
			$this->languages_data   = $languages;
			if ( count( $languages ) ) {
				foreach ( $languages as $key => $language ) {
					if ( $key != $default_lang ) {
						$this->languages[] = $key;
					}
				}
			}
		} elseif ( class_exists( 'Polylang' ) ) {
			/*Polylang*/
			$languages    = pll_languages_list();
			$default_lang = pll_default_language( 'slug' );
			foreach ( $languages as $language ) {
				if ( $language == $default_lang ) {
					continue;
				}
				$this->languages[] = $language;
			}
		}
		$this->languages_count = count( $this->languages );
		if ( empty( $_POST['wlwl_nonce_field'] ) || ! wp_verify_nonce( $_POST['wlwl_nonce_field'], 'wlwl_settings_page_save' ) ) {
			return;
		}
		$args = array(
			'general'    => array(
				'enable'     => isset( $_POST['wlwl_enable'] ) ? sanitize_text_field( $_POST['wlwl_enable'] ) : 'off',
				'mobile'     => isset( $_POST['wlwl_enable_mobile'] ) ? sanitize_text_field( $_POST['wlwl_enable_mobile'] ) : 'off',
				'spin_num'   => isset( $_POST['wlwl_spin_num'] ) ? sanitize_text_field( $_POST['wlwl_spin_num'] ) : 0,
				'delay'      => isset( $_POST['wlwl_delay'] ) ? sanitize_text_field( $_POST['wlwl_delay'] ) : 0,
				'delay_unit' => isset( $_POST['wlwl_delay_unit'] ) ? sanitize_text_field( $_POST['wlwl_delay_unit'] ) : 's',
			),
			'notify'     => array(
				'position'                 => isset( $_POST['notify_position'] ) ? sanitize_text_field( $_POST['notify_position'] ) : '',
				'size'                     => isset( $_POST['notify_size'] ) ? sanitize_text_field( $_POST['notify_size'] ) : 0,
				'color'                    => isset( $_POST['notify_color'] ) ? sanitize_text_field( $_POST['notify_color'] ) : '',
				'popup_icon'               => isset( $_POST['wheel_popup_icon'] ) ? sanitize_text_field( $_POST['wheel_popup_icon'] ) : '',
				'popup_icon_color'         => isset( $_POST['wheel_popup_icon_color'] ) ? sanitize_text_field( $_POST['wheel_popup_icon_color'] ) : '',
				'popup_icon_bg_color'      => isset( $_POST['wheel_popup_icon_bg_color'] ) ? sanitize_text_field( $_POST['wheel_popup_icon_bg_color'] ) : '',
				'popup_icon_border_radius' => isset( $_POST['wheel_popup_icon_border_radius'] ) ? sanitize_text_field( $_POST['wheel_popup_icon_border_radius'] ) : '',
				'intent'                   => isset( $_POST['notify_intent'] ) ? sanitize_text_field( $_POST['notify_intent'] ) : '',
				'show_again'               => isset( $_POST['notify_show_again'] ) ? sanitize_text_field( $_POST['notify_show_again'] ) : 0,
				'hide_popup'               => isset( $_POST['notify_hide_popup'] ) ? sanitize_text_field( $_POST['notify_hide_popup'] ) : 'off',
				'show_wheel'               => isset( $_POST['show_wheel'] ) ? sanitize_text_field( $_POST['show_wheel'] ) : '',
				'scroll_amount'            => isset( $_POST['scroll_amount'] ) ? sanitize_text_field( $_POST['scroll_amount'] ) : '',
				'show_again_unit'          => isset( $_POST['notify_show_again_unit'] ) ? sanitize_text_field( $_POST['notify_show_again_unit'] ) : 0,
				'show_only_front'          => isset( $_POST['notify_frontpage_only'] ) ? sanitize_text_field( $_POST['notify_frontpage_only'] ) : 'off',
				'show_only_blog'           => isset( $_POST['notify_blogpage_only'] ) ? sanitize_text_field( $_POST['notify_blogpage_only'] ) : 'off',
				'show_only_shop'           => isset( $_POST['notify_shop_only'] ) ? sanitize_text_field( $_POST['notify_shop_only'] ) : 'off',
				'conditional_tags'         => isset( $_POST['notify_conditional_tags'] ) ? stripslashes( sanitize_text_field( $_POST['notify_conditional_tags'] ) ) : '',
				'time_on_close'            => isset( $_POST['notify_time_on_close'] ) ? stripslashes( sanitize_text_field( $_POST['notify_time_on_close'] ) ) : '',
				'time_on_close_unit'       => isset( $_POST['notify_time_on_close_unit'] ) ? stripslashes( sanitize_text_field( $_POST['notify_time_on_close_unit'] ) ) : '',
			),
			'wheel_wrap' => array(
				'description'            => isset( $_POST['wheel_wrap_description'] ) ? wp_kses_post( stripslashes( $_POST['wheel_wrap_description'] ) ) : '',
				'bg_image'               => isset( $_POST['wheel_wrap_bg_image'] ) ? sanitize_text_field( $_POST['wheel_wrap_bg_image'] ) : '',
				'bg_color'               => isset( $_POST['wheel_wrap_bg_color'] ) ? sanitize_text_field( $_POST['wheel_wrap_bg_color'] ) : '',
				'text_color'             => isset( $_POST['wheel_wrap_text_color'] ) ? sanitize_text_field( $_POST['wheel_wrap_text_color'] ) : '',
				'spin_button'            => isset( $_POST['wheel_wrap_spin_button'] ) ? sanitize_text_field( stripslashes( $_POST['wheel_wrap_spin_button'] ) ) : 'Try Your Lucky',
				'spin_button_color'      => isset( $_POST['wheel_wrap_spin_button_color'] ) ? sanitize_text_field( $_POST['wheel_wrap_spin_button_color'] ) : '',
				'spin_button_bg_color'   => isset( $_POST['wheel_wrap_spin_button_bg_color'] ) ? sanitize_text_field( $_POST['wheel_wrap_spin_button_bg_color'] ) : '',
				'pointer_position'       => isset( $_POST['pointer_position'] ) ? sanitize_text_field( $_POST['pointer_position'] ) : 'center',
				'pointer_color'          => isset( $_POST['pointer_color'] ) ? sanitize_text_field( $_POST['pointer_color'] ) : '',
				'wheel_center_image'     => isset( $_POST['wheel_center_image'] ) ? sanitize_text_field( $_POST['wheel_center_image'] ) : '',
				'wheel_center_color'     => isset( $_POST['wheel_center_color'] ) ? sanitize_text_field( $_POST['wheel_center_color'] ) : '',
				'wheel_border_color'     => isset( $_POST['wheel_border_color'] ) ? sanitize_text_field( $_POST['wheel_border_color'] ) : '',
				'wheel_dot_color'        => isset( $_POST['wheel_dot_color'] ) ? sanitize_text_field( $_POST['wheel_dot_color'] ) : '',
				'close_option'           => isset( $_POST['wheel_wrap_close_option'] ) ? sanitize_text_field( $_POST['wheel_wrap_close_option'] ) : '',
				'font'                   => isset( $_POST['wlwl_google_font_select'] ) ? sanitize_text_field( $_POST['wlwl_google_font_select'] ) : '',
				'gdpr'                   => isset( $_POST['gdpr_policy'] ) ? sanitize_textarea_field( $_POST['gdpr_policy'] ) : "off",
				'gdpr_message'           => isset( $_POST['gdpr_message'] ) ? wp_kses_post( stripslashes( $_POST['gdpr_message'] ) ) : "",
				'congratulations_effect' => isset( $_POST['congratulations_effect'] ) ? sanitize_text_field( $_POST['congratulations_effect'] ) : "",
				'background_effect'      => isset( $_POST['background_effect'] ) ? sanitize_text_field( $_POST['background_effect'] ) : "",
				'custom_css'             => isset( $_POST['custom_css'] ) ? wp_kses_post( stripslashes( $_POST['custom_css'] ) ) : "",
			),
			'wheel'      => array(
				'spinning_time'     => isset( $_POST['wheel_spinning_time'] ) ? sanitize_text_field( $_POST['wheel_spinning_time'] ) : 3,
				'wheel_speed'       => isset( $_POST['wheel_speed'] ) ? sanitize_text_field( $_POST['wheel_speed'] ) : 1,
				'coupon_type'       => isset( $_POST['coupon_type'] ) ? stripslashes_deep( array_map( 'sanitize_text_field', $_POST['coupon_type'] ) ) : array(),
				'coupon_amount'     => isset( $_POST['coupon_amount'] ) ? array_map( 'sanitize_text_field', $_POST['coupon_amount'] ) : array(),
				'email_templates'   => isset( $_POST['email_templates'] ) ? array_map( 'sanitize_text_field', $_POST['email_templates'] ) : array(),
				'custom_value'      => isset( $_POST['custom_type_value'] ) ? array_map( 'wlwl_sanitize_text_field', $_POST['custom_type_value'] ) : array(),
				'custom_label'      => isset( $_POST['custom_type_label'] ) ? array_map( 'wlwl_sanitize_text_field', $_POST['custom_type_label'] ) : array(),
				'existing_coupon'   => isset( $_POST['wlwl_existing_coupon'] ) ? array_map( 'sanitize_text_field', $_POST['wlwl_existing_coupon'] ) : array(),
				'probability'       => isset( $_POST['probability'] ) ? array_map( 'sanitize_text_field', $_POST['probability'] ) : array(),
				'prize_quantity'    => isset( $_POST['prize_quantity'] ) ? array_map( 'sanitize_text_field', $_POST['prize_quantity'] ) : array(),
				'bg_color'          => isset( $_POST['bg_color'] ) ? array_map( 'sanitize_text_field', $_POST['bg_color'] ) : array(),
				'slices_text_color' => isset( $_POST['slices_text_color'] ) ? array_map( 'sanitize_text_field', $_POST['slices_text_color'] ) : array(),
				'slice_text_color'  => isset( $_POST['slice_text_color'] ) ? wp_kses_post( stripslashes( $_POST['slice_text_color'] ) ) : "",
				'currency'          => isset( $_POST['wlwl_currency'] ) ? wp_kses_post( stripslashes( $_POST['wlwl_currency'] ) ) : "",
				'show_full_wheel'   => isset( $_POST['show_full_wheel'] ) ? sanitize_text_field( $_POST['show_full_wheel'] ) : "",
				'font_size'         => isset( $_POST['font_size'] ) ? sanitize_text_field( $_POST['font_size'] ) : "",
				'wheel_size'        => isset( $_POST['wheel_size'] ) ? sanitize_text_field( $_POST['wheel_size'] ) : "",
				'random_color'      => isset( $_POST['random_color'] ) ? sanitize_text_field( $_POST['random_color'] ) : "",
				'quantity_label'    => isset( $_POST['quantity_label'] ) ? sanitize_text_field( $_POST['quantity_label'] ) : "",
			),

			'result'                            => array(
				'auto_close'   => isset( $_POST['result-auto_close'] ) ? sanitize_text_field( $_POST['result-auto_close'] ) : 0,
				'email'        => array(
					'subject'     => isset( $_POST['subject'] ) ? stripslashes( sanitize_text_field( $_POST['subject'] ) ) : "",
					'heading'     => isset( $_POST['heading'] ) ? stripslashes( sanitize_text_field( $_POST['heading'] ) ) : "",
					'content'     => isset( $_POST['content'] ) ? wp_kses_post( $_POST['content'] ) : "",
					'footer_text' => isset( $_POST['footer_text'] ) ? stripslashes( sanitize_text_field( $_POST['footer_text'] ) ) : "",
				),
				'admin_email'  => array(
					'enable'  => isset( $_POST['admin_email_enable'] ) ? stripslashes( sanitize_text_field( $_POST['admin_email_enable'] ) ) : "",
					'address' => isset( $_POST['admin_email_address'] ) ? stripslashes( sanitize_text_field( $_POST['admin_email_address'] ) ) : "",
					'subject' => isset( $_POST['admin_email_subject'] ) ? stripslashes( sanitize_text_field( $_POST['admin_email_subject'] ) ) : "",
					'heading' => isset( $_POST['admin_email_heading'] ) ? stripslashes( sanitize_text_field( $_POST['admin_email_heading'] ) ) : "",
					'content' => isset( $_POST['admin_email_content'] ) ? wp_kses_post( $_POST['admin_email_content'] ) : "",
				),
				'notification' => array(
					'win'        => isset( $_POST['result_win'] ) ? wp_kses_post( stripslashes( $_POST['result_win'] ) ) : "",
					'win_custom' => isset( $_POST['result_win_custom'] ) ? wp_kses_post( stripslashes( $_POST['result_win_custom'] ) ) : "",
					'lost'       => isset( $_POST['result_lost'] ) ? wp_kses_post( stripslashes( $_POST['result_lost'] ) ) : "",
				)
			),
			'coupon'                            => array(
				'email_restriction'          => isset( $_POST['wlwl_email_restriction'] ) ? sanitize_text_field( $_POST['wlwl_email_restriction'] ) : 'no',
				'allow_free_shipping'        => isset( $_POST['wlwl_free_shipping'] ) ? sanitize_text_field( $_POST['wlwl_free_shipping'] ) : 'no',
				'expiry_date'                => isset( $_POST['wlwl_expiry_date'] ) ? sanitize_text_field( $_POST['wlwl_expiry_date'] ) : '',
				'min_spend'                  => isset( $_POST['wlwl_min_spend'] ) ? wc_format_decimal( $_POST['wlwl_min_spend'] ) : "",
				'max_spend'                  => isset( $_POST['wlwl_max_spend'] ) ? wc_format_decimal( $_POST['wlwl_max_spend'] ) : "",
				'individual_use'             => isset( $_POST['wlwl_individual_use'] ) ? sanitize_text_field( $_POST['wlwl_individual_use'] ) : "no",
				'exclude_sale_items'         => isset( $_POST['wlwl_exclude_sale_items'] ) ? sanitize_text_field( $_POST['wlwl_exclude_sale_items'] ) : "no",
				'limit_per_coupon'           => isset( $_POST['wlwl_limit_per_coupon'] ) ? wc_clean( absint( $_POST['wlwl_limit_per_coupon'] ) ) : "",
				'limit_to_x_items'           => isset( $_POST['wlwl_limit_to_x_items'] ) ? wc_clean( absint( $_POST['wlwl_limit_to_x_items'] ) ) : "",
				'limit_per_user'             => isset( $_POST['wlwl_limit_per_user'] ) ? wc_clean( absint( $_POST['wlwl_limit_per_user'] ) ) : "",
				'product_ids'                => isset( $_POST['wlwl_product_ids'] ) ? wc_clean( stripslashes_deep( $_POST['wlwl_product_ids'] ) ) : array(),
				'exclude_product_ids'        => isset( $_POST['wlwl_exclude_product_ids'] ) ? wc_clean( stripslashes_deep( $_POST['wlwl_exclude_product_ids'] ) ) : array(),
				'product_categories'         => isset( $_POST['wlwl_product_categories'] ) ? wc_clean( stripslashes_deep( $_POST['wlwl_product_categories'] ) ) : array(),
				'exclude_product_categories' => isset( $_POST['wlwl_exclude_product_categories'] ) ? wc_clean( stripslashes_deep( $_POST['wlwl_exclude_product_categories'] ) ) : array(),
				'coupon_code_prefix'         => isset( $_POST['wlwl_coupon_code_prefix'] ) ? sanitize_text_field( $_POST['wlwl_coupon_code_prefix'] ) : ""
			),
			'mailchimp'                         => array(
				'enable'       => isset( $_POST['mailchimp_enable'] ) ? sanitize_text_field( $_POST['mailchimp_enable'] ) : 'off',
				'double_optin' => isset( $_POST['mailchimp_double_optin'] ) ? sanitize_text_field( $_POST['mailchimp_double_optin'] ) : 'off',
				'api_key'      => isset( $_POST['mailchimp_api'] ) ? sanitize_text_field( $_POST['mailchimp_api'] ) : '',
				'lists'        => isset( $_POST['mailchimp_lists'] ) ? sanitize_text_field( $_POST['mailchimp_lists'] ) : '',
			),
			'active_campaign'                   => array(
				'enable' => isset( $_POST['wlwl_enable_active_campaign'] ) ? sanitize_text_field( $_POST['wlwl_enable_active_campaign'] ) : 'off',
				'key'    => isset( $_POST['wlwl_active_campaign_key'] ) ? sanitize_text_field( $_POST['wlwl_active_campaign_key'] ) : '',
				'url'    => isset( $_POST['wlwl_active_campaign_url'] ) ? sanitize_text_field( $_POST['wlwl_active_campaign_url'] ) : '',
				'list'   => isset( $_POST['wlwl_active_campaign_list'] ) ? sanitize_text_field( $_POST['wlwl_active_campaign_list'] ) : '',
			),
			'key'                               => isset( $_POST['wlwl_update_key'] ) ? sanitize_text_field( $_POST['wlwl_update_key'] ) : '',
			'button_shop_title'                 => isset( $_POST['wlwl_button_shop_title'] ) ? sanitize_text_field( $_POST['wlwl_button_shop_title'] ) : '',
			'button_shop_url'                   => isset( $_POST['wlwl_button_shop_url'] ) ? sanitize_text_field( $_POST['wlwl_button_shop_url'] ) : '',
			'button_shop_color'                 => isset( $_POST['wlwl_button_shop_color'] ) ? sanitize_text_field( $_POST['wlwl_button_shop_color'] ) : '',
			'button_shop_bg_color'              => isset( $_POST['wlwl_button_shop_bg_color'] ) ? sanitize_text_field( $_POST['wlwl_button_shop_bg_color'] ) : '',
			'button_shop_size'                  => isset( $_POST['wlwl_button_shop_size'] ) ? sanitize_text_field( $_POST['wlwl_button_shop_size'] ) : '',
			'suggested_products'                => isset( $_POST['wlwl_suggested_products'] ) ? wc_clean( stripslashes_deep( $_POST['wlwl_suggested_products'] ) ) : '',
			'sendgrid'                          => array(
				'enable' => isset( $_POST['wlwl_sendgrid_enable'] ) ? sanitize_text_field( $_POST['wlwl_sendgrid_enable'] ) : '',
				'key'    => isset( $_POST['wlwl_sendgrid_key'] ) ? stripslashes( sanitize_text_field( $_POST['wlwl_sendgrid_key'] ) ) : '',
				'list'   => isset( $_POST['sendgrid_lists'] ) ? stripslashes( sanitize_text_field( $_POST['sendgrid_lists'] ) ) : '',
			),
			'ajax_endpoint'                     => isset( $_POST['ajax_endpoint'] ) ? sanitize_text_field( $_POST['ajax_endpoint'] ) : 'ajax',
			'custom_field_mobile_enable'        => isset( $_POST['custom_field_mobile_enable'] ) ? sanitize_text_field( $_POST['custom_field_mobile_enable'] ) : '',
			'custom_field_mobile_enable_mobile' => isset( $_POST['custom_field_mobile_enable_mobile'] ) ? sanitize_text_field( $_POST['custom_field_mobile_enable_mobile'] ) : '',
			'custom_field_mobile_required'      => isset( $_POST['custom_field_mobile_required'] ) ? sanitize_text_field( $_POST['custom_field_mobile_required'] ) : '',
			'custom_field_name_enable'          => isset( $_POST['custom_field_name_enable'] ) ? sanitize_text_field( $_POST['custom_field_name_enable'] ) : '',
			'custom_field_name_enable_mobile'   => isset( $_POST['custom_field_name_enable_mobile'] ) ? sanitize_text_field( $_POST['custom_field_name_enable_mobile'] ) : '',
			'custom_field_name_required'        => isset( $_POST['custom_field_name_required'] ) ? sanitize_text_field( $_POST['custom_field_name_required'] ) : '',
			'button_apply_coupon'               => isset( $_POST['wlwl_button_apply_coupon'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon'] ) : '',
			'button_apply_coupon_redirect'      => isset( $_POST['wlwl_button_apply_coupon_redirect'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon_redirect'] ) : '',
			'button_apply_coupon_color'         => isset( $_POST['wlwl_button_apply_coupon_color'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon_color'] ) : '',
			'button_apply_coupon_bg_color'      => isset( $_POST['wlwl_button_apply_coupon_bg_color'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon_bg_color'] ) : '',
			'button_apply_coupon_font_size'     => isset( $_POST['wlwl_button_apply_coupon_font_size'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon_font_size'] ) : '',
			'button_apply_coupon_border_radius' => isset( $_POST['wlwl_button_apply_coupon_border_radius'] ) ? sanitize_text_field( $_POST['wlwl_button_apply_coupon_border_radius'] ) : '',
			'metrilo_enable'                    => isset( $_POST['wlwl_metrilo_enable'] ) ? sanitize_text_field( $_POST['wlwl_metrilo_enable'] ) : '',
			'metrilo_token'                     => isset( $_POST['wlwl_metrilo_token'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_metrilo_token'] ) ) : '',
			'metrilo_tag'                       => isset( $_POST['wlwl_metrilo_tag'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_metrilo_tag'] ) ) : '',
			'metrilo_subscribed'                => isset( $_POST['wlwl_metrilo_subscribed'] ) ? sanitize_text_field( $_POST['wlwl_metrilo_subscribed'] ) : '',
			'wlwl_enable_hubspot'               => isset( $_POST['wlwl_enable_hubspot'] ) ? sanitize_text_field( $_POST['wlwl_enable_hubspot'] ) : '',
			'wlwl_hubspot_api'                  => isset( $_POST['wlwl_hubspot_api'] ) ? stripslashes( sanitize_text_field( $_POST['wlwl_hubspot_api'] ) ) : '',
			'wlwl_enable_klaviyo'               => isset( $_POST['wlwl_enable_klaviyo'] ) ? sanitize_text_field( $_POST['wlwl_enable_klaviyo'] ) : '',
			'wlwl_klaviyo_api'                  => isset( $_POST['wlwl_klaviyo_api'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_klaviyo_api'] ) ) : '',
			'wlwl_klaviyo_list'                 => isset( $_POST['wlwl_klaviyo_list'] ) ? wc_clean( $_POST['wlwl_klaviyo_list'] ) : '',
			'wlwl_enable_sendinblue'            => isset( $_POST['wlwl_enable_sendinblue'] ) ? sanitize_text_field( $_POST['wlwl_enable_sendinblue'] ) : '',
			'wlwl_sendinblue_api'               => isset( $_POST['wlwl_sendinblue_api'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_sendinblue_api'] ) ) : '',
			'wlwl_sendinblue_list'              => isset( $_POST['wlwl_sendinblue_list'] ) ? wc_clean( $_POST['wlwl_sendinblue_list'] ) : [],
			'wlwl_enable_mailpoet'              => isset( $_POST['wlwl_enable_mailpoet'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_enable_mailpoet'] ) ) : '',
			'wlwl_mailpoet_list'                => isset( $_POST['wlwl_mailpoet_list'] ) ? wc_clean( $_POST['wlwl_mailpoet_list'] ) : [],
			'wlwl_enable_mailster'              => isset( $_POST['wlwl_enable_mailster'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_enable_mailster'] ) ) : '',
			'wlwl_mailster_list'                => isset( $_POST['wlwl_mailster_list'] ) ? wc_clean( $_POST['wlwl_mailster_list'] ) : [],
			'wlwl_enable_sendy'                 => isset( $_POST['wlwl_enable_sendy'] ) ? sanitize_text_field( stripslashes( $_POST['wlwl_enable_sendy'] ) ) : '',
			'wlwl_sendy_api'                    => isset( $_POST['wlwl_sendy_api'] ) ? wc_clean( $_POST['wlwl_sendy_api'] ) : '',
			'wlwl_sendy_login_url'              => isset( $_POST['wlwl_sendy_login_url'] ) ? wc_clean( $_POST['wlwl_sendy_login_url'] ) : '',
			'wlwl_sendy_brand'                  => isset( $_POST['wlwl_sendy_brand'] ) ? wc_clean( $_POST['wlwl_sendy_brand'] ) : '',
			'wlwl_sendy_list'                   => isset( $_POST['wlwl_sendy_list'] ) ? wc_clean( $_POST['wlwl_sendy_list'] ) : '',
			'wlwl_recaptcha_site_key'           => isset( $_POST['wlwl_recaptcha_site_key'] ) ? wc_clean( $_POST['wlwl_recaptcha_site_key'] ) : '',
			'wlwl_recaptcha_version'            => isset( $_POST['wlwl_recaptcha_version'] ) ? wc_clean( $_POST['wlwl_recaptcha_version'] ) : '',
			'wlwl_recaptcha_secret_theme'       => isset( $_POST['wlwl_recaptcha_secret_theme'] ) ? wc_clean( $_POST['wlwl_recaptcha_secret_theme'] ) : '',
			'wlwl_recaptcha_secret_key'         => isset( $_POST['wlwl_recaptcha_secret_key'] ) ? wc_clean( $_POST['wlwl_recaptcha_secret_key'] ) : '',
			'wlwl_recaptcha'                    => isset( $_POST['wlwl_recaptcha'] ) ? wc_clean( $_POST['wlwl_recaptcha'] ) : '',
			'choose_using_white_black_list'     => isset( $_POST['choose_using_white_black_list'] ) ? wc_clean( $_POST['choose_using_white_black_list'] ) : 'black_list',
			'white_list'                        => isset( $_POST['white_list'] ) ? sanitize_textarea_field( $_POST['white_list'] ) : '',
			'black_list'                        => isset( $_POST['black_list'] ) ? sanitize_textarea_field( $_POST['black_list'] ) : '',
		);
		if ( $this->languages_count ) {
			foreach ( $this->languages as $key => $value ) {
				$args['result'][ 'email_' . $value ]              = array(
					'subject'     => isset( $_POST[ 'subject_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'subject_' . $value ] ) ) : "",
					'heading'     => isset( $_POST[ 'heading_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'heading_' . $value ] ) ) : "",
					'content'     => isset( $_POST[ 'content_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'content_' . $value ] ) ) : "",
					'footer_text' => isset( $_POST[ 'footer_text_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'footer_text_' . $value ] ) ) : "",
				);
				$args['result'][ 'notification_' . $value ]       = array(
					'win'        => isset( $_POST[ 'result_win_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'result_win_' . $value ] ) ) : "",
					'win_custom' => isset( $_POST[ 'result_win_custom_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'result_win_custom_' . $value ] ) ) : "",
					'lost'       => isset( $_POST[ 'result_lost_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'result_lost_' . $value ] ) ) : "",
				);
				$args['wheel'][ 'custom_label_' . $value ]        = isset( $_POST[ 'custom_type_label_' . $value ] ) ? array_map( 'wlwl_sanitize_text_field', $_POST[ 'custom_type_label_' . $value ] ) : array();
				$args['wheel'][ 'email_templates_' . $value ]     = isset( $_POST[ 'email_templates_' . $value ] ) ? array_map( 'sanitize_text_field', $_POST[ 'email_templates_' . $value ] ) : array();
				$args['wheel'][ 'quantity_label_' . $value ]      = isset( $_POST[ 'quantity_label_' . $value ] ) ? sanitize_text_field( $_POST[ 'quantity_label_' . $value ] ) : '';
				$args[ 'button_shop_title_' . $value ]            = isset( $_POST[ 'wlwl_button_shop_title_' . $value ] ) ? sanitize_text_field( $_POST[ 'wlwl_button_shop_title_' . $value ] ) : '';
				$args[ 'button_shop_url_' . $value ]              = isset( $_POST[ 'wlwl_button_shop_url_' . $value ] ) ? sanitize_text_field( $_POST[ 'wlwl_button_shop_url_' . $value ] ) : '';
				$args['wheel_wrap'][ 'spin_button_' . $value ]    = isset( $_POST[ 'wheel_wrap_spin_button_' . $value ] ) ? sanitize_text_field( $_POST[ 'wheel_wrap_spin_button_' . $value ] ) : '';
				$args['wheel_wrap'][ 'description_' . $value ]    = isset( $_POST[ 'wheel_wrap_description_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'wheel_wrap_description_' . $value ] ) ) : '';
				$args['wheel_wrap'][ 'gdpr_message_' . $value ]   = isset( $_POST[ 'gdpr_message_' . $value ] ) ? wp_kses_post( stripslashes( $_POST[ 'gdpr_message_' . $value ] ) ) : '';
				$args['mailchimp'][ 'lists_' . $value ]           = isset( $_POST[ 'mailchimp_lists_' . $value ] ) ? sanitize_text_field( $_POST[ 'mailchimp_lists_' . $value ] ) : '';
				$args[ 'button_apply_coupon_redirect_' . $value ] = isset( $_POST[ 'wlwl_button_apply_coupon_redirect_' . $value ] ) ? sanitize_text_field( $_POST[ 'wlwl_button_apply_coupon_redirect_' . $value ] ) : '';
				$args[ 'metrilo_tag_' . $value ]                  = isset( $_POST[ 'wlwl_metrilo_tag_' . $value ] ) ? sanitize_text_field( stripslashes( $_POST[ 'wlwl_metrilo_tag_' . $value ] ) ) : '';
				$args[ 'wlwl_sendy_list_' . $value ]              = isset( $_POST[ 'wlwl_sendy_list_' . $value ] ) ? wc_clean( $_POST[ 'wlwl_sendy_list_' . $value ] ) : '';
			}
		}
		if ( isset( $_POST['wlwl_save_settings'] ) || isset( $_POST['wlwl_check_key'] ) ) {
			if ( $_POST['probability'] ) {
				if ( count( $_POST['probability'] ) < 3 ) {
					wp_die( 'There must be at least 3 rows!' );
				}
				if ( array_sum( $_POST['probability'] ) < 1 ) {
					wp_die( 'The total probability must be greater than 0!' );
				}
				for ( $i = 0; $i < sizeof( wc_clean( $_POST['coupon_type'] ) ); $i ++ ) {
					if ( in_array( $_POST['coupon_type'][ $i ], array( 'fixed_cart', 'fixed_product', 'percent' ) ) ) {
						if ( $_POST['coupon_amount'][ $i ] < 0 ) {
							wp_die( 'The amount of Valued-coupon must be greater than or equal to zero!' );
						}
					}
				}
			}
			if ( isset( $_POST['custom_type_label'] ) && is_array( $_POST['custom_type_label'] ) ) {
				foreach ( wc_clean( $_POST['custom_type_label'] ) as $key => $val ) {
					if ( $_POST['custom_type_label'][ $key ] === '' ) {
						add_action( 'admin_notices', function () {
							?>
                            <div class="updated">
                                <p><?php esc_html_e( 'Label cannot be empty.', 'woocommerce-lucky-wheel' ) ?></p>
                            </div>
							<?php
						} );

						return;
					}
					if ( isset( $_POST['wlwl_existing_coupon'] ) && is_array( $_POST['wlwl_existing_coupon'] ) ) {
						if ( $_POST['coupon_type'][ $key ] == 'existing_coupon' && $_POST['wlwl_existing_coupon'][ $key ] == '' ) {
							add_action( 'admin_notices', function () {
								?>
                                <div class="updated">
                                    <p><?php esc_html_e( 'Please enter value for existing coupon.', 'woocommerce-lucky-wheel' ) ?></p>
                                </div>
								<?php
							} );

							return;
						}
					}
					if ( isset( $_POST['custom_type_value'] ) && is_array( $_POST['custom_type_value'] ) ) {
						if ( $_POST['coupon_type'][ $key ] == 'custom' && $_POST['custom_type_value'][ $key ] == '' ) {
							add_action( 'admin_notices', function () {
								?>
                                <div class="updated">
                                    <p><?php esc_html_e( 'Please enter value for custom type.', 'woocommerce-lucky-wheel' ) ?></p>
                                </div>
								<?php
							} );

							return;
						}
					}
					if ( isset( $_POST['wlwl_existing_coupon'] ) && is_array( $_POST['wlwl_existing_coupon'] ) ) {
						if ( $_POST['coupon_type'][ $key ] == 'existing_coupon' && ( $_POST['wlwl_existing_coupon'][ $key ] == 0 ) ) {
							add_action( 'admin_notices', function () {
								?>
                                <div class="updated">
                                    <p><?php esc_html_e( 'Please enter value for existing coupon.', 'woocommerce-lucky-wheel' ) ?></p>
                                </div>
								<?php
							} );

							return;
						}
					}
				}
			}

			if ( isset( $_POST['wlwl_check_key'] ) ) {
				delete_transient( 'update_plugins' );
				delete_transient( 'villatheme_item_12884' );
				delete_option( 'woocommerce-lucky-wheel_messages' );
				do_action( 'villatheme_save_and_check_key_woocommerce-lucky-wheel', $args['key'] );
			}
			$args = wp_parse_args( $args, get_option( '_wlwl_settings', $woo_lucky_wheel_settings ) );
			update_option( '_wlwl_settings', $args );
			$woo_lucky_wheel_settings = $args;
			$this->settings           = VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::get_instance( true );
			add_action( 'admin_notices', function () {
				?>
                <div class="updated">
                    <p><?php esc_html_e( 'Your settings of WooCommerce Lucky Wheel have been saved!', 'woocommerce-lucky-wheel' ) ?></p>
                </div>
				<?php
			} );
		}
	}

	public function report_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$total_spin = $email_subscribe = $coupon_given = 0;

		$args      = array(
			'post_type'      => 'wlwl_email',
			'posts_per_page' => - 1,
			'post_status'    => 'publish',
		);
		$the_query = new WP_Query( $args );
		if ( $the_query->have_posts() ) {
			$email_subscribe = $the_query->post_count;
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$id = get_the_ID();
				if ( get_post_meta( $id, 'wlwl_spin_times', true ) ) {
					$total_spin += get_post_meta( $id, 'wlwl_spin_times', true )['spin_num'];
				}
				if ( get_post_meta( $id, 'wlwl_email_coupons', true ) ) {
					$coupon       = get_post_meta( $id, 'wlwl_email_coupons', true );
					$coupon_given += sizeof( $coupon );
				}
			}
			wp_reset_postdata();
		}

		?>
        <div class="wrap">
            <form action="" method="post">
                <h2><?php esc_html_e( 'Lucky Wheel Report', 'woocommerce-lucky-wheel' ) ?></h2>

                <table cellspacing="0" id="status" class="widefat">
                    <tbody>
                    <tr>
                        <th><?php esc_html_e( 'Total Spins', 'woocommerce-lucky-wheel' ) ?></th>
                        <th><?php esc_html_e( 'Emails Subcribed', 'woocommerce-lucky-wheel' ) ?></th>
                        <th><?php esc_html_e( 'Coupon Given', 'woocommerce-lucky-wheel' ) ?></th>
                    </tr>
                    <tr>
                        <td><?php echo esc_html( $total_spin ); ?></td>
                        <td><?php echo esc_html( $email_subscribe ); ?></td>
                        <td><?php echo esc_html( $coupon_given ); ?></td>
                    </tr>
                    </tbody>

                </table>
                <label for="wlwl_export_start"><?php esc_html_e( 'From', 'woocommerce-lucky-wheel' ); ?></label><input
                        type="date" name="wlwl_export_start" id="wlwl_export_start" class="wlwl_export_date">
                <label for="wlwl_export_end"><?php esc_html_e( 'To', 'woocommerce-lucky-wheel' ); ?></label><input
                        type="date" name="wlwl_export_end" id="wlwl_export_end" class="wlwl_export_date">

                <input id="submit"
                       type="submit"
                       class="button-primary"
                       name="wlwl_export_emails"
                       value="<?php esc_html_e( 'Export Emails', 'woocommerce-lucky-wheel' ); ?>"/>
				<?php
				wp_nonce_field( 'wlwl_export_emails_nonce_action', 'wlwl_export_emails_nonce' );
				?>
            </form>
        </div>
		<?php
	}

	function system_status() {
		?>
        <div class="wrap">
            <h2><?php esc_html_e( 'System Status', 'woocommerce-lucky-wheel' ) ?></h2>
            <table cellspacing="0" id="status" class="widefat">
                <thead>
                <tr>
                    <th><?php esc_html_e( 'Option name', 'woocommerce-lucky-wheel' ) ?></th>
                    <th><?php esc_html_e( 'Your option value', 'woocommerce-lucky-wheel' ) ?></th>
                    <th><?php esc_html_e( 'Minimum recommended value', 'woocommerce-lucky-wheel' ) ?></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td data-export-label="file_get_contents">file_get_contents</td>
                    <td>
						<?php
						if ( function_exists( 'file_get_contents' ) ) {
							?>
                            <mark class="yes">&#10004; <code class="private"></code></mark>
							<?php
						} else {
							?>
                            <mark class="error">&#10005;</mark>'
							<?php
						}
						?>
                    </td>
                    <td><?php esc_html_e( 'Required', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
                <tr>
                    <td data-export-label="file_put_contents">file_put_contents</td>
                    <td>
						<?php
						if ( function_exists( 'file_put_contents' ) ) {
							?>
                            <mark class="yes">&#10004; <code class="private"></code></mark>
							<?php
						} else {
							?>
                            <mark class="error">&#10005;</mark>
							<?php
						}
						?>

                    </td>
                    <td><?php esc_html_e( 'Required', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
                <tr>
                    <td data-export-label="mkdir">mkdir</td>
                    <td>
						<?php
						if ( function_exists( 'mkdir' ) ) {
							?>
                            <mark class="yes">&#10004; <code class="private"></code></mark>
							<?php
						} else {
							?>
                            <mark class="error">&#10005;</mark>
							<?php
						}
						?>

                    </td>
                    <td><?php esc_html_e( 'Required', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
				<?php
				$max_execution_time = ini_get( 'max_execution_time' );
				$max_input_vars     = ini_get( 'max_input_vars' );
				$memory_limit       = ini_get( 'memory_limit' );
				?>
                <tr>
                    <td data-export-label="<?php esc_attr_e( 'PHP Time Limit', 'woocommerce-lucky-wheel' ) ?>"><?php esc_html_e( 'PHP Time Limit', 'woocommerce-lucky-wheel' ) ?></td>
                    <td style="<?php if ( $max_execution_time > 0 && $max_execution_time < 300 ) {
						echo esc_attr( 'color:red' );
					} ?>"><?php esc_html_e( $max_execution_time ); ?></td>
                    <td><?php esc_html_e( '300', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
                <tr>
                    <td data-export-label="<?php esc_attr_e( 'PHP Max Input Vars', 'woocommerce-lucky-wheel' ) ?>"><?php esc_html_e( 'PHP Max Input Vars', 'woocommerce-lucky-wheel' ) ?></td>
                    <td style="<?php if ( $max_input_vars < 1000 ) {
						echo esc_attr( 'color:red' );
					} ?>"><?php esc_html_e( $max_input_vars ); ?></td>
                    <td><?php esc_html_e( '5000', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
                <tr>
                    <td data-export-label="<?php esc_attr_e( 'Memory Limit', 'woocommerce-lucky-wheel' ) ?>"><?php esc_html_e( 'Memory Limit', 'woocommerce-lucky-wheel' ) ?></td>
                    <td style="<?php if ( intval( $memory_limit ) < 64 ) {
						echo esc_attr( 'color:red' );
					} ?>"><?php esc_html_e( $memory_limit ); ?></td>
                    <td><?php esc_html_e( '64M', 'woocommerce-lucky-wheel' ) ?></td>
                </tr>
                </tbody>
            </table>
        </div>
		<?php
	}

	public static function auto_color() {
		$palette     = '{
  "red": {
    "100": "#ffcdd2",
    "900": "#b71c1c",
    "300": "#e57373",
    "600": "#e53935"
  },
  "purple": {
    "100": "#e1bee7",
    "900": "#4a148c",
    "300": "#ba68c8",
    "600": "#8e24aa"
  },
  "deeppurple": {
    "100": "#d1c4e9",
    "900": "#311b92",
     "300": "#9575cd",
    "600": "#5e35b1"
  },
  "indigo": {
    "100": "#c5cae9",
    "900": "#1a237e",
    "300": "#7986cb",
    "600": "#3949ab"
  },
  "blue": {
    "100": "#bbdefb",
     "300": "#64b5f6",
    "600": "#1e88e5",
    "900": "#0d47a1"
  },
  "teal": {
    "100": "#b2dfdb",
    "900": "#004d40",
    "300": "#4db6ac",
    "600": "#00897b"
  },
  "green": {
    "100": "#c8e6c9",
    "900": "#1b5e20",
    "300": "#81c784",
    "600": "#43a047"
  },
  "lime": {
    "100": "#f0f4c3",
    "900": "#827717",
     "300": "#dce775",
    "600": "#c0ca33"
  },
  "yellow": {
    "100": "#fff9c4",
    "900": "#f57f17",
    "300": "#fff176",
    "600": "#fdd835"
  },
  "orange": {
    "100": "#ffe0b2",
    "900": "#e65100",
    "300": "#ffb74d",
    "600": "#fb8c00"
  },
  "brown": {
    "100": "#d7ccc8",
    "900": "#3e2723",
     "300": "#a1887f",
    "600": "#6d4c41"
  },
  "bluegrey": {
    "100": "#cfd8dc",
    "900": "#263238",
    "300": "#90a4ae",
    "600": "#546e7a"
  }
}';
		$palette     = json_decode( $palette );
		$color_array = array();
		foreach ( $palette as $colors ) {
			$color_row = array();
			foreach ( $colors as $color ) {
				$color_row[] = $color;
			}
			$color_array[] = $color_row;
		}
		$color_array[] = array(
			'#e6194b',
			'#3cb44b',
			'#ffe119',
			'#0082c8',
			'#f58231',
			'#911eb4',
			'#46f0f0',
			'#f032e6',
			'#d2f53c',
			'#fabebe',
			'#008080',
			'#e6beff',
			'#aa6e28',
			'#fffac8',
			'#800000',
			'#aaffc3',
			'#808000',
			'#ffd8b1',
			'#000080',
			'#808080',
			'#FFFFFF',
			'#000000'
		);
		echo '<div class="color_palette" style="display: none;">';
		foreach ( $color_array as $colors ) {
			echo '<div>';
			$i = 0;
			foreach ( $colors as $color ) {
				echo '<div class="wlwl_color_palette" data-color_code="' . $color . '" style="width: 20px;height: 20px;float:left;border:1px solid #ffffff;background-color: ' . $color . ';';
				if ( $i == ( sizeof( $colors ) - 1 ) ) {
					echo 'display:block;';
				} else {
					echo 'display:none;';
				}
				echo '"></div>';
				$i ++;
			}
			echo '</div>';
		}

		echo '</div>';
		echo '<div class="auto_color_ok_cancel"><div class="vi-ui buttons tiny"><span class="auto_color_ok positive vi-ui button tiny">' . esc_html__( 'OK', 'woocommerce-lucky-wheel' ) . '</span>';
		echo '<div class="or"></div><span class="auto_color_cancel vi-ui button tiny">' . esc_html__( 'Cancel', 'woocommerce-lucky-wheel' ) . '</span></div></div>';
	}

	public static function get_email_templates( $type = 'wlwl_coupon_email' ) {
		$email_templates = array();
		if ( VI_WOOCOMMERCE_LUCKY_WHEEL_DATA::is_email_template_customizer_active() ) {
			$email_templates = viwec_get_emails_list( $type );
		}

		return $email_templates;
	}

	public function print_default_country_flag() {
		if ( $this->languages_count ) {
			?>
            <p>
                <label><?php
					if ( isset( $this->languages_data[ $this->default_language ]['country_flag_url'] ) && $this->languages_data[ $this->default_language ]['country_flag_url'] ) {
						?>
                        <img src="<?php echo esc_url( $this->languages_data[ $this->default_language ]['country_flag_url'] ); ?>">
						<?php
					}
					echo esc_html( $this->default_language );
					if ( isset( $this->languages_data[ $this->default_language ]['translated_name'] ) ) {
						echo '(' . esc_html( $this->languages_data[ $this->default_language ]['translated_name'] ) . '):';
					}
					?></label>
            </p>
			<?php
		}
	}
}